<?php include("header.php"); 


$show_ticket = false;
$ticket_data = null;
$responses = [];
$ticket_closed = false;
$ticket_error = null;

if (g("operation") === "close" && $ticket_id) {
    $stmt = $baglan->prepare("UPDATE support_tickets SET status='closed', updated_at=NOW() WHERE id=? AND user_id=?");
    $stmt->bind_param("ii", $ticket_id, $user_id);
    if ($stmt->execute()) {
        echo "<meta http-equiv='refresh' content='0;URL=support/$ticket_id?status=closed'>";
        exit;
    } else {
        $ticket_error = "Talep kapatılamadı. Lütfen tekrar deneyin.";
    }
    $stmt->close();
}

if ($_SERVER['REQUEST_METHOD'] === 'POST' && null !== p('new_ticket')) {
    $subject = trim(p('subject') ?? '');
    $description = trim(p('description') ?? '');
    $product = trim(p('product') ?? '');
    if ($subject !== '' && $description !== '') {
        $stmt = $baglan->prepare("INSERT INTO support_tickets (user_id, subject, description, status, product, created_at, updated_at) VALUES (?, ?, ?, 'open', ?, NOW(), NOW())");
        $stmt->bind_param("isss", $user_id, $subject, $description, $product);
        if ($stmt->execute()) {
            echo "<meta http-equiv='refresh' content='0;URL=support/?status=success'>";
            exit;
        } else {
            $ticket_error = "Talep oluşturulamadı. Lütfen tekrar deneyin.";
        }
        $stmt->close();
    } else {
        $ticket_error = "Konu ve açıklama zorunludur.";
    }
}

if ($_SERVER['REQUEST_METHOD'] === 'POST' && null !== p('reply_ticket') && $ticket_id) {
    $response = trim(p('response') ?? '');
    $stmt = $baglan->prepare("SELECT status FROM support_tickets WHERE id=? AND user_id=? LIMIT 1");
    $stmt->bind_param("ii", $ticket_id, $user_id);
    $stmt->execute();
    $stmt->bind_result($ticket_status);
    if ($stmt->fetch()) {
        if ($ticket_status === 'closed') {
            $ticket_error = "Bu talep kapatılmıştır, yeni yanıt gönderilemez.";
        } elseif ($response !== '') {
            $stmt->close();
            $stmt2 = $baglan->prepare("INSERT INTO support_responses (ticket_id, response, created_at, user_id) VALUES (?, ?, NOW(), ?)");
            $stmt2->bind_param("isi", $ticket_id, $response, $user_id);
            if ($stmt2->execute()) {
                $baglan->query("UPDATE support_tickets SET updated_at=NOW() WHERE id=" . intval($ticket_id));
                echo "<meta http-equiv='refresh' content='0;URL=support/$ticket_id?status=reply_success'>";
                exit;
            } else {
                $ticket_error = "Yanıt gönderilemedi. Lütfen tekrar deneyin.";
            }
            $stmt2->close();
        } else {
            $ticket_error = "Yanıt boş olamaz.";
        }
    }
    $stmt->close();
}

if ($ticket_id) {
    $stmt = $baglan->prepare("SELECT * FROM support_tickets WHERE id=? AND user_id=? LIMIT 1");
    $stmt->bind_param("ii", $ticket_id, $user_id);
    $stmt->execute();
    $result = $stmt->get_result();
    if ($result && $result->num_rows > 0) {
        $show_ticket = true;
        $ticket_data = $result->fetch_assoc();
        $ticket_closed = ($ticket_data['status'] === 'closed');
        $stmt2 = $baglan->prepare("SELECT * FROM support_responses WHERE ticket_id=? ORDER BY created_at ASC, id ASC");
        $stmt2->bind_param("i", $ticket_id);
        $stmt2->execute();
        $res = $stmt2->get_result();
        while ($row = $res->fetch_assoc()) {
            $responses[] = $row;
        }
        $stmt2->close();
    }
    $stmt->close();
}

$tickets = [];
$stmt = $baglan->prepare("SELECT * FROM support_tickets WHERE user_id=? ORDER BY updated_at DESC");
$stmt->bind_param("i", $user_id);
$stmt->execute();
$result = $stmt->get_result();
if ($result && $result->num_rows > 0) {
    while ($row = $result->fetch_assoc()) {
        $tickets[] = $row;
    }
}
$stmt->close();
?>
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<div class="container">
<div class="desktop" style="margin-top:50px;"></div>
<div class="mobile" style="margin-top:-10px;"></div>
  <div class="row">
    <div class="col-lg-3 mb-4">
      <?php include("navigation.php"); ?>
    </div>
    <div class="col-lg-9">
      <div class="support-main-card">
        <div class="support-main-body">
          <div class="modal fade" id="closeticketmodal" tabindex="-1" aria-labelledby="closeTicketModalLabel" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered">
              <form method="post" class="modal-content border-0 rounded-4 shadow-sm">
                <div class="modal-header border-0">
                  <h5 class="modal-title" id="closeTicketModalLabel">Talebi Kapat</h5>
                  <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Kapat"></button>
                </div>
                <div class="modal-body text-center">
                  <i class="fa fa-exclamation-triangle text-danger fs-2 mb-3"></i>
                  <p class="mb-0">Bu talebi gerçekten kapatmak istediğinize emin misiniz?</p>
                </div>
                <div class="modal-footer border-0 justify-content-center">
                  <a type="submit" href="support/<?php echo $ticket_id;?>?operation=close" class="btn btn-danger px-4">Evet, Kapat</a>
                  <button type="button" class="btn btn-light" data-bs-dismiss="modal">İptal</button>
                </div>
              </form>
            </div>
          </div>
          <?php if ($show_ticket && $ticket_data): ?>
            <div class="d-flex align-items-center mb-4 gap-2">
              <a href="support/" class="btn btn-link p-0 text-decoration-none text-secondary" title="Taleplere Dön"><i class="fas fa-arrow-left"></i></a>
              <h2 class="mb-0 fw-semibold fs-4">Destek Talebi Detayı</h2>
            </div>
            <?php if ($status == 'reply_success'): ?>
              <div class="alert alert-success mb-3">Yanıtınız başarıyla gönderildi.</div>
            <?php endif; ?>
            <?php if ($status == 'closed'): ?>
              <div class="alert alert-success mb-3">Talep başarıyla kapatıldı.</div>
            <?php endif; ?>
            <?php if ($ticket_error): ?>
              <div class="alert alert-danger mb-3"><?php echo htmlspecialchars($ticket_error); ?></div>
            <?php endif; ?>
            <div class="ticket-info-box mb-4">
              <div class="row g-3">
                <div class="col-md-6">
                  <div class="info-label">Konu</div>
                  <div class="info-value"><?php echo htmlspecialchars($ticket_data['subject']); ?></div>
                </div>
                <div class="col-md-3">
                  <div class="info-label">Sipariş No</div>
                  <div class="info-value">#<?php echo htmlspecialchars($ticket_data['product']); ?></div>
                </div>
                <div class="col-md-3">
                  <div class="info-label">Durum</div>
                  <div class="info-value">
                    <?php if ($ticket_data['status'] === 'closed'): ?>
                      <span class="badge rounded-pill bg-danger px-3 py-1">Kapalı</span>
                    <?php else: ?>
                      <span class="badge rounded-pill bg-success px-3 py-1">Açık</span>
                    <?php endif; ?>
                  </div>
                </div>
                <div class="col-md-6">
                  <div class="info-label">Oluşturulma</div>
                  <div class="info-value"><?php echo date('d.m.Y H:i', strtotime($ticket_data['created_at'])); ?></div>
                </div>
              </div>
            </div>
            <div class="mb-4">
              <h5 class="mb-3 fw-semibold">Sohbet</h5>
              <div class="support-chat-box">
                <?php
                  $all_messages = [];
                  $all_messages[] = [
                    'response' => $ticket_data['description'],
                    'created_at' => $ticket_data['created_at'],
                    'user_id' => $user_id,
                    'is_initial' => true
                  ];
                  foreach ($responses as $resp) {
                    $resp['is_initial'] = false;
                    $all_messages[] = $resp;
                  }
                ?>
                <?php if (count($all_messages) == 0): ?>
                  <div class="alert alert-info">Henüz mesaj yok.</div>
                <?php else: ?>
                  <?php foreach ($all_messages as $msg): ?>
                    <?php
                      $is_user = ($msg['user_id'] == $user_id);
                      $is_support = (empty($msg['user_id']) || $msg['user_id'] == 0);
                      $is_initial = !empty($msg['is_initial']);
                    ?>
                    <div class="support-chat-row <?php echo $is_user ? 'justify-end' : 'justify-start'; ?>">
                      <div class="support-chat-bubble<?php echo $is_initial ? ' initial' : ''; ?><?php echo $is_user ? ' user' : ' support'; ?>">
                        <div class="support-chat-meta mb-1">
                          <?php if ($is_initial): ?>
                            <span class="text-primary"><i class="fa fa-user"></i> Siz (Talep Başlangıcı)</span>
                          <?php elseif ($is_support): ?>
                            <span class="text-info"><i class="fa fa-headset"></i> Destek Ekibi</span>
                          <?php elseif ($is_user): ?>
                            <span class="text-primary"><i class="fa fa-user"></i> Siz</span>
                          <?php endif; ?>
                        </div>
                        <div class="support-chat-text"><?php echo nl2br(htmlspecialchars($msg['response'])); ?></div>
                        <div class="support-chat-date"><?php echo date('d.m.Y H:i', strtotime($msg['created_at'])); ?></div>
                      </div>
                    </div>
                  <?php endforeach; ?>
                <?php endif; ?>
              </div>
            </div>
            <?php if (!$ticket_closed): ?>
              <form method="post" class="mb-3">
                <div class="mb-3">
                  <label for="response" class="form-label">Yanıtınız</label>
                  <textarea name="response" id="response" class="form-control" rows="3" required style="resize:vertical;min-height:60px;max-height:180px;"></textarea>
                </div>
                <div class="d-flex flex-wrap gap-2">
                  <button type="submit" name="reply_ticket" class="btn btn-primary px-4">Yanıt Gönder</button>
                  <a class="btn btn-outline-danger" data-bs-toggle="modal" data-bs-target="#closeticketmodal"><i class="fa fa-lock"></i> Talebi Kapat</a>
                </div>
              </form>
            <?php endif; ?>
          <?php else: ?>
            <div class="d-flex justify-content-between align-items-center mb-4 flex-wrap gap-2">
              <h2 class="mb-0 fw-semibold fs-4">Destek Taleplerim</h2>
              <?php if($demo_mode == 1){ ?> 
                <button class="btn btn-success px-4" data-bs-toggle="modal" data-bs-target="#demo_modal"><i class="fa fa-plus"></i> Yeni Talep Oluştur</button>
              <?php }else{ ?>
                <button class="btn btn-success px-4" data-bs-toggle="modal" data-bs-target="#newTicketModal"><i class="fa fa-plus"></i> Yeni Talep Oluştur</button>
              <?php } ?>
            </div>
            <?php if ($status == 'success'): ?>
              <div class="alert alert-success mb-3">Talebiniz başarıyla oluşturuldu.</div>
            <?php endif; ?>
            <?php if ($ticket_error): ?>
              <div class="alert alert-danger mb-3"><?php echo htmlspecialchars($ticket_error); ?></div>
            <?php endif; ?>
            <?php if (count($tickets) > 0): ?>
              <div class="table-responsive mb-4">
                <table class="table table-hover align-middle support-table">
                  <thead class="table-light">
                    <tr>
                      <th class="text-center" style="width:60px;">#</th>
                      <th>Konu</th>
                      <th>Durum</th>
                      <th>Son Mesaj</th>
                      <th class="text-center" style="width:100px;">Detay</th>
                    </tr>
                  </thead>
                  <tbody>
                    <?php foreach ($tickets as $ticket): ?>
                      <tr>
                        <td class="text-center"><?php echo htmlspecialchars($ticket['id']); ?></td>
                        <td><?php echo htmlspecialchars($ticket['subject']); ?></td>
                        <td>
                          <?php if ($ticket['status'] === 'closed'): ?>
                            <span class="badge rounded-pill bg-danger px-3 py-1">Kapalı</span>
                          <?php else: ?>
                            <span class="badge rounded-pill bg-success px-3 py-1">Açık</span>
                          <?php endif; ?>
                        </td>
                        <td><?php echo date('d.m.Y H:i', strtotime($ticket['updated_at'])); ?></td>
                        <td class="text-center">
                          <a href="support/<?php echo urlencode($ticket['id']); ?>" class="btn btn-sm btn-outline-primary px-3">
                            Görüntüle
                          </a>
                        </td>
                      </tr>
                    <?php endforeach; ?>
                  </tbody>
                </table>
              </div>
            <?php else: ?>
              <div class="alert alert-info">Henüz hiç destek talebiniz bulunmamaktadır.</div>
            <?php endif; ?>
            <div class="modal fade" id="newTicketModal" tabindex="-1" aria-labelledby="newTicketModalLabel" aria-hidden="true">
              <div class="modal-dialog modal-dialog-centered">
                <form method="post" class="modal-content border-0 rounded-4 shadow-sm">
                  <div class="modal-header border-0">
                    <h5 class="modal-title" id="newTicketModalLabel">Yeni Destek Talebi Oluştur</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Kapat"></button>
                  </div>
                  <div class="modal-body">
                    <div class="mb-3">
                      <label for="subject" class="form-label">Konu</label>
                      <input type="text" class="form-control" name="subject" id="subject" required>
                    </div>
                    <div class="mb-3">
                      <label for="product" class="form-label">Sipariş Numarası</label>
                      <input type="text" class="form-control" name="product" id="product">
                    </div>
                    <div class="mb-3">
                      <label for="description" class="form-label">Açıklama</label>
                      <textarea class="form-control" name="description" id="description" rows="4" required style="resize:vertical;min-height:60px;max-height:180px;"></textarea>
                    </div>
                  </div>
                  <div class="modal-footer border-0 justify-content-center">
                    <button type="submit" name="new_ticket" class="btn btn-success px-4">Talep Oluştur</button>
                    <button type="button" class="btn btn-light" data-bs-dismiss="modal">İptal</button>
                  </div>
                </form>
              </div>
            </div>
            <script>
              if (typeof bootstrap === 'undefined') {
                var script = document.createElement('script');
                script.src = "https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js";
                document.head.appendChild(script);
              }
            </script>
          <?php endif; ?>
        </div>
      </div>
    </div>
  </div>
</div>
<style>
.support-main-card {
  background: #fff;
  border-radius: 18px;
  margin-bottom: 32px;
  padding: 0;
  box-shadow: 0 4px 10px rgba(0,0,0,0.07);
}
.support-main-body {
  padding: 32px 24px 24px 24px;
}
.ticket-info-box {
  background: #f8fafc;
  border-radius: 12px;
  padding: 20px 24px;
  border: 1px solid #e5e7eb;
}
.ticket-info-box .info-label {
  font-size: 0.95rem;
  color: #6c757d;
  font-weight: 500;
}
.ticket-info-box .info-value {
  font-size: 1.08rem;
  font-weight: 600;
  color: #222;
}
.support-chat-box {
  background: #f5f7fa;
  border-radius: 12px;
  padding: 18px 12px 12px 12px;
  border: 1px solid #e5e7eb;
  max-height: 340px;
  overflow-y: auto;
}
.support-chat-row {
  display: flex;
  margin-bottom: 10px;
}
.support-chat-row.justify-end {
  justify-content: flex-end;
}
.support-chat-row.justify-start {
  justify-content: flex-start;
}
.support-chat-bubble {
  min-width: 80px;
  max-width: 340px;
  padding: 10px 16px 8px 16px;
  border-radius: 16px;
  font-size: 0.98rem;
  background: #f1f3f6;
  color: #222;
  box-shadow: 0 1px 2px 0 rgba(60,72,88,0.04);
  position: relative;
  word-break: break-word;
}
.support-chat-bubble.user {
  background: #e6f4ea;
  color: #1b5e20;
  align-items: flex-end;
}
.support-chat-bubble.support {
  background: #f1f3f6;
  color: #222;
}
.support-chat-bubble.initial {
  border: 1.5px solid #b2dfdb;
}
.support-chat-meta {
  font-size: 0.85rem;
  margin-bottom: 2px;
  font-weight: 500;
}
.support-chat-date {
  font-size: 0.80rem;
  color: #8a99a8;
  margin-top: 4px;
  text-align: right;
}
.support-table th, .support-table td { vertical-align: middle; }
.support-table th { font-weight: 600; }
.support-table tbody tr:hover { background: #f8fafc; }
@media (max-width: 991px) {
  .support-main-body { padding: 18px 8px 8px 8px; }
  .ticket-info-box { padding: 12px 8px; }
  .support-chat-box { padding: 10px 4px 4px 4px; }
}
</style>
<?php include("footer.php");?>