<?php include("header.php"); 


          $register_success = false;
          $register_error = "";

          if (session_status() === PHP_SESSION_NONE) {
              session_start();
          }
          if (empty($_SESSION['csrf_token'])) {
              $_SESSION['csrf_token'] = bin2hex(random_bytes(32));
          }
          $csrf_token = $_SESSION['csrf_token'];

          if ($_SERVER["REQUEST_METHOD"] == "POST") {
              if (empty($_POST['csrf_token']) || !hash_equals($_SESSION['csrf_token'], $_POST['csrf_token'])) {
                  $register_error = "Geçersiz istek. Lütfen tekrar deneyiniz.";
              } else {
                  $username   = trim($_POST["username"] ?? "");
                  $email      = trim($_POST["email"] ?? "");
                  $first_name = trim($_POST["first_name"] ?? "");
                  $surname    = trim($_POST["surname"] ?? "");
                  $phone      = trim($_POST["phone"] ?? "");
                  $password   = $_POST["password"] ?? "";
                  $password_valid = true;
                  if (strlen($password) < 8) {
                      $password_valid = false;
                  } elseif (!preg_match('/[A-Za-z]/', $password) || !preg_match('/[0-9]/', $password)) {
                      $password_valid = false;
                  }
                  if (
                      empty($username) || empty($email) || empty($first_name) ||
                      empty($surname) || empty($phone) || empty($password)
                  ) {
                      $register_error = "Lütfen tüm alanları doldurunuz.";
                  } elseif (!preg_match('/^[a-zA-Z0-9_]{3,32}$/', $username)) {
                      $register_error = "Kullanıcı adınız 3-32 karakter olmalı ve sadece harf, rakam veya alt çizgi içermelidir.";
                  } elseif (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
                      $register_error = "Geçerli bir e-posta adresi giriniz.";
                  } elseif (!$password_valid) {
                      $register_error = "Şifreniz en az 8 karakter olmalı ve hem harf hem rakam içermelidir.";
                  } else {
                      $stmt = $baglan->prepare("SELECT id FROM users WHERE username = ? OR email = ? LIMIT 1");
                      if ($stmt) {
                          $stmt->bind_param("ss", $username, $email);
                          $stmt->execute();
                          $stmt->store_result();
                          if ($stmt->num_rows > 0) {
                              $register_error = "Bu kullanıcı adı veya e-posta zaten kayıtlı.";
                          } else {
                              $password_hash  = password_hash($password, PASSWORD_DEFAULT);
                              $register_date = date('d.m.Y');
                              $ip = isset($ip_adresi) ? $ip_adresi : $_SERVER['REMOTE_ADDR'];
                              $balance = 0;
                              $api_key = bin2hex(random_bytes(16));
                              if (!function_exists('generate_userno')) {
                                  function generate_userno($length = 16) {
                                      $chars = '0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ';
                                      $userno = '';
                                      for ($i = 0; $i < $length; $i++) {
                                          $userno .= $chars[random_int(0, strlen($chars) - 1)];
                                      }
                                      return $userno;
                                  }
                              }
                              $userno = generate_userno();
                              $last_activity = date('d.m.Y-H:i');

                              $insert_stmt = $baglan->prepare("INSERT INTO users (username, email, first_name, surname, phone, password, register_date, ip, api_key, user_no, last_activity, balance) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
                              if ($insert_stmt) {
                                  $insert_stmt->bind_param(
                                      "sssssssssssi",
                                      $username,
                                      $email,
                                      $first_name,
                                      $surname,
                                      $phone,
                                      $password_hash,
                                      $register_date,
                                      $ip,
                                      $api_key,
                                      $userno,
                                      $last_activity,
                                      $balance
                                  );
                                  if ($insert_stmt->execute()) {
                                      $register_success = true;
                                  } else {
                                      $register_error = "Kayıt sırasında bir hata oluştu. Lütfen tekrar deneyiniz.";
                                  }
                                  $insert_stmt->close();
                              } else {
                                  $register_error = "Kayıt sırasında bir hata oluştu. Lütfen tekrar deneyiniz.";
                              }
                          }
                          $stmt->close();
                      } else {
                          $register_error = "Kayıt sırasında bir hata oluştu. Lütfen tekrar deneyiniz.";
                      }
                  }
              }
          }
		  
if($user_control == 1){echo ' <meta http-equiv="refresh" content="0; url=panel/">';exit();}
?>

<div class="container py-5">
  <div class="row justify-content-center">
    <div class="col-lg-6 col-md-8">
      <div class="card shadow border-0 rounded-4">
        <div class="card-body p-4">
          <h2 class="mb-4 text-center" style="font-weight:600;">Kayıt Ol</h2>
          <p class="text-center text-muted mb-4">Aşağıdaki formu doldurarak yeni bir hesap oluşturabilirsiniz.</p>
         
          <?php if ($register_success): ?>
            <div class="alert alert-success text-center">Kayıt başarılı! Giriş yapabilirsiniz.</div>
          <?php elseif (!empty($register_error)): ?>
            <div class="alert alert-danger text-center"><?php echo htmlspecialchars($register_error); ?></div>
          <?php endif; ?>

          <form method="post" action="register/" class="mt-3">
            <input type="hidden" name="csrf_token" value="<?php echo htmlspecialchars($csrf_token); ?>">
            <div class="row g-3">
              <div class="col-md-6">
                <label for="first_name" class="form-label">Ad</label>
                <input type="text" class="form-control" id="first_name" name="first_name" required value="<?php echo htmlspecialchars($_POST['first_name'] ?? '', ENT_QUOTES, 'UTF-8'); ?>">
              </div>
              <div class="col-md-6">
                <label for="surname" class="form-label">Soyad</label>
                <input type="text" class="form-control" id="surname" name="surname" required value="<?php echo htmlspecialchars($_POST['surname'] ?? '', ENT_QUOTES, 'UTF-8'); ?>">
              </div>
              <div class="col-md-6">
                <label for="username" class="form-label">Kullanıcı Adı</label>
                <input type="text" class="form-control" id="username" name="username" required pattern="^[a-zA-Z0-9_]{3,32}$" title="Kullanıcı adınız 3-32 karakter olmalı ve sadece harf, rakam veya alt çizgi içermelidir." value="<?php echo htmlspecialchars($_POST['username'] ?? '', ENT_QUOTES, 'UTF-8'); ?>">
              </div>
              <div class="col-md-6">
                <label for="email" class="form-label">E-posta</label>
                <input type="email" class="form-control" id="email" name="email" required value="<?php echo htmlspecialchars($_POST['email'] ?? '', ENT_QUOTES, 'UTF-8'); ?>">
              </div>
              <div class="col-md-6">
                <label for="phone" class="form-label">Telefon</label>
                <input type="text" class="form-control" id="phone" name="phone" required value="<?php echo htmlspecialchars($_POST['phone'] ?? '', ENT_QUOTES, 'UTF-8'); ?>">
              </div>
              <div class="col-md-6">
                <label for="password" class="form-label">Şifre</label>
                <input type="password" class="form-control" id="password" name="password" required minlength="8" pattern="^(?=.*[A-Za-z])(?=.*\d).{8,}$" title="Şifreniz en az 8 karakter olmalı ve hem harf hem rakam içermelidir.">
                <div class="form-text text-muted">Şifreniz en az 8 karakter olmalı ve hem harf hem rakam içermelidir.</div>
              </div>
            </div>
            <div class="d-grid mt-4">
			<?php if($demo_mode == 1){ ?>
			<a data-bs-toggle="modal" data-bs-target="#demo_modal" class="btn btn-primary btn-lg rounded-3">Kayıt Ol</a>
			<?php }else{ ?> 
			<button type="submit" class="btn btn-primary btn-lg rounded-3">Kayıt Ol</button>
			<?php } ?>
            
            </div>
          </form>
        </div>
      </div>
      <div class="text-center mt-3">
        <a href="login/" class="text-decoration-none text-primary">Zaten hesabınız var mı? Giriş yapın</a>
      </div>
    </div>
  </div>
</div>

<?php include("footer.php");?>