<?php include("header.php"); ?>

<?php
$category_slug = isset($_GET['category']) ? $_GET['category'] : '';
$page = isset($_GET['page']) ? max(1, intval($_GET['page'])) : 1;
$per_page = 20;
$offset = ($page - 1) * $per_page;

$category_sql = $baglan->query("SELECT * FROM category ORDER BY row ASC");
$categories = [];
$category_id = null;
$category_title = "Tüm Ürünler";
$category_desc = "";
foreach ($category_sql as $cat) {
    $categories[] = $cat;
    if (!empty($category_slug) && $cat['seo_url'] == $category_slug) {
        $category_id = $cat['id'];
        $category_title = $cat['title'];
        $category_desc = $cat['alt_desc'];
    }
}
if (empty($category_slug)) {
    $category_title = "Tüm Ürünler";
    $category_desc = "";
}

$where = "";
if ($category_id) {
    $where = "WHERE category = '".intval($category_id)."'";
}
$total_sql = $baglan->query("SELECT COUNT(*) as total FROM products $where");
$total_row = $total_sql->fetch_assoc();
$total_products = $total_row ? intval($total_row['total']) : 0;

$product_sql = $baglan->query("SELECT * FROM products $where ORDER BY row ASC LIMIT $offset, $per_page");
$products = [];
while ($urun = $product_sql->fetch_assoc()) {
    $products[] = $urun;
}

$total_pages = ceil($total_products / $per_page);
$base_url = "products";
if (!empty($category_slug)) {
    $base_url .= "/" . urlencode($category_slug);
}
?>

<div class="hm-hizmetler">
  <div class="container">
    <div class="hiz-alt" style="margin-top:10px;"><?php echo htmlspecialchars($category_title); ?></div>
    <?php if (!empty($category_desc)) { ?>
      <div class="hiz-desc" style="margin-top:-5px;"><?php echo htmlspecialchars($category_desc); ?></div>
    <?php } ?>
    <div class="row mt-4">
      <div class="col-md-3 mb-4">
        <div class="card">
          <div class="card-header bg-light fw-bold">
            Kategoriler
          </div>
          <ul class="list-group list-group-flush" id="categoryList">
            <li class="list-group-item<?php if (empty($category_slug)) echo ' active'; ?>">
              <a href="products/" style="text-decoration:none;color:inherit;display:block;">Tüm Ürünler</a>
            </li>
            <?php foreach ($categories as $cat): ?>
              <li class="list-group-item<?php if (!empty($category_slug) && $cat['seo_url'] == $category_slug) echo ' active'; ?>">
                <a href="products/<?php echo htmlspecialchars($cat['seo_url']); ?>" style="text-decoration:none;color:inherit;display:block;">
                  <?php echo htmlspecialchars($cat['title']); ?>
                </a>
              </li>
            <?php endforeach; ?>
          </ul>
        </div>
      </div>
    

      <div class="col-md-9">

      <div class="modal fade" id="buyModal" tabindex="-1" aria-labelledby="buyModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
          <form method="post" action="panel/" class="modal-content border-0 rounded-4 shadow-sm" id="buyModalForm">
            <div class="modal-header border-0">
              <h5 class="modal-title" id="buyModalLabel">Satın Al</h5>
              <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Kapat"></button>
            </div>
            <div class="modal-body" id="buyModalBody">
              <div class="text-center text-muted"><i class="fas fa-spinner fa-spin"></i> Yükleniyor...</div>
            </div>
            <div class="modal-footer border-0 justify-content-center" id="buyModalFooter" style="display:none;">
            </div>
          </form>
        </div>
      </div>

      <div id="productsContainer">
        <div class="row g-3">
          <?php
          if (!empty($products)) {
            foreach ($products as $sonuc) {
              $data_id = $sonuc['id'];
              $urun_title = $sonuc['title'];
              $image = $sonuc['image'];
              $seo_url = $sonuc['seo_url'];
              $original_price = $sonuc['price'];
              
              // Kullanıcı indirimi hesapla
              $user_id_for_discount = 0;
              if ($user_control == 1 && !empty($user_no)) {
                  $user_id_query = $baglan->query("SELECT id FROM users WHERE user_no = '".mysqli_real_escape_string($baglan, $user_no)."' LIMIT 1");
                  if ($user_id_query && $user_id_row = $user_id_query->fetch_assoc()) {
                      $user_id_for_discount = intval($user_id_row['id']);
                  }
              }
              $final_price = calculateDiscountPrice($baglan, $user_id_for_discount, $data_id, $original_price);
              $price_view = number_format($final_price, 2, ',', '.');
              $urun_title_mobile = mb_strlen($urun_title, 'UTF-8') > 60 ? mb_substr($urun_title, 0, 60, 'UTF-8').'...' : $urun_title;
              echo '
              <div class="col-md-3 col-6 d-flex">
                <div class="product-card card h-100 w-100 d-flex flex-column">
                  <div class="slider-container" style="flex-shrink:0;">
                    '.(empty($image) 
                      ? '<div class="pcnoimg" style="height:200px;display:flex;align-items:center;justify-content:center;">
                            <span style="font-size: 15px; color: #888; font-weight: 500;">'.htmlspecialchars($urun_title).'</span>
                          </div>'
                      : '<img src="'.htmlspecialchars($image).'" alt="Product Image" class="product-image">'
                    ).'
                  </div>
                  <div class="product-card-body card-body d-flex flex-column flex-grow-1 justify-content-between p-2">
                    <div class="product-title mb-2 text-center">
                      <span class="d-none d-md-block">'.htmlspecialchars($urun_title).'</span>
                      <span class="d-block d-md-none">'.htmlspecialchars($urun_title_mobile).'</span>
                    </div>
                    <div class="product-price-box w-100 text-center mt-auto">
                      <a class="product-price" 
                         href="javascript:void(0);" 
                         data-bs-toggle="modal" 
                         data-bs-target="#buyModal"
                         data-product-id="'.htmlspecialchars($data_id).'"
                         data-title="'.htmlspecialchars($urun_title).'"
                         data-price="'.htmlspecialchars($final_price).'"
                      >Satın Al - <span>'.$price_view.' TL</span></a>
                    </div>
                  </div>
                </div>
              </div>
              ';
            }
          } else {
            echo '<div class="col-12 text-muted" style="font-style:italic;">Bu kategoride ürün bulunmamaktadır.</div>';
          }
          ?>
        </div>
        <?php if ($total_pages > 1): ?>
          <nav aria-label="Sayfalama" class="mt-4">
            <ul class="pagination justify-content-center">
              <?php
              $query_prefix = strpos($base_url, '?') === false ? '?' : '&';
              $page_url = function($p) use ($base_url, $query_prefix) {
                return $base_url . ($p > 1 ? $query_prefix . "page=" . $p : "");
              };

              $max_display = 7;
              if ($total_pages <= $max_display) {
                $start = 1;
                $end = $total_pages;
              } else {
                $start = max(1, $page - intval($max_display/2));
                $end = $start + $max_display - 1;
                if ($end > $total_pages) {
                  $end = $total_pages;
                  $start = $end - $max_display + 1;
                }
              }
              ?>
              <li class="page-item<?php if ($page <= 1) echo ' disabled'; ?>">
                <a class="page-link" href="<?php echo $page > 1 ? $page_url($page-1) : '#'; ?>" tabindex="-1">«</a>
              </li>
              <?php if ($start > 1): ?>
                <li class="page-item">
                  <a class="page-link" href="<?php echo $page_url(1); ?>">1</a>
                </li>
                <?php if ($start > 2): ?>
                  <li class="page-item disabled"><span class="page-link">...</span></li>
                <?php endif; ?>
              <?php endif; ?>
              <?php for ($i = $start; $i <= $end; $i++): ?>
                <li class="page-item<?php if ($i == $page) echo ' active'; ?>">
                  <a class="page-link" href="<?php echo $page_url($i); ?>"><?php echo $i; ?></a>
                </li>
              <?php endfor; ?>
              <?php if ($end < $total_pages): ?>
                <?php if ($end < $total_pages - 1): ?>
                  <li class="page-item disabled"><span class="page-link">...</span></li>
                <?php endif; ?>
                <li class="page-item">
                  <a class="page-link" href="<?php echo $page_url($total_pages); ?>"><?php echo $total_pages; ?></a>
                </li>
              <?php endif; ?>
              <li class="page-item<?php if ($page >= $total_pages) echo ' disabled'; ?>">
                <a class="page-link" href="<?php echo $page < $total_pages ? $page_url($page+1) : '#'; ?>">»</a>
              </li>
            </ul>
          </nav>
        <?php endif; ?>
      </div>

      <script>
      document.addEventListener('DOMContentLoaded', function() {
        var buyModal = document.getElementById('buyModal');
        var buyModalBody = document.getElementById('buyModalBody');
        var buyModalFooter = document.getElementById('buyModalFooter');
        var buyModalForm = document.getElementById('buyModalForm');
        var lastProductId = null;

        document.querySelectorAll('.product-price').forEach(function(btn) {
          btn.addEventListener('click', function(e) {
            var productId = this.getAttribute('data-product-id');
            lastProductId = productId;
            buyModalBody.innerHTML = '<div class="text-center text-muted"><i class="fas fa-spinner fa-spin"></i> Yükleniyor...</div>';
            buyModalFooter.style.display = "none";
            buyModalForm.reset();

            var xhr = new XMLHttpRequest();
            xhr.open('POST', 'themes/default/product_buy_modal.php', true);
            xhr.setRequestHeader('Content-type', 'application/x-www-form-urlencoded');
            xhr.onreadystatechange = function() {
              if (xhr.readyState === 4) {
                try {
                  var resp = JSON.parse(xhr.responseText);
                  buyModalBody.innerHTML = resp.body;
                  buyModalFooter.innerHTML = resp.footer;
                  buyModalFooter.style.display = resp.footer ? "flex" : "none";
                  if(resp.form_action){
                    buyModalForm.action = resp.form_action;
                  } else {
                    buyModalForm.action = "panel/";
                  }
                  if(resp.prevent_submit){
                    buyModalForm.onsubmit = function(ev){ev.preventDefault();return false;};
                  } else {
                    buyModalForm.onsubmit = null;
                  }
                } catch(e){
                  buyModalBody.innerHTML = '<div class="alert alert-danger">Bir hata oluştu. Lütfen tekrar deneyin.</div>';
                  buyModalFooter.style.display = "none";
                }
              }
            };
            xhr.send('product_id=' + encodeURIComponent(productId));
          });
        });
      });
      </script>
  </div>
</div>
</div>
<br><br>
<?php include("footer.php");?>