<?php include("header.php"); ?>
<div class="hm-hizmetler">
  <div class="container">
    <div class="hiz-alt" style="margin-top:10px;">Tüm Ürünler</div>
    <div class="hiz-desc" style="margin-top:-5px;">Sağladığımız tüm ürünleri burada listeli şekilde bulabilirsiniz.</div>

    <div class="row mb-3">
      <div class="col-md-12">
        <input type="text" id="productSearch" class="form-control prdsinput" placeholder="Ürün adı ile ara...">
      </div>
    </div>

    <div class="table-responsive">
      <table class="table table-bordered" id="productsTable">
        <thead>
          <tr>
            <th>Başlık</th>
            <th>Fiyat</th>
          </tr>
        </thead>
        <tbody>
        <?php
        $category_sql = $baglan->query("SELECT * FROM category ORDER BY row ASC");
        while ($cat = $category_sql->fetch_assoc()) {
          $category_id = $cat['id'];
          $category_title = $cat['title'];
          $alt_desc = $cat['alt_desc'];

          echo '<tr class="table-secondary category-separator"><td colspan="2"><strong>'.htmlspecialchars($category_title).'</strong></td></tr>';

          $urun_sql = $baglan->query("SELECT * FROM products WHERE category='$category_id' ORDER BY row ASC");
          $has_product = false;
          while ($urun = $urun_sql->fetch_assoc()) {
            $has_product = true;
            $urun_title = $urun['title'];
            $original_price = $urun['price'];
            $urun_id = $urun['id'];
            
            // Kullanıcı indirimi hesapla
            $user_id_for_discount = 0;
            if ($user_control == 1 && !empty($user_no)) {
                $user_id_query = $baglan->query("SELECT id FROM users WHERE user_no = '".mysqli_real_escape_string($baglan, $user_no)."' LIMIT 1");
                if ($user_id_query && $user_id_row = $user_id_query->fetch_assoc()) {
                    $user_id_for_discount = intval($user_id_row['id']);
                }
            }
            $final_price = calculateDiscountPrice($baglan, $user_id_for_discount, $urun_id, $original_price);
            $price_view = number_format($final_price, 2, ',', '.');
            
            echo '<tr class="product-row">
              <td class="product-title-cell">'.htmlspecialchars($urun_title).'</td>
              <td>'.$price_view.' TL</td>
            </tr>';
          }
          if (!$has_product) {
            echo '<tr class="product-row">
              <td colspan="2" style="color:#aaa;font-style:italic;">Bu kategoride ürün bulunmamaktadır.</td>
            </tr>';
          }
        }
        ?>
        </tbody>
      </table>
    </div>
  </div>
</div>

<script>
document.addEventListener("DOMContentLoaded", function() {
  var searchInput = document.getElementById("productSearch");
  var table = document.getElementById("productsTable");
  var rows = table.getElementsByTagName("tbody")[0].getElementsByTagName("tr");

  searchInput.addEventListener("keyup", function() {
    var filter = searchInput.value.toLowerCase();
    var showCategory = false;
    var lastCategoryRow = null;

    for (var i = 0; i < rows.length; i++) {
      rows[i].style.display = "";
    }

    for (var i = 0; i < rows.length; i++) {
      var row = rows[i];
      if (row.classList.contains("category-separator")) {
        lastCategoryRow = row;
        showCategory = false;
        continue;
      }
      if (row.classList.contains("product-row")) {
        var titleCell = row.getElementsByClassName("product-title-cell")[0];
        if (titleCell) {
          var txtValue = titleCell.textContent || titleCell.innerText;
          if (txtValue.toLowerCase().indexOf(filter) > -1) {
            row.style.display = "";
            showCategory = true;
          } else {
            row.style.display = "none";
          }
        }
      }
      if ((i + 1 == rows.length || rows[i + 1].classList.contains("category-separator")) && lastCategoryRow) {
        if (showCategory) {
          lastCategoryRow.style.display = "";
        } else {
          lastCategoryRow.style.display = "none";
        }
        lastCategoryRow = null;
        showCategory = false;
      }
    }
  });
});
</script>

<?php include("footer.php");?>