<?php
@session_start();
require_once("../../core/vi_connect.php");
require_once("../../core/vi_global.php");  

header('Content-Type: application/json; charset=utf-8');

function safe_output($str) {
    return htmlspecialchars($str, ENT_QUOTES | ENT_SUBSTITUTE, 'UTF-8');
}

$user_no = isset($_COOKIE['hikey']) ? $_COOKIE['hikey'] : null;
$user_control = 0;
$username = '';
$balance = 0;

if (!empty($user_no)) {
    $stmt = $baglan->prepare("SELECT username, balance FROM users WHERE user_no = ? LIMIT 1");
    if ($stmt) {
        $stmt->bind_param("s", $user_no);
        $stmt->execute();
        $result = $stmt->get_result();
        if ($result && $user = $result->fetch_assoc()) {
            $user_control = 1;
            $username = safe_output($user['username']);
            $balance = floatval($user['balance']);
        }
        $stmt->close();
    }
}

$product_id = isset($_POST['product_id']) ? intval($_POST['product_id']) : 0;

$body = '';
$footer = '';
$form_action = '';
$prevent_submit = false;

if (!$product_id) {
    $body = '<div class="alert alert-danger">Ürün bulunamadı.</div>';
    echo json_encode([
        'body' => $body,
        'footer' => '',
        'form_action' => '',
        'prevent_submit' => true
    ]);
    exit;
}

$stmt = $baglan->prepare("SELECT * FROM products WHERE id = ? LIMIT 1");
if (!$stmt) {
    $body = '<div class="alert alert-danger">Ürün bulunamadı.</div>';
    echo json_encode([
        'body' => $body,
        'footer' => '',
        'form_action' => '',
        'prevent_submit' => true
    ]);
    exit;
}
$stmt->bind_param("i", $product_id);
$stmt->execute();
$result = $stmt->get_result();
if (!$result || $result->num_rows == 0) {
    $body = '<div class="alert alert-danger">Ürün bulunamadı.</div>';
    echo json_encode([
        'body' => $body,
        'footer' => '',
        'form_action' => '',
        'prevent_submit' => true
    ]);
    $stmt->close();
    exit;
}
$product = $result->fetch_assoc();
$stmt->close();

$product_title = safe_output($product['title']);
$original_price = floatval($product['price']);
$category_id = isset($product['category']) ? intval($product['category']) : 0;

// İndirimli fiyatı hesapla
$user_id_for_discount = 0;
if ($user_control == 1 && !empty($user_no)) {
    $user_id_query = $baglan->query("SELECT id FROM users WHERE user_no = '".mysqli_real_escape_string($baglan, $user_no)."' LIMIT 1");
    if ($user_id_query && $user_id_row = $user_id_query->fetch_assoc()) {
        $user_id_for_discount = intval($user_id_row['id']);
    }
}
$product_price = calculateDiscountPrice($baglan, $user_id_for_discount, $product_id, $original_price);
$product_price_view = number_format($product_price, 2, ',', '.');
$product_desc = !empty($product['content']) ? nl2br(safe_output($product['content'])) : '';
$product_image = !empty($product['image']) ? '<img src="'.safe_output($product['image']).'" alt="'.$product_title.'" class="img-fluid mb-3" style="max-height:180px;max-width:100%;">' : '';

if ($user_control != 1) {
    $body = '
        <div class="text-center">
            <div class="mb-3">'.$product_image.'</div>
            <h5 class="mb-2">'.$product_title.'</h5>
            <div class="mb-2 text-primary" style="font-size:1.2em;"><b>'.$product_price_view.' TL</b></div>
            <div class="mb-3">'.$product_desc.'</div>
            <div class="alert alert-warning">Satın alma işlemi için giriş yapmalısınız.</div>
        </div>
    ';
    $footer = '
        <a href="login/" class="btn btn-primary w-100">Giriş Yap</a>
    ';
    $form_action = '';
    $prevent_submit = true;
} else {

    $body = '
        <div class="text-center">
            <div class="mb-3">'.$product_image.'</div>
            <h5 class="mb-2">'.$product_title.'</h5>
            <div class="mb-2 text-primary" style="font-size:1.2em;"><b>'.$product_price_view.' TL</b></div>
            <div class="mb-3">'.$product_desc.'</div>
        </div>
    ';

    if ($balance < $product_price) {
        $footer = '
            <div class="w-100">
                <div class="alert alert-danger mb-2">Bakiyeniz yetersiz. Lütfen bakiye yükleyin.</div>
                <a href="balance/" class="btn btn-success w-100">Bakiye Yükle</a>
            </div>
        ';
        $form_action = '';
        $prevent_submit = true;
    } else {
	$pull_settings = $baglan->query("SELECT * FROM settings WHERE id = '1'")->fetch_assoc();
	$demo_mode = $pull_settings['demo_mode'];
        if($demo_mode == 1){
        $footer = '
            <div class="alert alert-warning text-center mb-2">
                Demo modunda satın alma işlemi yapılamaz.
            </div>
        ';
        $form_action = '';
        $prevent_submit = true;
        }else{
        $footer = '
            <input type="hidden" name="action" value="buy_product">
            <input type="hidden" name="product" value="'.intval($product_id).'">
            <input type="hidden" name="category" value="'.intval($category_id).'">
            <button type="submit" class="btn btn-primary w-100">Satın Al</button>
        ';
        $form_action = 'panel/';
        $prevent_submit = false;
        }
    }
}

echo json_encode([
    'body' => $body,
    'footer' => $footer,
    'form_action' => $form_action,
    'prevent_submit' => $prevent_submit
]);
exit;
