<?php include("header.php");


##-> Add New Order Start
$order_success = false;
$order_error = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $category_id = isset($_POST['category']) ? intval($_POST['category']) : 0;
    $product_id = isset($_POST['product']) ? intval($_POST['product']) : 0;

    if ($category_id > 0 && $product_id > 0) {
        $product_stmt = $baglan->prepare("SELECT price, api_provider_id, api_product_id FROM products WHERE id = ? AND category = ? LIMIT 1");
        $product_stmt->bind_param("ii", $product_id, $category_id);
        $product_stmt->execute();
        $product_result = $product_stmt->get_result();
        if ($product_result && $product_result->num_rows > 0) {
            $product_row = $product_result->fetch_assoc();
            $original_price = $product_row['price'];
            // İndirimli fiyatı hesapla
            $price = calculateDiscountPrice($baglan, $user_id, $product_id, $original_price);
            $create_date = date('Y-m-d');
            $create_time = date('H:i:s');
            $data = '';
            $status = 0; 
            $api_provider_id = null;
            $api_order_id = null;

            $stock_stmt = $baglan->prepare("SELECT id, data FROM stock WHERE product_id = ? LIMIT 1");
            $stock_stmt->bind_param("i", $product_id);
            $stock_stmt->execute();
            $stock_result = $stock_stmt->get_result();
            $stock_id_to_delete = null;
            if ($stock_result && $stock_result->num_rows > 0) {
                $stock_row = $stock_result->fetch_assoc();
                $data = $stock_row['data'];
                $stock_id_to_delete = $stock_row['id'];
                $status = 1;
            }
            $stock_stmt->close();

            if ($status === 0 && !empty($product_row['api_provider_id'])) {
                $api_provider_id = $product_row['api_provider_id'];
                $api_product_id = $product_row['api_product_id'];

                $api_info_stmt = $baglan->prepare("SELECT url, api_key FROM api WHERE id = ? LIMIT 1");
                $api_info_stmt->bind_param("i", $api_provider_id);
                $api_info_stmt->execute();
                $api_info_result = $api_info_stmt->get_result();
                if ($api_info_row = $api_info_result->fetch_assoc()) {
                    $api_url = $api_info_row['url'];
                    $api_provider_key = $api_info_row['api_key'];

                    $remote_api_url = "$api_url/?endpoint=neworder";
                    $post_fields = [
                        'api_key' => $api_provider_key,
                        'product_id' => $api_product_id
                    ];

                    $ch = curl_init();
                    curl_setopt($ch, CURLOPT_URL, $remote_api_url);
                    curl_setopt($ch, CURLOPT_POST, true);
                    curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($post_fields));
                    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                    curl_setopt($ch, CURLOPT_TIMEOUT, 15);

                    $remote_response = curl_exec($ch);
                    $curl_error = curl_error($ch);
                    curl_close($ch);

                    if ($remote_response !== false) {
                        $api_response = json_decode($remote_response, true);
                        $api_order_id = isset($api_response['order_id']) ? $api_response['order_id'] : null;
                        $data = isset($api_response['order_data']) ? $api_response['order_data'] : null;
                        if (!empty($data)) {
                            $status = 1;
                        }
                    }
                }
                $api_info_stmt->close();
            }

            $balance_stmt = $baglan->prepare("SELECT balance FROM users WHERE user_no = ? LIMIT 1");
            $balance_stmt->bind_param("s", $user_no);
            $balance_stmt->execute();
            $balance_result = $balance_stmt->get_result();
            if ($balance_result && $balance_result->num_rows > 0) {
                $balance_row = $balance_result->fetch_assoc();
                $current_balance = floatval($balance_row['balance']);
                if ($current_balance >= $price) {
                    $new_balance = $current_balance - $price;
                    $update_stmt = $baglan->prepare("UPDATE users SET balance = ? WHERE user_no = ? LIMIT 1");
                    $update_stmt->bind_param("ds", $new_balance, $user_no);
                    if ($update_stmt->execute()) {
                        $data_safe = isset($data) && $data !== null ? $data : '';
                        $order_stmt = $baglan->prepare("INSERT INTO orders (product, category, data, create_date, create_time, price, order_owner, status, api_provider_id, api_order_id) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
                        $order_stmt->bind_param("iisssdsiii", $product_id, $category_id, $data_safe, $create_date, $create_time, $price, $user_id, $status, $api_provider_id, $api_order_id);
                        if ($order_stmt->execute()) {
                            $order_success = true;
                            $order_id = $order_stmt->insert_id;

                            if ($stock_id_to_delete !== null) {
                                $delete_stock_stmt = $baglan->prepare("DELETE FROM stock WHERE id = ? LIMIT 1");
                                $delete_stock_stmt->bind_param("i", $stock_id_to_delete);
                                $delete_stock_stmt->execute();
                                $delete_stock_stmt->close();
                            }

                            echo '<meta http-equiv="refresh" content="0;URL='.$site_address.'/orders/'.$order_id.'?status=success">';
                            exit();
                        } else {
                            $rollback_stmt = $baglan->prepare("UPDATE users SET balance = ? WHERE user_no = ? LIMIT 1");
                            $rollback_stmt->bind_param("ds", $current_balance, $user_no);
                            $rollback_stmt->execute();
                            $order_error = "Sipariş oluşturulamadı. Lütfen tekrar deneyin.";
                            $rollback_stmt->close();
                        }
                        $order_stmt->close();
                    } else {
                        $order_error = "Bakiye güncellenemedi. Lütfen tekrar deneyin.";
                    }
                    $update_stmt->close();
                } else {
                    $order_error = "Bakiyeniz yetersiz. Lütfen önce bakiye yükleyin.";
                }
            } else {
                $order_error = "Kullanıcı bakiyesi bulunamadı.";
            }
            $balance_stmt->close();
        } else {
            $order_error = "Seçilen ürün bulunamadı.";
        }
        $product_stmt->close();
    } else {
        $order_error = "Lütfen bir kategori ve ürün seçin.";
    }
}
##-> Add New Order End

##-> Order_list start
$first_category_id = '';
$first_product_id = '';
$first_product_options = '';
$first_product_desc = '';
$category_query = $baglan->query("SELECT * FROM category ORDER BY row ASC");
$categories = [];
if ($category_query && $category_query->num_rows > 0) {
while ($cat = $category_query->fetch_assoc()) {
$categories[] = $cat;
}
if (count($categories) > 0) {
$first_category_id = $categories[0]['id'];
$product_query = $baglan->prepare("SELECT id, title, price, content FROM products WHERE category = ? ORDER BY row ASC");
$product_query->bind_param("i", $first_category_id);
$product_query->execute();
$product_result = $product_query->get_result();
$products = [];
if ($product_result && $product_result->num_rows > 0) {
            while ($prod = $product_result->fetch_assoc()) {
$products[] = $prod;
}
if (count($products) > 0) {
$first_product_id = $products[0]['id'];
foreach ($products as $prod) {
$selected = ($prod['id'] == $first_product_id) ? ' selected' : '';
// İndirimli fiyatı hesapla
$discounted_price = calculateDiscountPrice($baglan, $user_id, $prod['id'], $prod['price']);
$first_product_options .= '<option value="' . htmlspecialchars($prod['id'], ENT_QUOTES, 'UTF-8') . '"' . $selected . '>' .
htmlspecialchars($prod['id'], ENT_QUOTES, 'UTF-8') . ' - ' .
htmlspecialchars($prod['title'], ENT_QUOTES, 'UTF-8') . ' - ' .
number_format($discounted_price, 2, ',', '.') . ' ₺</option>';
}
$desc = trim($products[0]['content']);
if ($desc !== '') {
$first_product_desc = nl2br(htmlspecialchars($desc, ENT_QUOTES, 'UTF-8'));
}
}
}
$product_query->close();
}
}
##-> Order_list end

?>
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

<div class="container">
<div class="desktop" style="margin-top:50px;"></div>
<div class="mobile" style="margin-top:-10px;"></div>
  <div class="row">

<div class="col-md-3 mb-4">
<?php
include("navigation.php");
?>
</div>

    <div class="col-md-9">
      <div class="card shadow-sm border-0 rounded-4">
        <div class="card-body">
          <h2 class="mb-4" style="font-weight:600;">Ürün Satın Al</h2>
          <?php if ($order_success): ?>
            <div class="alert alert-success">Siparişiniz başarıyla oluşturuldu!</div>
          <?php elseif ($order_error): ?>
            <div class="alert alert-danger"><?php echo htmlspecialchars($order_error); ?></div>
          <?php endif; ?>
          <form action="" method="post">
            <label for="category">Kategori Seçin:</label>
            <select name="category" id="category" class="form-select mb-3" required>
              <?php
                foreach ($categories as $cat) {
                  $selected = ($cat['id'] == $first_category_id) ? ' selected' : '';
                  echo '<option value="' . $cat['id'] . '"' . $selected . '>' . htmlspecialchars($cat['title']) . '</option>';
                }
              ?>
            </select>

            <label for="product">Ürün Seçin:</label>
            <select name="product" id="product" class="form-select mb-3" required>
              <?php echo $first_product_options; ?>
            </select>

            <div id="product-desc-box" class="alert alert-secondary" style="display:<?php echo ($first_product_desc !== '') ? 'block' : 'none'; ?>; font-size:15px; margin-bottom:20px;"><?php echo $first_product_desc; ?></div>
            <?php if($demo_mode == 1){ ?>
		      	<a data-bs-toggle="modal" data-bs-target="#demo_modal" class="btn btn-primary">Satın Al</a>
			       <?php }else{ ?> 
             <input type="submit" value="Satın Al" class="btn btn-primary">
		    	  <?php } ?>

            
          
            
          </form>
        </div>
      </div>
    </div>
    <script>
    $(document).ready(function() {
      var firstCategoryId = '<?php echo $first_category_id; ?>';
      var firstProductId = '<?php echo $first_product_id; ?>';

      $('#category').change(function() {
          var categoryId = $(this).val();

          if (categoryId) {
              $.ajax({
                  url: 'core/get_products.php',
                  type: 'GET',
                  data: {category_id: categoryId},
                  success: function(response) {
                      $('#product').html(response);

                      var $firstOption = $('#product option:first');
                      var newProductId = $firstOption.val();

                      if (newProductId) {
                          $.ajax({
                              url: 'core/get_products_desc.php',
                              type: 'GET',
                              data: {product_id: newProductId},
                              success: function(descResponse) {
                                  if(descResponse.trim() !== '') {
                                      $('#product-desc-box').html(descResponse).show();
                                  } else {
                                      $('#product-desc-box').hide().text('');
                                  }
                              },
                              error: function() {
                                  $('#product-desc-box').hide().text('');
                              }
                          });
                      } else {
                          $('#product-desc-box').hide().text('');
                      }
                  },
                  error: function() {
                      $('#product').html('<option value="">Ürünler yüklenemedi</option>');
                      $('#product-desc-box').hide().text('');
                  }
              });
          } else {
              $('#product').html('<option value="">Ürün Seçin</option>');
              $('#product-desc-box').hide().text('');
          }
      });

      $('#product').on('change', function() {
          var productId = $(this).val();
          if (productId) {
              $.ajax({
                  url: 'core/get_products_desc.php',
                  type: 'GET',
                  data: {product_id: productId},
                  success: function(response) {
                      if(response.trim() !== '') {
                          $('#product-desc-box').html(response).show();
                      } else {
                          $('#product-desc-box').hide().text('');
                      }
                  },
                  error: function() {
                      $('#product-desc-box').hide().text('');
                  }
              });
          } else {
              $('#product-desc-box').hide().text('');
          }
      });
    });
    </script>
  </div>
</div>
<?php include("footer.php");?>