<?php 
include("header.php");

##-> Order detail start
$order_detail = false;
$order_detail_data = null;

if (is_numeric(g('order_id'))) {
    $order_id = intval(g('order_id'));
    $stmt = $baglan->prepare("SELECT o.*, p.title as product_title, c.title as category_title FROM orders o 
        LEFT JOIN products p ON o.product = p.id 
        LEFT JOIN category c ON o.category = c.id 
        WHERE o.id = ? AND o.order_owner = ? LIMIT 1");
    $stmt->bind_param("ii", $order_id, $user_id);
    $stmt->execute();
    $result = $stmt->get_result();
    if ($result && $result->num_rows > 0) {
        $order_detail = true;
        $order_detail_data = $result->fetch_assoc();
    }
    $stmt->close();
}
##-> Order detail end

##-> Order list start
            $orders = [];
            $stmt = $baglan->prepare("SELECT o.*, p.title as product_title, c.title as category_title 
                FROM orders o 
                LEFT JOIN products p ON o.product = p.id 
                LEFT JOIN category c ON o.category = c.id 
                WHERE o.order_owner = ? 
                ORDER BY o.id DESC");
            $stmt->bind_param("i", $user_id);
            $stmt->execute();
            $result = $stmt->get_result();
            if ($result && $result->num_rows > 0) {
                while ($row = $result->fetch_assoc()) {
                    $orders[] = $row;
                }
            }
            $stmt->close();
			
function getOrderStatusBadge($status) {
    switch ((int)$status) {
        case 0:
            return '<span class="badge bg-warning text-dark">Bekliyor</span>';
        case 1:
            return '<span class="badge bg-success">Tamamlandı</span>';
        case 2:
            return '<span class="badge bg-danger">İptal Edildi</span>';
        case 3:
            return '<span class="badge bg-secondary">İade Edildi</span>';
        default:
            return '<span class="badge bg-secondary">Bilinmiyor</span>';
    }
}

function getOrderStatusText($status) {
    switch ((int)$status) {
        case 0:
            return 'Bekliyor';
        case 1:
            return 'Tamamlandı';
        case 2:
            return 'İptal Edildi';
        case 3:
            return 'İade Edildi';
        default:
            return 'Bilinmiyor';
    }
}
?>
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

<div class="container">
<div class="desktop" style="margin-top:50px;"></div>
<div class="mobile" style="margin-top:-10px;"></div>
  <div class="row">
  
<div class="col-md-3 mb-4">
<?php
include("navigation.php");
?>
</div>
  
    <div class="col-md-9">
      <div class="card shadow-sm border-0 rounded-4">
        <div class="card-body">
          <?php if ($order_detail && $order_detail_data): ?>
            <h2 class="mb-4" style="font-weight:600;">Sipariş Detayı</h2>
            <?php if ($status == 'success'): ?>
              <div class="alert alert-success">Siparişiniz başarıyla oluşturuldu!</div>
            <?php endif; ?>
            <table class="table table-bordered">
              <tr>
                <th>Sipariş ID</th>
                <td><?php echo $order_detail_data['id']; ?></td>
              </tr>
              <tr>
                <th>Ürün</th>
                <td><?php echo $order_detail_data['product_title']; ?></td>
              </tr>
              <tr>
                <th>Kategori</th>
                <td><?php echo $order_detail_data['category_title']; ?></td>
              </tr>
              <tr>
                <th>Oluşturulma Tarihi</th>
                <td><?php echo date('d.m.Y', strtotime($order_detail_data['create_date'])); ?> </td>
              </tr>
              <tr>
                <th>Oluşturulma Saati</th>
                <td><?php echo $order_detail_data['create_time']; ?></td>
              </tr>
              <tr>
                <th>Fiyat</th>
                <td><?php echo number_format($order_detail_data['price'], 2, ',', '.'); ?> ₺</td>
              </tr>
              <tr>
                <th>Durum</th>
                <td>
                  <?php
                    echo getOrderStatusBadge($order_detail_data['status']);
                  ?>
                </td>
              </tr>
              <tr>
                <th>Sipariş Verisi</th>
                <td>
                  <?php
                    $data = trim($order_detail_data['data']);
                    if ($data === '') {
                        echo '<font color="red">Sipariş verisi yok</font>';
                    } else {
                        echo nl2br(htmlspecialchars($data));
                    }
                  ?>
                </td>
              </tr>
            </table>
            <a href="orders/" class="btn btn-secondary mt-3"><i class="fas fa-arrow-left"></i> Siparişlerime Dön</a>
          <?php else: ?>
            <h2 class="mb-4" style="font-weight:600;">Siparişlerim</h2>
       
            <?php if (count($orders) > 0): ?>
              <div class="table-responsive">
                <table class="table table-striped align-middle">
                  <thead>
                    <tr>
                      <th>#</th>
                      <th>Ürün</th>
                      <th>Kategori</th>
                      <th>Tarih</th>
                      <th>Saat</th>
                      <th>Fiyat</th>
                      <th>Durum</th>
                      <th>Detay</th>
                    </tr>
                  </thead>
                  <tbody>
                    <?php foreach ($orders as $order): ?>
                      <tr>
                        <td><?php echo $order['id']; ?></td>
                        <td><?php echo $order['product_title']; ?></td>
                        <td><?php echo $order['category_title']; ?></td>
                        <td><?php echo date('d.m.Y', strtotime($order['create_date'])); ?> </td>
                        <td><?php echo htmlspecialchars($order['create_time']); ?></td>
                        <td><?php echo number_format($order['price'], 2, ',', '.'); ?> ₺</td>
                        <td><?php echo getOrderStatusBadge($order['status']); ?>
                        </td>
                        <td> <a href="orders/<?php echo urlencode($order['id']); ?>" class="btn btn-sm btn-primary"> Detay </a> </td>
                      </tr>
                    <?php endforeach; ?>
                  </tbody>
                </table>
              </div>
            <?php else: ?>
              <div class="alert alert-info">Henüz hiç siparişiniz bulunmamaktadır.</div>
            <?php endif; ?>
          <?php endif; ?>
        </div>
      </div>
    </div>

  </div>
</div>
<style>
.table th, .table td { vertical-align: middle; }
</style>

<?php include("footer.php");?>