<?php include("header.php"); 

	
          $login_error = "";

          if (empty($_SESSION['csrf_token'])) {
              $_SESSION['csrf_token'] = bin2hex(random_bytes(32));
          }
          $csrf_token = $_SESSION['csrf_token'];

          if ($_SERVER["REQUEST_METHOD"] == "POST") {
              if (!isset($_POST['csrf_token']) || $_POST['csrf_token'] !== $_SESSION['csrf_token']) {
                  $login_error = "Geçersiz istek. Lütfen tekrar deneyiniz.";
              } else {
                  $username_or_email = trim($_POST["username_or_email"] ?? "");
                  $password = $_POST["password"] ?? "";

                  if (empty($username_or_email) || empty($password)) {
                      $login_error = "Lütfen tüm alanları doldurunuz.";
                  } else {
                      $stmt = $baglan->prepare("SELECT id, user_no, password FROM users WHERE username = ? OR email = ? LIMIT 1");
                      if ($stmt) {
                          $stmt->bind_param("ss", $username_or_email, $username_or_email);
                          $stmt->execute();
                          $result = $stmt->get_result();
                          if ($result && $result->num_rows === 1) {
                              $user = $result->fetch_assoc();
                              if (password_verify($password, $user['password'])) {
                                  if (session_status() === PHP_SESSION_NONE) {
                                      session_start();
                                  }
                                  $user_no = $user['user_no'];
                                  setcookie("hikey", $user_no, time() + (30 * 24 * 60 * 60), "/");
                                  $last_activity = date('d.m.Y-H:i');
                                  $user_id = $user['id'];
                                  $update_stmt = $baglan->prepare("UPDATE users SET last_activity = ? WHERE id = ?");
                                  if ($update_stmt) {
                                      $update_stmt->bind_param("si", $last_activity, $user_id);
                                      $update_stmt->execute();
                                      $update_stmt->close();
                                  }
                                  unset($_SESSION['csrf_token']);
                         
                                  echo '<meta http-equiv="refresh" content="0;URL='.$site_address.'/panel/">'; exit();
                              } else {
                                  $login_error = "Kullanıcı adı/e-posta veya şifre hatalı.";
                              }
                          } else {
                              $login_error = "Kullanıcı adı/e-posta veya şifre hatalı.";
                          }
                          $stmt->close();
                      } else {
                          $login_error = "Bir hata oluştu, lütfen tekrar deneyiniz.";
                      }
                  }
              }
          }

		  
		  
if($user_control == 1){echo ' <meta http-equiv="refresh" content="0; url=panel/">';exit();}
?>

<div class="container py-5">
  <div class="row justify-content-center">
    <div class="col-lg-6 col-md-8">
      <div class="card shadow border-0 rounded-4">
        <div class="card-body p-4">
          <h2 class="mb-4 text-center" style="font-weight:600;">Giriş Yap</h2>
          <p class="text-center text-muted mb-4">Hesabınıza giriş yapmak için bilgilerinizi giriniz.</p>
         

          <?php if (!empty($login_error)): ?>
            <div class="alert alert-danger text-center"><?php echo htmlspecialchars($login_error); ?></div>
          <?php endif; ?>
            
          <?php if($demo_mode == 1): ?>
            <div class="alert alert-warning text-center">
              <strong>Demo Modu Aktif</strong>
              <p>Doğrudan giriş yapabilirsiniz.</p>
            </div>
          <?php endif; ?>
          
          <form method="post" action="login/" class="mt-3" autocomplete="off">
            <input type="hidden" name="csrf_token" value="<?php echo htmlspecialchars($csrf_token); ?>">
            <div class="row g-3">
              <div class="col-12">
                <label for="username_or_email" class="form-label">Kullanıcı Adı veya E-posta</label>
                <input type="text" class="form-control" id="username_or_email" <?php if($demo_mode == 1){echo 'value="demo"';}?> name="username_or_email" required value="<?php echo htmlspecialchars($_POST['username_or_email'] ?? '', ENT_QUOTES, 'UTF-8'); ?>">
              </div>
              <div class="col-12">
                <label for="password" class="form-label">Şifre</label>
                <input type="password" class="form-control" id="password" name="password" <?php if($demo_mode == 1){echo 'value="demo123456"';}?> required autocomplete="current-password">
              </div>
            </div>
            <div class="d-grid mt-4">
              <button type="submit" class="btn btn-primary btn-lg rounded-3">Giriş Yap</button>
            </div>
          </form>
        </div>
      </div>
      <div class="text-center mt-3">
        <a href="register/" class="text-decoration-none text-primary">Hesabınız yok mu? Kayıt olun</a>
      </div>
    </div>
  </div>
</div>

<?php include("footer.php");?>