<?php include("header.php"); ?>
<div class="hm-hizmetler">
  <div class="container">
    <div class="hiz-alt" style="margin-top:10px;">Sıkça Sorulan Sorular</div>
    <div class="hiz-desc" style="margin-top:-5px;">Sıkça sorulan soruların cevaplarını burada bulabilirsiniz.</div>

    <div class="row mb-3">
      <div class="col-md-12">
        <input type="text" id="faqSearch" class="form-control prdsinput" placeholder="Soru ile ara...">
      </div>
    </div>

    <div class="accordion" id="faqsAccordion">
      <?php
      $faqs_sql = $baglan->query("SELECT * FROM faqs ORDER BY id ASC");
      $faq_count = 0;
      while ($faq = $faqs_sql->fetch_assoc()) {
        $faq_count++;
        $question = $faq['question'];
        $answer = $faq['answer'];
        $faq_id = 'faq' . $faq_count;
        ?>
        <div class="accordion-item faq-item">
          <h2 class="accordion-header" id="heading<?php echo $faq_id; ?>">
            <button class="accordion-button collapsed faq-question" type="button" data-bs-toggle="collapse" data-bs-target="#collapse<?php echo $faq_id; ?>" aria-expanded="false" aria-controls="collapse<?php echo $faq_id; ?>">
              <?php echo htmlspecialchars($question); ?>
            </button>
          </h2>
          <div id="collapse<?php echo $faq_id; ?>" class="accordion-collapse collapse" aria-labelledby="heading<?php echo $faq_id; ?>" data-bs-parent="#faqsAccordion">
            <div class="accordion-body faq-answer">
              <?php echo nl2br(htmlspecialchars($answer)); ?>
            </div>
          </div>
        </div>
      <?php
      }
      if ($faq_count == 0) {
        echo '<div class="alert alert-info">Henüz sıkça sorulan soru eklenmemiştir.</div>';
      }
      ?>
    </div>
  </div>
</div>

<script>
document.addEventListener("DOMContentLoaded", function() {
  var searchInput = document.getElementById("faqSearch");
  var faqItems = document.querySelectorAll(".faq-item");

  searchInput.addEventListener("keyup", function() {
    var filter = searchInput.value.toLowerCase();
    faqItems.forEach(function(item) {
      var question = item.querySelector(".faq-question").textContent.toLowerCase();
      var answer = item.querySelector(".faq-answer").textContent.toLowerCase();
      if (question.indexOf(filter) > -1 || answer.indexOf(filter) > -1) {
        item.style.display = "";
      } else {
        item.style.display = "none";
      }
    });
  });
});
</script>

<?php include("footer.php");?>