<?php
include("header.php");

$pull_payment_detail = $baglan->query("SELECT * FROM payment_option WHERE id = '1'")->fetch_assoc();


?>
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<div class="container">
  <div class="desktop" style="margin-top:50px;"></div>
  <div class="mobile" style="margin-top:-10px;"></div>
  <div class="row">
    <div class="col-md-3 mb-4">
      <?php
      include("navigation.php");
      ?>
    </div>
    <div class="col-md-9">
      <div class="card shadow-sm border-0 rounded-4">
        <div class="card-body">
          <h2 class="mb-4" style="font-weight:600;">Bakiye Yükle</h2>
          <form id="balanceForm" onsubmit="return false;">
            <div class="mb-3">
              <label for="amount" class="form-label">Yüklemek İstediğiniz Tutar <span class="text-muted"
                  style="font-size:0.95em;">(Minimum <?php echo $min_balance; ?>₺)</span></label>
              <div class="input-group">
                <input type="number" min="<?php echo $min_balance; ?>" step="<?php echo $min_balance; ?>"
                  class="form-control" id="amount" name="amount"
                  placeholder="Tutarı giriniz (en az <?php echo $min_balance; ?> ₺)" required pattern="^[1-9][0-9]*$"
                  inputmode="numeric">
                <span class="input-group-text">₺</span>
              </div>
            </div>
            <div class="mb-4">
              <label class="form-label">Ödeme Seçenekleri</label>
              <div class="row g-3">
                <?php if ($pull_payment_detail['shopier_option'] == '1') { ?>
                  <div class="col-6 col-md-4">
                    <?php if ($demo_mode == 1) { ?>
                      <div class="payment-option-demo-mode border rounded-3 p-3 text-center h-100 position-relative"
                        style="cursor:not-allowed; opacity:0.7;">
                        <img src="core/images/shopier.png" alt="shopier" style="height:32px;"><br>
                        <span>Shopier</span>
                        <div
                          class="position-absolute top-0 start-0 w-100 h-100 d-flex align-items-center justify-content-center"
                          style="background:rgba(255, 213, 79, 0.45); color:#856404; font-weight:600; font-size:0.95em; border-radius:0.5rem; pointer-events:none;">
                          Demo Modu
                        </div>
                      </div>
                    <?php } else { ?>
                      <div class="payment-option border rounded-3 p-3 text-center h-100" style="cursor:pointer;"
                        data-method="shopier">
                        <img src="core/images/shopier.png" alt="shopier" style="height:32px;"><br>
                        <span>Shopier</span>
                      </div>
                    <?php } ?>
                  </div>
                <?php } ?>

                <?php if ($pull_payment_detail['paytr_option'] == '1') { ?>
                  <?php if ($demo_mode == 1) { ?>
                    <div class="col-6 col-md-4">
                      <div class="payment-option-demo-mode border rounded-3 p-3 text-center h-100 position-relative"
                        style="cursor:not-allowed; opacity:0.7;">
                        <img src="core/images/paytr.png" alt="paytr" style="height:32px;"><br>
                        <span>Paytr</span>
                        <div
                          class="position-absolute top-0 start-0 w-100 h-100 d-flex align-items-center justify-content-center"
                          style="background:rgba(255, 213, 79, 0.45); color:#856404; font-weight:600; font-size:0.95em; border-radius:0.5rem; pointer-events:none;">
                          Demo Modu
                        </div>
                      </div>
                    </div>
                  <?php } else { ?>
                    <div class="col-6 col-md-4">
                      <div class="payment-option border rounded-3 p-3 text-center h-100" style="cursor:pointer;"
                        data-method="paytr">
                        <img src="core/images/paytr.png" alt="paytr" style="height:32px;"><br>
                        <span>Paytr</span>
                      </div>
                    </div>
                  <?php } ?>
                <?php } ?>

                <?php if ($pull_payment_detail['stripe_option'] == '1') { ?>
                  <?php if ($demo_mode == 1) { ?>
                    <div class="col-6 col-md-4">
                      <div class="payment-option-demo-mode border rounded-3 p-3 text-center h-100 position-relative"
                        style="cursor:not-allowed; opacity:0.7;">
                        <img src="core/images/stripe.png" alt="paytr" style="height:32px;"><br><span>Stripe</span>
                        <div
                          class="position-absolute top-0 start-0 w-100 h-100 d-flex align-items-center justify-content-center"
                          style="background:rgba(255, 213, 79, 0.45); color:#856404; font-weight:600; font-size:0.95em; border-radius:0.5rem; pointer-events:none;">
                          Demo Modu
                        </div>
                      </div>
                    </div>
                  <?php } else { ?>
                    <div class="col-6 col-md-4">
                      <div class="payment-option border rounded-3 p-3 text-center h-100" style="cursor:pointer;"
                        data-method="stripe">
                        <img src="core/images/stripe.png" alt="paytr" style="height:32px;"><br><span>Stripe</span>
                      </div>
                    </div>
                  <?php } ?>
                <?php } ?>

                <?php if ($pull_payment_detail['bank_option'] == '1') { ?>
                  <div class="col-6 col-md-4">
                    <?php if ($demo_mode == 1) { ?>
                      <div class="payment-option-demo-mode border rounded-3 p-3 text-center h-100 position-relative"
                        style="cursor:not-allowed; opacity:0.7;">
                        <img src="core/images/bank.png" alt="Banka Havalesi" style="height:32px;"><br>
                        <span>Banka Havalesi</span>
                        <div
                          class="position-absolute top-0 start-0 w-100 h-100 d-flex align-items-center justify-content-center"
                          style="background:rgba(255, 213, 79, 0.45); color:#856404; font-weight:600; font-size:0.95em; border-radius:0.5rem; pointer-events:none;">
                          Demo Modu
                        </div>
                      </div>
                    <?php } else { ?>
                      <div class="payment-option border rounded-3 p-3 text-center h-100" style="cursor:pointer;"
                        data-method="havale" id="havaleOption" onclick="$('#havaleModal').modal('show'); return false;"
                        tabindex="0">
                        <img src="core/images/bank.png" alt="Banka Havalesi" style="height:32px;"><br>
                        <span>Banka Havalesi</span>
                      </div>
                    <?php } ?>
                  </div>
                <?php } ?>

                <?php if ($pull_payment_detail['link_option'] == '1') { ?>
                  <div class="col-6 col-md-4">
                    <?php if ($demo_mode == 1) { ?>
                      <div class="payment-option-demo-mode border rounded-3 p-3 text-center h-100 position-relative"
                        style="cursor:not-allowed; opacity:0.7;">
                        <img src="core/images/link.png" alt="Banka Havalesi" style="height:32px;"><br>
                        <span> <?php echo $pull_payment_detail['link_title']; ?></span>
                        <div
                          class="position-absolute top-0 start-0 w-100 h-100 d-flex align-items-center justify-content-center"
                          style="background:rgba(255, 213, 79, 0.45); color:#856404; font-weight:600; font-size:0.95em; border-radius:0.5rem; pointer-events:none;">
                          Demo Modu
                        </div>
                      </div>
                    <?php } else { ?>
                      <div class="payment-option border rounded-3 p-3 text-center h-100" style="cursor:pointer;"
                        data-method="link" id="linkOption" onclick="$('#linkModal').modal('show'); return false;"
                        tabindex="0">
                        <img src="core/images/link.png" alt="Banka Havalesi" style="height:32px;"><br>
                        <span> <?php echo $pull_payment_detail['link_title']; ?></span>
                      </div>
                    <?php } ?>
                  </div>

                <?php } ?>


                <div class="modal fade" id="linkModal" tabindex="-1" aria-labelledby="linkModalLabel"
                  aria-hidden="true">
                  <div class="modal-dialog modal-dialog-centered">
                    <div class="modal-content">
                      <div class="modal-header">
                        <h5 class="modal-title" id="linkModalLabel"><?php echo $pull_payment_detail['link_title']; ?>
                        </h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Kapat"></button>
                      </div>
                      <div class="modal-body">
                        <?php
                        // Veritabanından ilgili linkleri al
                        $link_price_and_link = isset($pull_payment_detail['link_price_and_link']) ? $pull_payment_detail['link_price_and_link'] : '';
                        if (!empty($link_price_and_link)) {
                          $link_list = explode(',', $link_price_and_link);
                          echo '<ul class="list-group">';
                          foreach ($link_list as $item) {
                            $parts = explode(':', $item, 2);
                            if (count($parts) == 2) {
                              $price = htmlspecialchars(trim($parts[0]));
                              $url = htmlspecialchars(trim($parts[1]));
                              // Linki güvenli göster ve yeni sekmede aç
                              echo '<li class="list-group-item d-flex justify-content-between align-items-center">';
                              echo '<span><b>' . $price . ' TL</b></span>';
                              echo '<a href="' . $url . '" target="_blank" rel="noopener noreferrer" class="btn btn-sm btn-primary">Ödeme Yap</a>';
                              echo '</li>';
                            }
                          }
                          echo '</ul>';
                        } else {
                          echo '<div class="alert alert-warning mb-0">Şu anda tanımlı ödeme linki bulunamadı.</div>';
                        }
                        ?>
                        <?php
                        // Link açıklaması varsa ekle
                        if (isset($pull_payment_detail['link_desc']) && !empty($pull_payment_detail['link_desc'])) {
                          echo '<div class="mt-3">' . nl2br(htmlspecialchars($pull_payment_detail['link_desc'])) . '</div>';
                        }
                        ?>
                      </div>
                      <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Kapat</button>
                      </div>
                    </div>
                  </div>
                </div>


                <div class="modal fade" id="havaleModal" tabindex="-1" aria-labelledby="havaleModalLabel"
                  aria-hidden="true">
                  <div class="modal-dialog modal-dialog-centered">
                    <div class="modal-content">
                      <div class="modal-header">
                        <h5 class="modal-title" id="havaleModalLabel">Banka Havalesi Bilgileri</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Kapat"></button>
                      </div>
                      <div class="modal-body">
                        <?php echo $pull_payment_detail['bank_detail']; ?>
                      </div>
                      <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Kapat</button>
                      </div>
                    </div>
                  </div>
                </div>
                <script>
                  $(document).ready(function () {
                    $('#havaleOption').on('click', function (e) {
                      e.stopPropagation();
                      $('#havaleModal').modal('show');
                    });
                  });

                  $(document).ready(function () {
                    $('#linkOption').on('click', function (e) {
                      e.stopPropagation();
                      $('#linkModal').modal('show');
                    });
                  });
                </script>

              </div>
            </div>

            <div class="mt-4 border-top pt-4 mb-3">
              <label class="form-label">Hediye Kodu Kullan</label>
              <div class="input-group">
                <input type="text" class="form-control" id="gift_code" placeholder="Hediye kodunuzu giriniz">
                <button class="btn btn-success" type="button" id="btnRedeemCode">Kullan</button>
              </div>
              <div id="giftCodeResult" class="mt-2"></div>
            </div>
            <input type="hidden" id="selectedMethod" name="selectedMethod" value="">
          </form>
        </div>

        <?php

        $balance_payments = $baglan->query("SELECT method, price, create_date, create_hour, status, payment_id FROM balance_payments WHERE user_id = '" . intval($user_id) . "' AND status = '1' ORDER BY id DESC");
        ?>

        <div class="card mt-4" style="padding:10px;border:0px;">
          <div class="card-header">
            <strong>Geçmiş Bakiye Yükleme Kayıtlarınız</strong>
          </div>
          <div class="card-body p-0">
            <div class="table-responsive">
              <table class="table table-striped mb-0">
                <thead>
                  <tr>
                    <th>Method</th>
                    <th>Miktar</th>
                    <th>Tarih</th>
                    <th>Saat</th>
                    <th>Durum</th>
                    <th>ID</th>
                  </tr>
                </thead>
                <tbody>
                  <?php if ($balance_payments && $balance_payments->num_rows > 0): ?>
                    <?php while ($row = $balance_payments->fetch_assoc()): ?>
                      <tr>
                        <td><?php echo htmlspecialchars($row['method']); ?></td>
                        <td><?php echo htmlspecialchars($row['price']); ?> ₺</td>
                        <td><?php echo date('d.m.Y', strtotime($row['create_date'])); ?></td>
                        <td><?php echo htmlspecialchars($row['create_hour']); ?></td>
                        <td>
                          <?php
                          if ($row['status'] == '1') {
                            echo '<span class="badge bg-success">Onaylandı</span>';
                          } elseif ($row['status'] == '2') {
                            echo '<span class="badge bg-danger">Reddedildi</span>';
                          } else {
                            echo '<span class="badge bg-warning text-dark">Bekliyor</span>';
                          }
                          ?>
                        </td>
                        <td><?php echo htmlspecialchars($row['payment_id']); ?></td>
                      </tr>
                    <?php endwhile; ?>
                  <?php else: ?>
                    <tr>
                      <td colspan="6" class="text-center">Kayıt bulunamadı.</td>
                    </tr>
                  <?php endif; ?>
                </tbody>
              </table>
            </div>
          </div>
        </div>

      </div>
    </div>
  </div>
</div>
<style>
  .payment-option {
    transition: box-shadow 0.2s, border-color 0.2s;
  }

  .payment-option.selected {
    border: 2px solid #0d6efd;
    box-shadow: 0 0 0 0.2rem rgba(13, 110, 253, .25);
    background: #f0f8ff;
  }
</style>
<script>
  $(function () {
    $('#amount').on('input', function () {
      var val = $(this).val();
      val = val.replace(/[^0-9]/g, '');
      val = val.replace(/^0+/, '');
      $(this).val(val);
    });

    $('.payment-option').on('click', function () {
      $('.payment-option').removeClass('selected');
      $(this).addClass('selected');
      $('#selectedMethod').val($(this).data('method'));

      var amountStr = $('#amount').val();
      var minBalance = <?php echo json_encode((int) $min_balance); ?>;
      var amount = parseInt(amountStr, 10);

      if (isNaN(amount) || amount < minBalance) {
        alert("Minimum yükleme tutarı " + minBalance + "₺'dir. Lütfen geçerli bir tutar giriniz.");
        $('#amount').focus();
        return;
      }

      var user_id = <?php echo json_encode($user_id); ?>;
      var method = $(this).data('method');

      if (method === 'havale') {
        return;
      }

      if (method === 'link') {
        return;
      }

      if (method === 'stripe') {
        var url = "payment_center.php?price=" + encodeURIComponent(amount) + "&user_id=" + encodeURIComponent(user_id) + "&method=" + encodeURIComponent(method);
        window.location.href = url;
        return;
      }

      var url = "payment_center.php?price=" + encodeURIComponent(amount) + "&user_id=" + encodeURIComponent(user_id) + "&method=" + encodeURIComponent(method);
      window.location.href = url;
    });

    $('#balanceForm').on('submit', function (e) {
      e.preventDefault();
      return false;
    });

    $('#btnRedeemCode').on('click', function () {
      var code = $('#gift_code').val();
      if (code == "") {
        $('#giftCodeResult').html('<div class="alert alert-warning">Lütfen bir kod giriniz.</div>');
        return;
      }

      $(this).prop('disabled', true).text('İşleniyor...');

      $.ajax({
        url: 'api/redeem_gift_code.php',
        type: 'POST',
        data: { gift_code: code },
        dataType: 'json',
        success: function (response) {
          if (response.success) {
            $('#giftCodeResult').html('<div class="alert alert-success">' + response.message + '</div>');
            $('#gift_code').val('');
            setTimeout(function () { location.reload(); }, 2000);
          } else {
            $('#giftCodeResult').html('<div class="alert alert-danger">' + response.message + '</div>');
            $('#btnRedeemCode').prop('disabled', false).text('Kullan');
          }
        },
        error: function () {
          $('#giftCodeResult').html('<div class="alert alert-danger">Bir hata oluştu.</div>');
          $('#btnRedeemCode').prop('disabled', false).text('Kullan');
        }
      });
    });
  });
</script>

<?php include("footer.php"); ?>