<?php 
include("header.php");
$api_url = rtrim($site_address ?? '', '/') . "/api/"; 

?>
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css">
<div class="container">
<div class="desktop" style="margin-top:50px;"></div>
<div class="mobile" style="margin-top:-10px;"></div>
  <div class="row">
    <div class="col-md-3 mb-4">
      <?php include("navigation.php"); ?>
    </div>
    <div class="col-md-9">
      <div class="card api-section-card">
        <div class="card-body p-0">
          <h2 class="api-section-title"><i class="fa-solid fa-plug"></i> API Details</h2>
          <table class="api-info-table mb-4">
            <tr>
              <td class="api-info-label">API URL:</td>
              <td>
                <code id="api-url"><?php echo $api_url; ?></code>
                <button class="btn btn-sm btn-outline-primary api-copy-btn" onclick="copyToClipboard('api-url')">
                  <i class="fas fa-copy"></i> Copy
                </button>
              </td>
            </tr>
            <tr>
              <td class="api-info-label">API Key:</td>
              <td>
                <code id="api-key"><?php echo $user_api_key; ?></code>
                <button class="btn btn-sm btn-outline-primary api-copy-btn" onclick="copyToClipboard('api-key')">
                  <i class="fas fa-copy"></i> Copy
                </button>
              </td>
            </tr>
            <tr>
              <td class="api-info-label">Method:</td>
              <td>
                <code>POST</code>
              </td>
            </tr>
            <tr>
              <td class="api-info-label">Response Format:</td>
              <td>
                <code>JSON</code>
              </td>
            </tr>
          </table>

          <hr class="my-4">

          <h4 class="mb-4" style="font-weight:600;">API Usage Examples</h4>

          <!-- Balance -->
          <div>
            <div class="api-example-title"><i class="fa-solid fa-wallet"></i> Balance</div>
            <div class="api-example-label">Endpoint:</div>
            <div class="input-group mb-2" style="max-width: 100%;">
              <input type="text" class="form-control api-endpoint-input" readonly value="<?php echo $api_url; ?>?endpoint=balance" id="balance-endpoint-url">
            </div>
            <div class="api-example-label">PHP Example:</div>
            <div class="api-code-block">
<pre><code>&lt;?php
$post_fields = [
    'api_key' =&gt; "<?php echo $user_api_key; ?>"
];

$ch = curl_init("<?php echo $api_url; ?>?endpoint=balance");

curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($post_fields));
curl_setopt($ch, CURLOPT_HEADER, 0);
curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);

echo curl_exec($ch);
curl_close($ch);
?&gt;</code></pre>
            </div>
            <div class="api-example-label">Sample Response:</div>
            <div class="api-code-block" style="padding-top:1px;">
<pre><code>{
    "balance": "100.00"
}</code></pre>
            </div>
          </div>

          <!-- New Order -->
          <div>
            <div class="api-example-title"><i class="fa-solid fa-cart-plus"></i> New Order</div>
            <div class="api-example-label">Endpoint:</div>
            <div class="input-group mb-2" style="max-width: 100%;">
              <input type="text" class="form-control api-endpoint-input" readonly value="<?php echo $api_url; ?>?endpoint=neworder" id="neworder-endpoint-url">
            </div>
            <div class="api-example-label">PHP Example:</div>
            <div class="api-code-block">
<pre><code>&lt;?php
$post_fields = [
    'api_key' =&gt; "<?php echo $user_api_key; ?>",
    'product_id' =&gt; "1"
];

$ch = curl_init("<?php echo $api_url; ?>?endpoint=neworder");

curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($post_fields));
curl_setopt($ch, CURLOPT_HEADER, 0);
curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);

echo curl_exec($ch);
curl_close($ch);
?&gt;</code></pre>
            </div>
            <div class="api-example-label">Sample Response:</div>
            <div class="api-code-block" style="padding-top:1px;">
<pre><code>{
    "order_id": 35,
    "order_data": "xxx"
}</code></pre>
            </div>
          </div>

          <!-- Order Detail -->
          <div>
            <div class="api-example-title"><i class="fa-solid fa-file-lines"></i> Order Detail</div>
            <div class="api-example-label">Endpoint:</div>
            <div class="input-group mb-2" style="max-width: 100%;">
              <input type="text" class="form-control api-endpoint-input" readonly value="<?php echo $api_url; ?>?endpoint=order" id="order-endpoint-url">
            </div>
            <div class="api-example-label">PHP Example:</div>
            <div class="api-code-block">
<pre><code>&lt;?php
$post_fields = [
    'api_key' =&gt; "<?php echo $user_api_key; ?>",
    'order_id' =&gt; "1"
];

$ch = curl_init("<?php echo $api_url; ?>?endpoint=order");

curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($post_fields));
curl_setopt($ch, CURLOPT_HEADER, 0);
curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);

echo curl_exec($ch);
curl_close($ch);
?&gt;</code></pre>
            </div>
            <div class="api-example-label">Sample Response:</div>
            <div class="api-code-block" style="padding-top:1px;">
<pre><code>{
    "product": 1,
    "data": "xxx",
    "create_date": "2025-05-10",
    "create_time": "23:11:42",
    "price": "1.00",
    "status": 1
}</code></pre>
            </div>
          </div>

          <div>
            <div class="api-example-title"><i class="fa-solid fa-list"></i> Products List</div>
            <div class="api-example-label">Endpoint:</div>
            <div class="input-group mb-2" style="max-width: 100%;">
              <input type="text" class="form-control api-endpoint-input" readonly value="<?php echo $api_url; ?>?endpoint=products" id="products-endpoint-url">
            </div>
            <div class="api-example-label">PHP Example:</div>
            <div class="api-code-block">
<pre><code>&lt;?php
$post_fields = [
    'api_key' =&gt; "<?php echo $user_api_key; ?>"
];

$ch = curl_init("<?php echo $api_url; ?>?endpoint=products");

curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($post_fields));
curl_setopt($ch, CURLOPT_HEADER, 0);
curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);

echo curl_exec($ch);
curl_close($ch);
?&gt;</code></pre>
            </div>
            <div class="api-example-label">Sample Response:</div>
            <div class="api-code-block" style="padding-top:1px;">
<pre><code>[
    {
        "id": "1",
        "title": "Steam Random Key",
        "content": "This product will give you a steam random key containing a surprise game.",
        "image": "images/steam_random_key.jpg",
        "category": "Steam",
        "price": "10.00"
    }
]</code></pre>
            </div>
          </div>

          <script>
            function copyToClipboard(elementId) {
              var el = document.getElementById(elementId);
              if (!el) return;
              var temp = document.createElement("textarea");
              temp.value = el.textContent;
              document.body.appendChild(temp);
              temp.select();
              document.execCommand("copy");
              document.body.removeChild(temp);
            }
          </script>
        </div>
      </div>
    </div>
  </div>
</div>


<style>
.api-info-table {
  width: 100%;
  border-collapse: separate;
  border-spacing: 0 10px;
}
.api-info-table td {
  padding: 8px 0;
  vertical-align: middle;
}
.api-info-label {
  font-weight: 600;
  color: #374151;
  width: 160px;
}
.api-info-value code {
  font-size: 1rem;
  background: #f3f4f6;
  color: #22223b;
  padding: 3px 10px;
  border-radius: 6px;
}
.api-copy-btn {
  margin-left: 10px;
  padding: 2px 12px;
  font-size: 0.95rem;
  border-radius: 5px;
}
.api-section-card {
  background: #fff;
  border-radius: 18px;
  box-shadow: 0 4px 10px rgba(0,0,0,0.07);
  border: none;
  padding: 2.5rem 2rem 2rem 2rem;
}
.api-section-title {
  font-weight: 700;
  font-size: 2rem;
  color: #1a202c;
  margin-bottom: 2rem;
  letter-spacing: -1px;
}
.api-example-title {
  font-weight: 600;
  font-size: 1.15rem;
  color: #2563eb;
  margin-bottom: 0.7rem;
  margin-top: 2.2rem;
  display: flex;
  align-items: center;
  gap: 8px;
}
.api-example-label {
  font-size: 1rem;
  color: #6b7280;
  margin-bottom: 0.2rem;
  margin-top: 0.5rem;
}
.api-code-block {
  background: #181c24;
  color: #e0e0e0;
  border-radius: 10px;
  padding: 18px 18px 10px 18px;
  margin-bottom: 10px;
  font-size: 15px;
  overflow-x: auto;
  border: 1px solid #23272f;
}
.api-code-block pre {
  background: transparent;
  color: inherit;
  border: none;
  margin: 0;
  padding: 0;
}
.api-endpoint-input {
  font-family: monospace;
  font-size: 1rem;
  background: #f1f5f9;
  border: 1px solid #e5e7eb;
  border-radius: 7px;
  color: #22223b;
}
@media (max-width: 767px) {
  .api-section-card { padding: 1.2rem 0.5rem; }
  .api-section-title { font-size: 1.3rem; }
  .api-info-label { width: 100px; }
}
</style>
<?php include("footer.php");?>
