<?php 
include("core/vi_connect.php");
include("core/vi_global.php");
$level = g("level");
?>

<!DOCTYPE html>
<html lang="en" dir="ltr">
<head>
<meta charset="utf-8">
<meta http-equiv="X-UA-Compatible" content="IE=edge">
<meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
<title>Keyapix - Kurulum Yöneticisi</title>

<link href="admin/icons/phosphor/styles.min.css" rel="stylesheet" type="text/css">
<link href="admin/assets/css/ltr/all.min.css" id="stylesheet" rel="stylesheet" type="text/css">


</head>

<body class="bg-dark">
<?php if(empty($level)){?>

<style>

@import url('https://fonts.googleapis.com/css2?family=Inter:ital,opsz,wght@0,14..32,100..900;1,14..32,100..900&family=Poppins:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900&display=swap');

:root{
--g1:#006DFB;
--g2:#9187A8;
}
html,body{
height:100%;
font-family: "Poppins", sans-serif;
font-weight: 100;
font-style: normal;
}
.center-viewport{
height:100vh;
display:flex;
align-items:center;
justify-content:center;
flex-direction:column;
gap:1.5rem;
text-align:center;
padding:1rem;
}
.brand{
font-size:11rem;
font-weight:400;
line-height:1;
letter-spacing:-10px;
background:linear-gradient(90deg,var(--g1),var(--g2),var(--g1));
background-size:300%;
-webkit-background-clip:text;
background-clip:text;
color:transparent;
-webkit-text-fill-color:transparent;
animation:gradientFlow 2s linear infinite reverse;
user-select:none;
}

@keyframes gradientFlow{
0%{background-position:0% 50%;}
100%{background-position:100% 50%;}
}
@media (max-width:576px){
.brand{font-size:6rem;}
}
.cta-btn{
min-width:220px;
padding:0.65rem 1.2rem;
font-size:1.05rem;
border-radius:.6rem;
border:0;
cursor:pointer;
background:#FFFFFF;
color:#555555;
margin-top:90px;
font-weight:400;
}
.cta-btn:focus{outline:none; box-shadow:0 0 0 4px rgba(0,109,251,0.12);}
</style>

<main class="center-viewport">
<h1 class="brand">Keyapix</h1>
<a href="setup.php?level=2" class="cta-btn">Hadi başlayalım</a>
</main>
<?php } ?>

<?php if($level == "2"){?>
<div class="page-content">
<div class="content-wrapper">
<div class="content-inner">
<div class="content d-flex justify-content-center align-items-center">
<div class="card">
<div class="card-header">
<h6 class="hstack gap-2 mb-0">
<i class="ph-circle-wavy-warning text-danger"></i>
Başlamadan Önce;
</h6>
</div>

<div class="card-body">
<ul>
<li>Lütfen php sürümünüzün <b>7.4</b> olduğundan emin olunuz.</li>
<li>Php eklentilerinden <b>"mysqli"</b> eklentisinin <b><font color="#EB0000">kapalı</font></b> olduğundan emin olunuz.</li>
<li>Php eklentilerinden <b>"nd_mysqli"</b> eklentisinin <b><font color="#11991B">açık</font></b> olduğuna emin olunuz.</li>
<li>Sunucunuzda ioncube bulunması gerekmektedir.</li>
<li>Https bağlantı gerektirmektedir.</li>
<li>Cpanel destekli sunucu tavsiye edilmektedir.</li>
<li>Yurtiçindeki sunucu firmalarından guzelhosting kullanabilirsiniz. (Tam uyumlu)</li>
<li>Yurtdışı sunucu firmalarından namecheap kullanabilirsiniz. (Tam uyumlu)</li>
</ul>
<a class="btn btn-success" href="setup.php?level=3">Anladım, Devam Et</a>
</div>
</div>
</div></div>
</div>
</div>
<?php } ?>

<?php if($level == "3"){?>
<div class="page-content">
<div class="content-wrapper">
<div class="content-inner">
<div class="content d-flex justify-content-center align-items-center">

<form action="setup.php?level=4" method="post" class="login-form">
<div class="card mb-0">
<div class="card-body">
<div class="text-center mb-3">
<div class="d-inline-flex align-items-center justify-content-center mb-4 mt-2">
<img src="images/logo-968732.png" class="h-48px" alt="">
</div>
<h5 class="mb-0">Veritabanı Bağlantısı</h5>
<span class="d-block text-muted">Lütfen aşağıdaki veritabanı bilgilerinizi doldurunuz.</span>
</div>

<div class="mb-3">
<label class="form-label">Veritabanı Host Adresi</label>
<div class="form-control-feedback form-control-feedback-start">
<input type="text" name="vk_alan" class="form-control" value="localhost" required="required">
<div class="form-control-feedback-icon">
<i class="ph-caret-circle-right text-muted"></i>
</div>
</div>
</div>

<div class="mb-3">
<label class="form-label">Veritabanı Adı</label>
<div class="form-control-feedback form-control-feedback-start">
<input type="text" name="vk_ismi" class="form-control" required="required">
<div class="form-control-feedback-icon">
<i class="ph-caret-circle-right text-muted"></i>
</div>
</div>
</div>

<div class="mb-3">
<label class="form-label">Veritabanı Kullanıcı Adı</label>
<div class="form-control-feedback form-control-feedback-start">
<input type="text" name="vk_kullanici" class="form-control" required="required">
<div class="form-control-feedback-icon">
<i class="ph-user-circle text-muted"></i>
</div>
</div>
</div>

<div class="mb-3">
<label class="form-label">Veritabanı Şifre</label>
<div class="form-control-feedback form-control-feedback-start">
<input type="password" name="vk_sifre" class="form-control">
<div class="form-control-feedback-icon">
<i class="ph-lock text-muted"></i>
</div>
</div>
</div>


<div class="mb-3">
<button type="submit" class="btn btn-primary w-100">Devam Et</button>
</div>

<span class="form-text text-center text-muted">Yardımamı ihtiyacınız var? <a href="https://keyapix.com" target="_blank">Keyapix'e ulaşın</a></span>
</div>
</div>
</form>
</div>
</div>
</div>
</div>
<?php } ?>


<?php if($level == "4"){?>
<div class="page-content">
<div class="content-wrapper">
<div class="content-inner">
<div class="content d-flex justify-content-center align-items-center">
<div class="col-lg-4">
<div class="card card-body">
<h6 class="fw-semibold">Veritabanı Bağlantısı Kontrol Ediliyor</h6>
<p class="mb-3">5 saniye içinde kontrol tamamlanacak...</p>

<div>
<div class="spinner-border" role="status">
<span class="visually-hidden">Loading...</span>
</div>
</div>
</div>
</div>
</div>
</div>
</div>
</div>
<?php
$vk_alan = $_POST["vk_alan"];
$vk_ismi = $_POST["vk_ismi"];
$vk_kullanici = $_POST["vk_kullanici"];
$vk_sifre = $_POST["vk_sifre"];
$dosya = fopen('core/vi_connect.php', 'w');
fwrite($dosya, "<?php");
fwrite($dosya, "\r\n");
fwrite($dosya, "error_reporting(0);");
fwrite($dosya, "\r\n");
fwrite($dosya, '$baglan = new mysqli("'.$vk_alan.'", "'.$vk_kullanici.'", "'.$vk_sifre.'", "'.$vk_ismi.'");');
fwrite($dosya, "\r\n");
fwrite($dosya, '$baglan->set_charset("utf8mb4");');
fwrite($dosya, "\r\n");
fwrite($dosya, "?>");
fclose($dosya);
?>
<meta http-equiv="refresh" content="5;URL=setup.php?level=5">
<?php } ?>


<?php if($level == "5"){?>
<div class="page-content">
<div class="content-wrapper">
<div class="content-inner">
<div class="content d-flex justify-content-center align-items-center">
<div class="col-lg-4">
<div class="card card-body">
<h6 class="fw-semibold">Veritabanı Bağlantısı Kontrol Edildi</h6>
<p class="mb-3">
<?php
include("vi_connect.php");

if($baglan->connect_errno > 0){
echo '<font color="red">Veritabanı bilgileriniz hatalı. Lütfen tekrar deneyin.</font><br><br>

<a class="btn btn-dark text-white" href="setup.php?level=3"> <i class="fas fa-chevron-left"></i> Geri Dön</a>
';
}else{
echo '<font color="#00b70c">Bağlantı Başarıyla Gerçekleşti... İşlem devam ediyor...</font>';	
echo '<meta http-equiv="refresh" content="4;URL=setup.php?level=6">';
}
?>
</p>

<div>

</div>
</div>
</div>
</div>
</div>
</div>
</div>
<?php } ?>

<?php if($level == "6"){?>
<div class="page-content">
<div class="content-wrapper">
<div class="content-inner">
<div class="content d-flex justify-content-center align-items-center">
<div class="col-lg-4">
<div class="card card-body">
<h6 class="fw-semibold">Veritabanı Aktarılıyor</h6>
<p class="mb-3">Lütfen bekleyiniz bu işlem 5 saniye sürebilir.</p>
<?php

$query = '';
$sqlScript = file('db.sql');
foreach ($sqlScript as $line)	{

$startWith = substr(trim($line), 0 ,2);
$endWith = substr(trim($line), -1 ,1);

if (empty($line) || $startWith == '--' || $startWith == '/*' || $startWith == '//') {
continue;
} 

$query = $query . $line;
if ($endWith == ';') {
mysqli_query($baglan,$query) or die('<div class="error-response sql-import-response">Hata olustu: <b>' . $query. '</b></div>');
$query= '';		
}
}
echo '<meta http-equiv="refresh" content="5;URL=setup.php?level=7">';

?>
<div class="spinner-border" role="status">
<span class="visually-hidden">Loading...</span>
</div>
</div>
</div>
</div>
</div>
</div>
</div>
<?php } ?>

<?php if($level == "7"){
$state = g("state");
if($state == "dimok"){
$site_address = p("site_address");
$licence_key = p("licence_key");
$username = p("username");
$password = p("password");
$password_hash  = password_hash($password, PASSWORD_DEFAULT);
$gas = bin2hex(random_bytes(16));
$baglan->query("UPDATE settings SET site_address = '$site_address', licence_key = '$licence_key' WHERE id = '1'");
$user_add = $baglan->query("INSERT INTO user (username,password,gas) VALUES ('$username','$password_hash','$gas')");
if($user_add){echo '<meta http-equiv="refresh" content="0;URL=setup.php?level=8">';}
}
?>
<div class="page-content">
<div class="content-wrapper">
<div class="content-inner">
<div class="content d-flex justify-content-center align-items-center">

<form action="setup.php?level=7&state=dimok" method="post" class="login-form">
<div class="card mb-0">
<div class="card-body">
<div class="text-center mb-3">
<div class="d-inline-flex align-items-center justify-content-center mb-4 mt-2">
<img src="images/logo-968732.png" class="h-48px" alt="">
</div>
<h5 class="mb-0">Sistem Ayarları</h5>
<span class="d-block text-muted">Lütfen aşağıdaki bilgilerinizi doldurunuz.</span>
</div>

<div class="mb-3">
<label class="form-label">Site Adresiniz</label>
<div class="form-control-feedback form-control-feedback-start">
<input type="text" name="site_address" class="form-control" value="localhost" required="required">
<div class="form-control-feedback-icon">
<i class="ph-caret-circle-right text-muted"></i>
</div>
</div>
<small>Örneğin: https://keyapix.com</small>
</div>

<div class="mb-3">
<label class="form-label">Lisans Anahtarınız</label>
<div class="form-control-feedback form-control-feedback-start">
<input type="text" name="licence_key" class="form-control" required="required">
<div class="form-control-feedback-icon">
<i class="ph-caret-circle-right text-muted"></i>
</div>
</div>
</div>

<div class="mb-3">
<label class="form-label">Admin Kullanıcı Adı</label>
<div class="form-control-feedback form-control-feedback-start">
<input type="text" name="username" class="form-control" required="required">
<div class="form-control-feedback-icon">
<i class="ph-user-circle text-muted"></i>
</div>
</div>
</div>

<div class="mb-3">
<label class="form-label">Admin Şifresi</label>
<div class="form-control-feedback form-control-feedback-start">
<input type="password" name="password" class="form-control">
<div class="form-control-feedback-icon">
<i class="ph-lock text-muted"></i>
</div>
</div>
</div>


<div class="mb-3">
<button type="submit" class="btn btn-primary w-100">Devam Et</button>
</div>

<span class="form-text text-center text-muted">Yardımamı ihtiyacınız var? <a href="https://keyapix.com" target="_blank">Keyapix'e ulaşın</a></span>
</div>
</div>
</form>
</div>
</div>
</div>
</div>
<?php } ?>

<?php if($level == "8"){?>
<div class="page-content">
<div class="content-wrapper">
<div class="content-inner">
<div class="content d-flex justify-content-center align-items-center">
<div class="col-lg-4">
<div class="card card-body">
<h6 class="fw-semibold"><i class="ph-check-circle"></i> Herşey Hazır</h6>
<p class="mb-3">Tebrikler, yazılım başarıyla kuruldu. Artık hayallerinizdeki işe sahip olmak için ilkadımı attınız.</p>
<p class="mb-3">Lütfen bekleyin...</p>

<div class="spinner-border" role="status">
<span class="visually-hidden">Loading...</span>
</div>

<meta http-equiv="refresh" content="5;URL=admin/index.php?source=setup">
</div>
</div>
</div>
</div>
</div>
</div>
<?php } ?>

</body>
</html>

