<?php
require_once("core/vi_connect.php");
require_once("core/vi_global.php");

$status = g("status");
$payment_id = g("payment_id");

// Stripe webhook işlemi
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_SERVER['HTTP_STRIPE_SIGNATURE'])) {
    $payload = @file_get_contents('php://input');
    $signature = $_SERVER['HTTP_STRIPE_SIGNATURE'];
    
    $pull_data = $baglan->query("SELECT * FROM payment_option WHERE id = '1'")->fetch_assoc();
    $stripe_webhook_secret = $pull_data['stripe_webhook_secret'];
    
    require_once 'core/stripe/Stripe.php';
    $stripe = new Stripe('', '');
    
    // Webhook signature'ı doğrula
    if ($stripe->verifyWebhook($payload, $signature, $stripe_webhook_secret)) {
        $event = json_decode($payload, true);
        
        if ($event['type'] === 'payment_intent.succeeded') {
            $payment_intent = $event['data']['object'];
            $metadata = $payment_intent['metadata'];
            
            if (isset($metadata['payment_id'])) {
                $payment_id_from_webhook = $metadata['payment_id'];
                $user_id_from_webhook = isset($metadata['user_id']) ? intval($metadata['user_id']) : 0;
                $amount = $payment_intent['amount'] / 100; // Kuruştan TL'ye çevir
                
                // Ödeme kaydını bul ve onayla
                $payment_query = $baglan->query("SELECT * FROM balance_payments WHERE payment_id = '$payment_id_from_webhook' AND status = '0' LIMIT 1");
                if ($payment_query && $payment_query->num_rows > 0) {
                    $payment_row = $payment_query->fetch_assoc();
                    $user_id = intval($payment_row['user_id']);
                    $price = floatval($payment_row['price']);
                    
                    // Tutar kontrolü
                    if (abs($amount - $price) < 0.01) { // Küçük farklar için tolerans
                        // Bakiye güncelle
                        $baglan->query("UPDATE users SET balance = balance + $price WHERE id = '$user_id'");
                        
                        // Ödeme durumunu güncelle
                        $baglan->query("UPDATE balance_payments SET status = '1' WHERE payment_id = '$payment_id_from_webhook'");
                        
                        http_response_code(200);
                        echo json_encode(['status' => 'success']);
                        exit;
                    }
                }
            }
        }
    }
    
    http_response_code(400);
    echo json_encode(['status' => 'error']);
    exit;
}

// Başarılı ödeme sonrası yönlendirme
if ($status == "stripe_success" && !empty($payment_id)) {
    $payment_query = $baglan->query("SELECT * FROM balance_payments WHERE payment_id = '$payment_id' LIMIT 1");
    if ($payment_query && $payment_query->num_rows > 0) {
        $payment_row = $payment_query->fetch_assoc();
        if ($payment_row['status'] == '1') {
            echo '<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Ödeme Başarılı</title>
    <style>
        body {
            font-family: -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, sans-serif;
            display: flex;
            justify-content: center;
            align-items: center;
            min-height: 100vh;
            margin: 0;
            background: #f5f5f5;
        }
        .success-container {
            background: white;
            padding: 2rem;
            border-radius: 8px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
            text-align: center;
            max-width: 400px;
        }
        .success-icon {
            color: #28a745;
            font-size: 3rem;
            margin-bottom: 1rem;
        }
        h1 {
            color: #333;
            margin: 0.5rem 0;
        }
        .btn {
            display: inline-block;
            padding: 10px 20px;
            background: #6772E5;
            color: white;
            text-decoration: none;
            border-radius: 4px;
            margin-top: 1rem;
        }
    </style>
</head>
<body>
    <div class="success-container">
        <div class="success-icon">✓</div>
        <h1>Ödeme Başarılı!</h1>
        <p>Bakiyeniz başarıyla yüklendi.</p>
        <a href="balance/" class="btn">Bakiye Sayfasına Dön</a>
    </div>
</body>
</html>';
            exit;
        }
    }
}

// Diğer ödeme yöntemleri için mevcut kodlar
if ($status == "basarili") {
    echo '<meta http-equiv="refresh" content="0;url=balance/?status=success">';
    exit;
}

if ($status == "hata") {
    echo '<meta http-equiv="refresh" content="0;url=balance/?status=error">';
    exit;
}

?>
