<?php
// WARNING: This is a payment page structure.
// Modifications made here may cause errors in the payment system functionality.
// If you do not have the necessary backend knowledge, please do not make changes to this structure and contact Keyapix for assistance.

require_once("core/vi_connect.php"); ##-> Mysql connect
require_once("core/vi_global.php"); ##-> Global function

$price = g("price");
$user_id = g("user_id");
$method = g("method");

if (empty($price) || empty($user_id) || empty($method)) {
    echo '<meta http-equiv="refresh" content="0;url=/" />';
    exit;
}

$pull_data = $baglan->query("SELECT * FROM settings WHERE id = '1'")->fetch_assoc();
$site_address = $pull_data["site_address"];

$pull_user = $baglan->query("SELECT * FROM users WHERE id = '$user_id'")->fetch_assoc();
$user_control_id = $pull_user["id"];
$username = $pull_user["username"];
$first_name = $pull_user["first_name"];
$surname = $pull_user["surname"];
$email = $pull_user["email"];
$phone = $pull_user["phone"];
$ip = $_SERVER['REMOTE_ADDR'];
$create_date = date("Y-m-d");
$create_hour = date("H:i:s");
$payment_id = random_int(100000000, 999999999);

$pull_data = $baglan->query("SELECT * FROM payment_option WHERE id = '1'")->fetch_assoc();
$shopier_option = $pull_data["shopier_option"];
$paytr_option = $pull_data["paytr_option"];
$stripe_option = $pull_data["stripe_option"];

if($shopier_option == 1){
$shopier_api = $pull_data["shopier_api"];
$shopier_key = $pull_data["shopier_key"];
}
if($paytr_option == 1){
$paytr_merchant_id = $pull_data["paytr_merchant_id"];
$paytr_merchant_key = $pull_data["paytr_merchant_key"];
$paytr_merchant_salt = $pull_data["paytr_merchant_salt"];
}
if($stripe_option == 1){
$stripe_secret_key = $pull_data["stripe_secret_key"];
$stripe_publishable_key = $pull_data["stripe_publishable_key"];
$stripe_webhook_secret = $pull_data["stripe_webhook_secret"];
}

if(empty($user_control_id)){
    echo '<meta http-equiv="refresh" content="0;url=/" />';
    exit;   
}else{

$add_order = $baglan->query("INSERT INTO balance_payments ( 
    user_id,
    first_name,
    surname,
    email,
    phone,
    ip,
    create_date,
    create_hour,
    price,
    method,
    status,
    payment_id
    ) VALUES (
    '$user_id',
    '$first_name',
    '$surname',
    '$email',
    '$phone',
    '$ip',
    '$create_date',
    '$create_hour',
    '$price',
    '$method',
    '0',
    '$payment_id'
    )");
}

if($method == "shopier"){
##-> Shopier Payment Method
include 'core/shopier/shopierAPI.php';

$shopier = new Shopier($shopier_api, $shopier_key);
$shopier->setBuyer([
'id' => ''.$payment_id.'',
'paket' => 'Bakiye Yükleme',
'first_name' => ''.$first_name.'',
'last_name' => ''.$surname.'',
'email' => ''.$email.'',
'phone' => ''.$phone.'']);
$shopier->setOrderBilling([
'billing_address' => 'Dijital Ürün',
'billing_city' => 'TR', 
'billing_country' => 'Türkiye',
'billing_postcode' => '34000', 
]);

$shopier->setOrderShipping([
'shipping_address' => 'Dijital Ürün',
'shipping_city' => 'TR', 
'shipping_country' => 'Türkiye', 
'shipping_postcode' => '34000', 
]);
die($shopier->run(''.$payment_id.'', ''.$price.'', ''.$site_address.'')); 
}

if($method == "paytr"){
##-> Paytr Payment Method

	## 1. ADIM için örnek kodlar ##

	####################### DÜZENLEMESİ ZORUNLU ALANLAR #######################
	#
	## API Entegrasyon Bilgileri - Mağaza paneline giriş yaparak BİLGİ sayfasından alabilirsiniz.
	$merchant_id 	= $paytr_merchant_id;
	$merchant_key 	= $paytr_merchant_key;
	$merchant_salt	= $paytr_merchant_salt;
	#
	## Müşterinizin sitenizde kayıtlı veya form vasıtasıyla aldığınız eposta adresi
	$email = $email;
	#
	## Tahsil edilecek tutar.
	$odeme_fiyat = $price * 100;
	$payment_amount	= $odeme_fiyat; //9.99 için 9.99 * 100 = 999 gönderilmelidir.
	#
	## Sipariş numarası: Her işlemde benzersiz olmalıdır!! Bu bilgi bildirim sayfanıza yapılacak bildirimde geri gönderilir.
	$merchant_oid = $payment_id;
	#
	## Müşterinizin sitenizde kayıtlı veya form aracılığıyla aldığınız ad ve soyad bilgisi
	$user_name = $username;
	#
	## Müşterinizin sitenizde kayıtlı veya form aracılığıyla aldığınız adres bilgisi
	$user_address = "Dijital Ürün";
	#
	## Müşterinizin sitenizde kayıtlı veya form aracılığıyla aldığınız telefon bilgisi
	$user_phone = $phone;
	#
	## Başarılı ödeme sonrası müşterinizin yönlendirileceği sayfa
	## !!! Bu sayfa siparişi onaylayacağınız sayfa değildir! Yalnızca müşterinizi bilgilendireceğiniz sayfadır!
	## !!! Siparişi onaylayacağız sayfa "Bildirim URL" sayfasıdır (Bakınız: 2.ADIM Klasörü).
	$merchant_ok_url = "$site_address/payment_notify.php?status=basarili";
	#
	## Ödeme sürecinde beklenmedik bir hata oluşması durumunda müşterinizin yönlendirileceği sayfa
	## !!! Bu sayfa siparişi iptal edeceğiniz sayfa değildir! Yalnızca müşterinizi bilgilendireceğiniz sayfadır!
	## !!! Siparişi iptal edeceğiniz sayfa "Bildirim URL" sayfasıdır (Bakınız: 2.ADIM Klasörü).
	$merchant_fail_url = "$site_address/payment_notify.php?status=hata";
	#
	## Müşterinin sepet/sipariş içeriği
	$user_basket = ""; 
	#

	$user_basket = base64_encode(json_encode(array(
		array("Bakiye Ödemesi", "$price", 1)
	)));

	############################################################################################

	## Kullanıcının IP adresi
	if( isset( $_SERVER["HTTP_CLIENT_IP"] ) ) {
		$ip = $_SERVER["HTTP_CLIENT_IP"];
	} elseif( isset( $_SERVER["HTTP_X_FORWARDED_FOR"] ) ) {
		$ip = $_SERVER["HTTP_X_FORWARDED_FOR"];
	} else {
		$ip = $_SERVER["REMOTE_ADDR"];
	}

	## !!! Eğer bu örnek kodu sunucuda değil local makinanızda çalıştırıyorsanız
	## buraya dış ip adresinizi (https://www.whatismyip.com/) yazmalısınız. Aksi halde geçersiz paytr_token hatası alırsınız.
	$user_ip=$ip;
	##

	## İşlem zaman aşımı süresi - dakika cinsinden
	$timeout_limit = "30";

	## Hata mesajlarının ekrana basılması için entegrasyon ve test sürecinde 1 olarak bırakın. Daha sonra 0 yapabilirsiniz.
	$debug_on = 1;

    ## Mağaza canlı modda iken test işlem yapmak için 1 olarak gönderilebilir.
    $test_mode = 0;

	$no_installment	= 0; // Taksit yapılmasını istemiyorsanız, sadece tek çekim sunacaksanız 1 yapın

	## Sayfada görüntülenecek taksit adedini sınırlamak istiyorsanız uygun şekilde değiştirin.
	## Sıfır (0) gönderilmesi durumunda yürürlükteki en fazla izin verilen taksit geçerli olur.
	$max_installment = 0;

	$currency = "TL";
	
	####### Bu kısımda herhangi bir değişiklik yapmanıza gerek yoktur. #######
	$hash_str = $merchant_id .$user_ip .$merchant_oid .$email .$payment_amount .$user_basket.$no_installment.$max_installment.$currency.$test_mode;
	$paytr_token=base64_encode(hash_hmac('sha256',$hash_str.$merchant_salt,$merchant_key,true));
	$post_vals=array(
			'merchant_id'=>$merchant_id,
			'user_ip'=>$user_ip,
			'merchant_oid'=>$merchant_oid,
			'email'=>$email,
			'payment_amount'=>$payment_amount,
			'paytr_token'=>$paytr_token,
			'user_basket'=>$user_basket,
			'debug_on'=>$debug_on,
			'no_installment'=>$no_installment,
			'max_installment'=>$max_installment,
			'user_name'=>$user_name,
			'user_address'=>$user_address,
			'user_phone'=>$user_phone,
			'merchant_ok_url'=>$merchant_ok_url,
			'merchant_fail_url'=>$merchant_fail_url,
			'timeout_limit'=>$timeout_limit,
			'currency'=>$currency,
            'test_mode'=>$test_mode
		);
	
	$ch=curl_init();
	curl_setopt($ch, CURLOPT_URL, "https://www.paytr.com/odeme/api/get-token");
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
	curl_setopt($ch, CURLOPT_POST, 1) ;
	curl_setopt($ch, CURLOPT_POSTFIELDS, $post_vals);
	curl_setopt($ch, CURLOPT_FRESH_CONNECT, true);
	curl_setopt($ch, CURLOPT_TIMEOUT, 20);
	
	 // XXX: DİKKAT: lokal makinanızda "SSL certificate problem: unable to get local issuer certificate" uyarısı alırsanız eğer
     // aşağıdaki kodu açıp deneyebilirsiniz. ANCAK, güvenlik nedeniyle sunucunuzda (gerçek ortamınızda) bu kodun kapalı kalması çok önemlidir!
     // curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
	 
	$result = @curl_exec($ch);

	if(curl_errno($ch))
		die("PAYTR IFRAME connection error. err:".curl_error($ch));

	curl_close($ch);
	
	$result=json_decode($result,1);
		
	if($result['status']=='success')
		$token=$result['token'];
	else
		die("PAYTR IFRAME failed. reason:".$result['reason']);
	#########################################################################

}

if($method == "stripe"){
##-> Stripe Payment Method
require_once 'core/stripe/Stripe.php';

$stripe = new Stripe($stripe_secret_key, $stripe_publishable_key);

// Payment Intent oluştur
$metadata = [
    'payment_id' => (string)$payment_id,
    'user_id' => (string)$user_id,
    'username' => $username
];

$payment_intent = $stripe->createPaymentIntent($price, 'try', $metadata);

if(isset($payment_intent['error'])) {
    die('Stripe Error: ' . $payment_intent['message']);
}

$client_secret = $payment_intent['client_secret'];
$payment_intent_id = $payment_intent['id'];
?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Stripe Ödeme</title>
    <script src="https://js.stripe.com/v3/"></script>
    <style>
        body {
            font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, Oxygen, Ubuntu, Cantarell, sans-serif;
            display: flex;
            justify-content: center;
            align-items: center;
            min-height: 100vh;
            margin: 0;
            background: #f5f5f5;
        }
        .payment-container {
            background: white;
            padding: 2rem;
            border-radius: 8px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
            max-width: 500px;
            width: 100%;
        }
        h1 {
            margin-top: 0;
            color: #333;
        }
        .amount {
            font-size: 1.5rem;
            font-weight: bold;
            color: #6772E5;
            margin: 1rem 0;
        }
        #card-element {
            padding: 12px;
            border: 1px solid #ddd;
            border-radius: 4px;
            margin: 1rem 0;
        }
        #card-errors {
            color: #dc3545;
            margin: 0.5rem 0;
        }
        button {
            background: #6772E5;
            color: white;
            border: none;
            padding: 12px 24px;
            border-radius: 4px;
            font-size: 16px;
            cursor: pointer;
            width: 100%;
            margin-top: 1rem;
        }
        button:hover {
            background: #5568d3;
        }
        button:disabled {
            background: #ccc;
            cursor: not-allowed;
        }
        .loading {
            display: none;
            text-align: center;
            margin-top: 1rem;
        }
    </style>
</head>
<body>
    <div class="payment-container">
        <h1>Ödeme Yap</h1>
        <div class="amount"><?php echo number_format($price, 2, ',', '.'); ?> ₺</div>
        <p>Kart bilgilerinizi giriniz:</p>
        
        <form id="payment-form">
            <div id="card-element">
                <!-- Stripe Elements will create form elements here -->
            </div>
            <div id="card-errors" role="alert"></div>
            <button id="submit-button">Ödeme Yap</button>
            <div class="loading" id="loading">İşleniyor...</div>
        </form>
    </div>

    <script>
        var stripe = Stripe('<?php echo $stripe_publishable_key; ?>');
        var elements = stripe.elements();
        
        var cardElement = elements.create('card', {
            style: {
                base: {
                    fontSize: '16px',
                    color: '#424770',
                    '::placeholder': {
                        color: '#aab7c4',
                    },
                },
                invalid: {
                    color: '#9e2146',
                },
            },
        });
        
        cardElement.mount('#card-element');
        
        var cardErrors = document.getElementById('card-errors');
        var submitButton = document.getElementById('submit-button');
        var loading = document.getElementById('loading');
        
        cardElement.on('change', function(event) {
            if (event.error) {
                cardErrors.textContent = event.error.message;
            } else {
                cardErrors.textContent = '';
            }
        });
        
        var form = document.getElementById('payment-form');
        form.addEventListener('submit', function(event) {
            event.preventDefault();
            
            submitButton.disabled = true;
            loading.style.display = 'block';
            
            stripe.confirmCardPayment('<?php echo $client_secret; ?>', {
                payment_method: {
                    card: cardElement,
                    billing_details: {
                        name: '<?php echo htmlspecialchars($first_name . " " . $surname, ENT_QUOTES); ?>',
                        email: '<?php echo htmlspecialchars($email, ENT_QUOTES); ?>',
                        phone: '<?php echo htmlspecialchars($phone, ENT_QUOTES); ?>',
                    }
                }
            }).then(function(result) {
                if (result.error) {
                    cardErrors.textContent = result.error.message;
                    submitButton.disabled = false;
                    loading.style.display = 'none';
                } else {
                    // Ödeme başarılı, webhook ile işlenecek
                    window.location.href = '<?php echo $site_address; ?>/payment_notify.php?status=stripe_success&payment_id=<?php echo $payment_id; ?>';
                }
            });
        });
    </script>
</body>
</html>
<?php
exit;
}

?>