<?php
error_reporting(0);
function g ($get) {  return htmlspecialchars(addslashes($_GET[$get]));}
function p ($post) {  return htmlspecialchars(addslashes($_POST[$post])); }
function seo($s) {
 $tr = array('?','ş','Ş','ı','I','İ','ğ','Ğ','ü','Ü','ö','Ö','Ç','ç','(',')','/',':',',');
 $eng = array('','s','s','i','i','i','g','g','u','u','o','o','c','c','','','-','-','');
 $s = str_replace($tr,$eng,$s);
 $s = strtolower($s);
 $s = preg_replace('/&amp;amp;amp;amp;amp;amp;amp;amp;amp;.+?;/', '', $s);
 $s = preg_replace('/\s+/', '-', $s);
 $s = preg_replace('|-+|', '-', $s);
 $s = preg_replace('/#/', '', $s);
 $s = str_replace('.', '', $s);
 $s = trim($s, '-');
 return $s;
}

// İndirimli fiyat hesaplama fonksiyonu
function calculateDiscountPrice($baglan, $user_id, $product_id, $original_price) {
    if (empty($user_id) || empty($product_id)) {
        return $original_price;
    }
    
    $discount_rate = 0;
    
    $product_discount_query = $baglan->prepare("SELECT discount_rate FROM dealer_discounts WHERE dealer_user_id = ? AND product_id = ? LIMIT 1");
    if ($product_discount_query) {
        $product_discount_query->bind_param("ii", $user_id, $product_id);
        $product_discount_query->execute();
        $product_discount_result = $product_discount_query->get_result();
        if ($product_discount_result && $product_discount_result->num_rows > 0) {
            $product_discount_row = $product_discount_result->fetch_assoc();
            $discount_rate = floatval($product_discount_row['discount_rate']);
        }
        $product_discount_query->close();
    }
    
    if ($discount_rate == 0) {
        $general_discount_query = $baglan->prepare("SELECT dealership_rate FROM users WHERE id = ? LIMIT 1");
        if ($general_discount_query) {
            $general_discount_query->bind_param("i", $user_id);
            $general_discount_query->execute();
            $general_discount_result = $general_discount_query->get_result();
            if ($general_discount_result && $general_discount_result->num_rows > 0) {
                $general_discount_row = $general_discount_result->fetch_assoc();
                $dealership_rate = floatval($general_discount_row['dealership_rate']);
                if ($dealership_rate > 0) {
                    $discount_rate = $dealership_rate;
                }
            }
            $general_discount_query->close();
        }
    }
    
    if ($discount_rate > 0) {
        $discount_amount = ($original_price * $discount_rate) / 100;
        $discounted_price = $original_price - $discount_amount;
        return max(0, $discounted_price); 
    }
    
    return $original_price;
}
?>