<?php
include("vi_connect.php");
include("vi_global.php");

if ($_SERVER['REQUEST_METHOD'] !== 'GET') {
    http_response_code(405);
    exit;
}

$product_id = g("product_id");

if ($product_id === null || $product_id === '' || !is_numeric($product_id) || intval($product_id) < 1) {
    exit;
}
$product_id = intval($product_id);

$query = $baglan->prepare("SELECT content FROM products WHERE id = ?");
if ($query) {
    $query->bind_param("i", $product_id);
    if ($query->execute()) {
        $result = $query->get_result();
        if ($result && $row = $result->fetch_assoc()) {
            $desc = trim($row['content']);
            if ($desc !== '') {
                echo nl2br(htmlspecialchars($desc, ENT_QUOTES, 'UTF-8'));
            }
        }
    } else {
        error_log("get_products_desc.php: Query execute error: " . $query->error);
    }
    $query->close();
} else {
    error_log("get_products_desc.php: Query prepare error: " . $baglan->error);
}

?>
