<?php
include("vi_connect.php");
include("vi_global.php");
$category_id = g('category_id');
if ($category_id !== null && $category_id !== '') {
    $category_id = intval($category_id);

    $query = $baglan->prepare("SELECT id, title, price FROM products WHERE category = ? ORDER BY row ASC");
    if ($query) {
        $query->bind_param("i", $category_id);
        $query->execute();
        $result = $query->get_result();

        if ($result && $result->num_rows > 0) {
            // Kullanıcı ID'sini al
            $user_id_for_discount = 0;
            $user_no = isset($_COOKIE['hikey']) ? $_COOKIE['hikey'] : '';
            if (!empty($user_no)) {
                $user_id_query = $baglan->query("SELECT id FROM users WHERE user_no = '".mysqli_real_escape_string($baglan, $user_no)."' LIMIT 1");
                if ($user_id_query && $user_id_row = $user_id_query->fetch_assoc()) {
                    $user_id_for_discount = intval($user_id_row['id']);
                }
            }
            
            while ($product = $result->fetch_assoc()) {
                // İndirimli fiyatı hesapla
                $discounted_price = calculateDiscountPrice($baglan, $user_id_for_discount, $product['id'], $product['price']);
                echo "<option value='" . htmlspecialchars($product['id']) . "'>" . htmlspecialchars($product['id']) . " - " . htmlspecialchars($product['title']) . " - " . number_format($discounted_price, 2, ',', '.') . " ₺</option>";
            }
        } else {
            echo "<option value=''>Ürün Bulunamadı</option>";
        }
        $query->close();
    } else {
        echo "<option value=''>Sorgu hatası</option>";
    }
}
?>
