<?php
ob_start();
@session_start();
require_once("../../core/vi_connect.php"); ##-> Mysql connect
require_once("../../core/vi_global.php"); ##-> Global funcitons
$status = g("status");
$ticket_id = g("ticket_id");
$admin_user_no = $_COOKIE['_ga_Ascaszu'];
##-> User session control
$user_no = $_COOKIE['hikey'];
$user_control = 0;
if (!empty($user_no)) {
    $user_check = $baglan->query("SELECT id FROM users WHERE user_no = '".$user_no."' LIMIT 1");
    if ($user_check && $user_check->num_rows > 0) {
        $user_control = 1;
    }
}

$pull_settings = $baglan->query("SELECT * FROM settings WHERE id = '1'")->fetch_assoc();
$site_address = $pull_settings['site_address'];
$maintenance_mode = $pull_settings['maintenance_mode'];
$logo = $pull_settings['logo'];
$favicon = $pull_settings['favicon'];
$min_balance = $pull_settings['min_balance'];
$theme_folder = $pull_settings['theme_folder'];
$demo_mode = $pull_settings['demo_mode'];
if($maintenance_mode == "1"){
if(empty($admin_user_no)){echo ' <meta http-equiv="refresh" content="0; url=maintenance/">';exit();}else{$mod_ok = "1";}
}else{ $mod_ok = "0"; }

##-> Only include
if (basename(__FILE__) == basename($_SERVER['SCRIPT_FILENAME'])) {
    echo "<meta http-equiv='refresh' content='0;URL=/'>";exit;
}

$allowed_files = ['panel.php', 'account.php', 'orders.php', 'balance.php', 'support.php', 'api_detail.php'];
if (in_array(basename($_SERVER['SCRIPT_FILENAME']), $allowed_files)) {

##-> User Control & Security Structure Start
$hikey = filter_input(INPUT_COOKIE, 'hikey', FILTER_SANITIZE_STRING);
if (!isset($_COOKIE['hikey']) || empty($hikey)) {
    echo ' <meta http-equiv="refresh" content="0; url=login/">';exit;
}

if (!preg_match('/^[a-zA-Z0-9]+$/', $hikey)) {
    echo ' <meta http-equiv="refresh" content="0; url=login/">';exit;
}

try {
    $user_query = $baglan->prepare("SELECT id, balance, api_key FROM users WHERE user_no = ? LIMIT 1");
    if (!$user_query) {
        throw new Exception("Query preparation failed");
    }
    
    $user_query->bind_param("s", $hikey);
    if (!$user_query->execute()) {
        throw new Exception("Query execution failed");
    }
    
    $user_result = $user_query->get_result();
    if (!$user_result || $user_result->num_rows == 0) {
        echo ' <meta http-equiv="refresh" content="0; url=login/">';exit;
    }
    
    $user = $user_result->fetch_assoc();
    $user_id = (int)$user['id'];
    $user_balance = (float)$user['balance'];
    $user_api_key = $user['api_key'];
    
    $user_query->close();
} catch (Exception $e) {
    echo ' <meta http-equiv="refresh" content="0; url=login/">';exit;
}
}
##-> User Control & Security Structure End

##-> Only account.php start
$allowed_files = ['account.php'];
if (in_array(basename($_SERVER['SCRIPT_FILENAME']), $allowed_files)) {
	
##-> Change account detail start
$user_id = isset($user_id) ? intval($user_id) : 0;
$status = g('status');
$err = '';
$success = '';
$api_err = '';
$api_success = '';

if ($user_id <= 0) {
    echo '<div class="alert alert-danger">Geçersiz kullanıcı.</div>';
    include("footer.php");
    exit;
}

$stmt = $baglan->prepare("SELECT username, email, first_name, surname, phone, password, api_key FROM users WHERE id = ? LIMIT 1");
$stmt->bind_param("i", $user_id);
$stmt->execute();
$result = $stmt->get_result();
if ($result && $result->num_rows > 0) {
    $user = $result->fetch_assoc();
} else {
    echo '<div class="alert alert-danger">Kullanıcı bulunamadı.</div>';
    include("footer.php");
    exit;
}
$stmt->close();

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['change_api_key'])) {
    try {
        $new_api_key = bin2hex(random_bytes(16));
        $stmt = $baglan->prepare("UPDATE users SET api_key = ? WHERE id = ?");
        $stmt->bind_param("si", $new_api_key, $user_id);
        if ($stmt->execute()) {
            $api_success = "Api Key başarıyla değiştirildi.";
            $user['api_key'] = $new_api_key;
        } else {
            $api_err = "Api Key değiştirilemedi. Lütfen tekrar deneyin.";
        }
        $stmt->close();
    } catch (Exception $e) {
        $api_err = "Api Key oluşturulurken bir hata oluştu.";
    }
}

if ($_SERVER['REQUEST_METHOD'] === 'POST' && !isset($_POST['change_api_key'])) {
    $email = trim($_POST['email'] ?? '');
    $first_name = trim($_POST['first_name'] ?? '');
    $surname = trim($_POST['surname'] ?? '');
    $phone = trim($_POST['phone'] ?? '');
    $password = $_POST['password'] ?? '';
    $password2 = $_POST['password2'] ?? '';
    $old_password = $_POST['old_password'] ?? '';

    if ($email == '' || $first_name == '' || $surname == '' || $phone == '') {
        $err = "Lütfen tüm alanları doldurun.";
    } elseif (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
        $err = "Geçerli bir e-posta adresi giriniz.";
    } elseif ($password !== '' && $password !== $password2) {
        $err = "Şifreler eşleşmiyor.";
    } elseif ($password !== '' && $old_password === '') {
        $err = "Şifre değiştirmek için mevcut şifrenizi giriniz.";
    } elseif ($password !== '') {
        if (strlen($password) < 8) {
            $err = "Yeni şifreniz en az 8 karakter olmalıdır.";
        } elseif (!preg_match('/[A-Za-z]/', $password) || !preg_match('/[0-9]/', $password)) {
            $err = "Yeni şifreniz hem harf hem de rakam içermelidir.";
        } elseif (!password_verify($old_password, $user['password'])) {
            $err = "Mevcut şifreniz hatalı.";
        }
    }

    if ($err === '') {
        $stmt = $baglan->prepare("SELECT id FROM users WHERE email = ? AND id != ?");
        $stmt->bind_param("si", $email, $user_id);
        $stmt->execute();
        $stmt->store_result();
        if ($stmt->num_rows > 0) {
            $err = "Bu e-posta adresi başka bir kullanıcı tarafından kullanılıyor.";
        } else {
            if ($password !== '') {
                $password_hash = password_hash($password, PASSWORD_DEFAULT);
                $update = $baglan->prepare("UPDATE users SET email = ?, first_name = ?, surname = ?, phone = ?, password = ? WHERE id = ?");
                $update->bind_param("sssssi", $email, $first_name, $surname, $phone, $password_hash, $user_id);
            } else {
                $update = $baglan->prepare("UPDATE users SET email = ?, first_name = ?, surname = ?, phone = ? WHERE id = ?");
                $update->bind_param("ssssi", $email, $first_name, $surname, $phone, $user_id);
            }
            if ($update->execute()) {
                $success = "Bilgileriniz başarıyla güncellendi.";
                $user['email'] = $email;
                $user['first_name'] = $first_name;
                $user['surname'] = $surname;
                $user['phone'] = $phone;
                if ($password !== '') {
                    $user['password'] = $password_hash;
                }
            } else {
                $err = "Bir hata oluştu, lütfen tekrar deneyin.";
            }
            $update->close();
        }
        $stmt->close();
    }
}	
##-> Change account detail end	
	
}

?>