<?php
header('Content-Type: application/json');

// Adjust path as needed depending on where this file is placed relative to core
require_once("../core/vi_connect.php");
require_once("../core/vi_global.php");

// User authentication check
// We need to replicate the auth logic or include a file that does it.
// core/functions.php does auth but also outputs HTML/redirects.
// We'll reimplement basic auth check using cookies/session as seen in functions.php

$response = ['success' => false, 'message' => ''];

$hikey = filter_input(INPUT_COOKIE, 'hikey', FILTER_SANITIZE_STRING);

if (empty($hikey)) {
    $response['message'] = 'Oturum açmanız gerekiyor.';
    echo json_encode($response);
    exit;
}

// Validate user
$user_id = 0;
$stmt = $baglan->prepare("SELECT id, username, first_name, surname, email, phone FROM users WHERE user_no = ? LIMIT 1");
$stmt->bind_param("s", $hikey);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows > 0) {
    $user = $result->fetch_assoc();
    $user_id = $user['id'];
} else {
    $response['message'] = 'Geçersiz kullanıcı oturumu.';
    echo json_encode($response);
    exit;
}
$stmt->close();

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $code = trim($_POST['gift_code']);

    if (empty($code)) {
        $response['message'] = 'Lütfen hediye kodunu giriniz.';
        echo json_encode($response);
        exit;
    }

    // Check code
    $stmt = $baglan->prepare("SELECT id, amount FROM gift_codes WHERE code = ? AND status = 1 LIMIT 1");
    $stmt->bind_param("s", $code);
    $stmt->execute();
    $res = $stmt->get_result();

    if ($res->num_rows > 0) {
        $gift = $res->fetch_assoc();
        $code_id = $gift['id'];
        $amount = $gift['amount'];

        // Start transaction
        $baglan->begin_transaction();

        try {
            // 1. Mark code as used
            $update_code = $baglan->prepare("UPDATE gift_codes SET status = 0, used_by = ?, used_at = NOW() WHERE id = ? AND status = 1");
            $update_code->bind_param("ii", $user_id, $code_id);
            $update_code->execute();

            if ($update_code->affected_rows === 0) {
                throw new Exception("Hediye kodu kullanılamadı veya zaten kullanılmış.");
            }

            // 2. Add balance to user
            $update_balance = $baglan->prepare("UPDATE users SET balance = balance + ? WHERE id = ?");
            $update_balance->bind_param("di", $amount, $user_id);
            $update_balance->execute();

            // 3. Log payment
            $payment_id = random_int(100000000, 999999999);
            $create_date = date("Y-m-d");
            $create_hour = date("H:i:s");
            $ip = $_SERVER['REMOTE_ADDR'];
            $method = 'Hediye Kodu';
            $status = '1'; // Approved/Success

            $log_payment = $baglan->prepare("INSERT INTO balance_payments (user_id, first_name, surname, email, phone, ip, create_date, create_hour, price, method, status, payment_id) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
            $log_payment->bind_param("issssssssdis", $user_id, $user['first_name'], $user['surname'], $user['email'], $user['phone'], $ip, $create_date, $create_hour, $amount, $method, $status, $payment_id);
            $log_payment->execute();

            $baglan->commit();

            $response['success'] = true;
            $response['message'] = 'Hediye kodu başarıyla kullanıldı! Hesabınıza ' . $amount . ' TL yüklendi.';

        } catch (Exception $e) {
            $baglan->rollback();
            $response['message'] = 'İşlem sırasında bir hata oluştu: ' . $e->getMessage();
        }

    } else {
        $response['message'] = 'Geçersiz veya kullanılmış hediye kodu.';
    }
} else {
    $response['message'] = 'Geçersiz istek yöntemi.';
}

echo json_encode($response);
?>