<?php
header('Content-Type: application/json; charset=utf-8');
##-> Db connect
require_once("../core/vi_connect.php");
require_once("../core/vi_global.php");
$api_key = p("api_key");
$product_id = p("product_id");
$order_id = p("order_id");
$endpoint = g("endpoint");
$api_key = isset($api_key) ? trim($api_key) : '';
##-> Api_key control
if (empty($api_key)) {
    echo json_encode([
        'message' => 'API key not found'
    ]);
    exit;
}

##-> Endpoint control
if (empty($endpoint) || !in_array($endpoint, ['products', 'balance', 'neworder', 'order'])) {
    echo json_encode([
        'message' => 'Endpoint is not valid'
    ]);
    exit;
}

##-> Product list api
if($endpoint == "products"){

$stmt = $baglan->prepare("SELECT id FROM users WHERE api_key = ?");
$stmt->bind_param("s", $api_key);
$stmt->execute();
$result = $stmt->get_result();

if ($user = $result->fetch_assoc()) {

    $products = [];
    $query = $baglan->query("SELECT p.id, p.title, p.content, p.image, c.title as category, p.price 
                            FROM products p 
                            LEFT JOIN category c ON p.category = c.id");
    while ($row = $query->fetch_assoc()) {
        // İndirimli fiyatı hesapla
        $user_id_for_discount = intval($user['id']);
        $original_price = floatval($row['price']);
        $discounted_price = calculateDiscountPrice($baglan, $user_id_for_discount, $row['id'], $original_price);
        $row['price'] = $discounted_price;
        $products[] = $row;
    }
    echo json_encode($products);
} else {
    echo json_encode([
        'message' => 'API key is not valid'
    ]);
}
exit;
}

##-> Balance list api
if($endpoint == "balance"){

    $stmt = $baglan->prepare("SELECT id, balance FROM users WHERE api_key = ?");
    $stmt->bind_param("s", $api_key);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($user = $result->fetch_assoc()) {
        echo json_encode([
            'balance' => $user['balance']
        ]);
    } else {
        echo json_encode([
            'message' => 'API key is not valid'
        ]);
    }
    exit;
}

if($endpoint == "neworder"){
    // First verify the API key and get user info
    $stmt = $baglan->prepare("SELECT id, balance FROM users WHERE api_key = ?");
    $stmt->bind_param("s", $api_key);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($user = $result->fetch_assoc()) {
        // Get product details
        $stmt = $baglan->prepare("SELECT id, category, price FROM products WHERE id = ?");
        $stmt->bind_param("i", $product_id);
        $stmt->execute();
        $product_result = $stmt->get_result();
        
        if ($product = $product_result->fetch_assoc()) {
            // İndirimli fiyatı hesapla
            $user_id_for_discount = intval($user['id']);
            $original_price = floatval($product['price']);
            $discounted_price = calculateDiscountPrice($baglan, $user_id_for_discount, $product_id, $original_price);
            
            // Check if user has enough balance
            if ($user['balance'] >= $discounted_price) {
				
				##-> Product stock check
                $order_data = '';
                $stock_id_to_delete = null;
                $status = 0; // varsayılan olarak stok yok
                $stock_stmt = $baglan->prepare("SELECT id, data FROM stock WHERE product_id = ? LIMIT 1");
                $stock_stmt->bind_param("i", $product_id);
                $stock_stmt->execute();
                $stock_result = $stock_stmt->get_result();
                if ($stock_result && $stock_result->num_rows > 0) {
                    $stock_row = $stock_result->fetch_assoc();
                    $order_data = $stock_row['data'];
                    $stock_id_to_delete = $stock_row['id'];
                    $status = 1; 
                }
                $stock_stmt->close();
				
				##-> Api provider check
                $api_provider_id = null;
                if ($status === 0) {
                    $api_provider_stmt = $baglan->prepare("SELECT api_provider_id, api_product_id FROM products WHERE id = ?");
                    $api_provider_stmt->bind_param("i", $product_id);
                    $api_provider_stmt->execute();
                    $api_provider_result = $api_provider_stmt->get_result();
                    if ($api_provider_row = $api_provider_result->fetch_assoc()) {
                        if (!empty($api_provider_row['api_provider_id'])) {
                            $api_provider_id = $api_provider_row['api_provider_id'];
                            $api_product_id = $api_provider_row['api_product_id'];
                        }
                    }
                    $api_provider_stmt->close();
                }
                
				##-> Automatic ordering with API
                if (!empty($api_provider_id)) {
                    $api_info_stmt = $baglan->prepare("SELECT url, api_key FROM api WHERE id = ? LIMIT 1");
                    $api_info_stmt->bind_param("i", $api_provider_id);
                    $api_info_stmt->execute();
                    $api_info_result = $api_info_stmt->get_result();
                    if ($api_info_row = $api_info_result->fetch_assoc()) {
                        $api_url = $api_info_row['url'];
                        $api_provider_key = $api_info_row['api_key'];
                    }
                    $api_info_stmt->close();
                    $remote_api_url = "$api_url/?endpoint=neworder";
                    $post_fields = [
                        'api_key'    => $api_provider_key,
                        'product_id' => $api_product_id
                    ];

                    $ch = curl_init();
                    curl_setopt($ch, CURLOPT_URL, $remote_api_url);
                    curl_setopt($ch, CURLOPT_POST, true);
                    curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($post_fields));
                    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                    curl_setopt($ch, CURLOPT_TIMEOUT, 15);
             

                    $remote_response = curl_exec($ch);
                    $curl_error = curl_error($ch);
                    curl_close($ch);
                   
                    header('Content-Type: application/json; charset=utf-8');
                    if ($remote_response !== false) {
                        $api_response = json_decode($remote_response, true);
                        $api_order_id = isset($api_response['order_id']) ? $api_response['order_id'] : null;
                        $order_data = isset($api_response['order_data']) ? $api_response['order_data'] : null;
                    } else {
                        echo json_encode([
                            'message' => 'Failed to connect to API provider: ' . $curl_error
                        ]);
                    } 
                }

                // Update user balance first (indirimli fiyat ile)
                $new_balance = $user['balance'] - $discounted_price;
                $update_stmt = $baglan->prepare("UPDATE users SET balance = ? WHERE id = ?");
                $update_stmt->bind_param("di", $new_balance, $user['id']);
          
                if ($update_stmt->execute()) {
                    // Create order after balance update
                    $current_date = date('Y-m-d');
                    $current_time = date('H:i:s');

					##-> Null data check
                    if (!isset($order_data)) $order_data = '';
                    if (!isset($status)) $status = 0;
                    if (!isset($api_provider_id)) $api_provider_id = null;
                    if (!isset($api_order_id)) $api_order_id = null;
                    if(empty($order_data)){$status = 0;}else{$status = 1;}
                    $stmt = $baglan->prepare("INSERT INTO orders (product, category, order_owner, create_date, create_time, price, data, status, api_provider_id, api_order_id) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
                    $stmt->bind_param(
                        "iisssdsiii",
                        $product_id,
                        $product['category'],
                        $user['id'],
                        $current_date,
                        $current_time,
                        $discounted_price,
                        $order_data,
                        $status,
                        $api_provider_id,
                        $api_order_id
                    );

                    if ($stmt->execute()) {
                        $order_id = $baglan->insert_id;

                        // Eğer stoktan veri kullandıysak, ilgili stock kaydını sil
                        if ($stock_id_to_delete !== null) {
                            $delete_stock_stmt = $baglan->prepare("DELETE FROM stock WHERE id = ? LIMIT 1");
                            $delete_stock_stmt->bind_param("i", $stock_id_to_delete);
                            $delete_stock_stmt->execute();
                            $delete_stock_stmt->close();
                        }

                        echo json_encode([
                            'order_id' => $order_id,
                            'order_data' => $order_data
                        ]);
                    } else {
                        //Balance reverting
                        $revert_stmt = $baglan->prepare("UPDATE users SET balance = ? WHERE id = ?");
                        $revert_stmt->bind_param("di", $user['balance'], $user['id']);
                        $revert_stmt->execute();

                  
                        echo json_encode([
                            'message' => 'Failed to create order'
                        ]);
                    }
                    $stmt->close();
                } else {
                    echo json_encode([
                        'message' => 'Failed to update balance'
                    ]);
                }
            } else {
                echo json_encode([
                    'message' => 'Insufficient balance'
                ]);
            }
        } else {
            echo json_encode([
                'message' => 'Product not found'
            ]);
        }
    } else {
        echo json_encode([
            'message' => 'API key is not valid'
        ]);
    }
    exit;
}


##-> Order detail
if($endpoint == "order"){
    $stmt = $baglan->prepare("SELECT id FROM users WHERE api_key = ?");
    $stmt->bind_param("s", $api_key);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($user = $result->fetch_assoc()) {
        $user_id = $user['id'];
        if (is_numeric($order_id)) {
            $stmt = $baglan->prepare("SELECT product, category, data, create_date, create_time, price, status FROM orders WHERE id = ? AND order_owner = ? LIMIT 1");
            $stmt->bind_param("ii", $order_id, $user_id);
            $stmt->execute();
            $order_result = $stmt->get_result();
            if ($order = $order_result->fetch_assoc()) {
                echo json_encode($order);
            } else {
                echo json_encode([
                    'message' => 'Order not found'
                ]);
            }
            $stmt->close();
        } else {
            echo json_encode([
                'message' => 'Order ID is not valid'
            ]);
        }
    } else {
        echo json_encode([
            'message' => 'API key is not valid'
        ]);
    }
    exit;
}
?>