<?php include("header.php");?>

<?php
if(isset($_GET['activate']) && !empty($_GET['activate'])) {
    $theme_folder = preg_replace('/[^a-zA-Z0-9]/', '', $_GET['activate']);
    
    $theme_file = "../themes/" . $theme_folder . "/theme.php";
    if(file_exists($theme_file)) {
        include($theme_file); // theme.php'yi dahil et ki $theme_folder değişkenine erişebilelim
		include("core/routing_control.php");
        $stmt = $baglan->prepare("UPDATE settings SET theme = ?, theme_folder = ? WHERE id = '1'");
        if($stmt) {
            $stmt->bind_param("ss", $theme_folder, $theme_folder);
            if($stmt->execute()) {
                echo '<div class="alert alert-success">Tema başarıyla aktifleştirildi!</div>';
            } else {
                echo '<div class="alert alert-danger">Tema aktifleştirilirken bir hata oluştu!</div>';
            }
            $stmt->close();
        } else {
            echo '<div class="alert alert-danger">Veritabanı işlemi başlatılamadı!</div>';
        }
    } else {
        echo '<div class="alert alert-danger">Geçersiz tema dosyası!</div>';
    }
}
?>

<div class="page-header page-header-light border rounded mb-3">
    <div class="page-header-content">
        <div class="page-title d-flex align-items-baseline flex-wrap">
            <h5 class="mb-0">Tema Yönetimi</h5>
        </div>
    </div>
</div>

<div class="row">
    <?php
    // Aktif temayı al
    $active_theme = $baglan->query("SELECT theme_folder FROM settings WHERE id = '1'")->fetch_assoc()['theme_folder'];
    
    // themes klasöründeki tüm tema klasörlerini tara
    $themes_dir = "../themes/";
    $themes = array_diff(scandir($themes_dir), array('.', '..'));
    
    foreach($themes as $theme_folder) {
        if(is_dir($themes_dir . $theme_folder)) {
            $theme_file = $themes_dir . $theme_folder . "/theme.php";
            
            if(file_exists($theme_file)) {
                include($theme_file);
                
                // Tema aktif mi kontrol et
                $is_active = ($theme_folder == $active_theme) ? true : false;
                ?>
                
                <div class="col-lg-4 mb-4">
                    <div class="card">
                        <div class="card-header d-flex justify-content-between">
                            <span class="fw-semibold"><?php echo $theme_name; ?></span>
                            <?php if($is_active): ?>
                                <span class="text-success fw-semibold">Aktif</span>
                            <?php endif; ?>
                        </div>
                        <div class="card-body">
                            <img src="../themes/<?php echo "$theme_folder/$theme_image";?>" class="img-fluid" alt="<?php echo $theme_name; ?>">
                        </div>
                        <div class="card-footer d-flex justify-content-between">
                            <div>
                                <small>Geliştirici: <?php echo $theme_creator; ?></small>
                            </div>
                            <ul class="list-inline mb-0">
                                <?php if(!$is_active): ?>
								
								<?php if($username == "demo"){?>
				<li class="list-inline-item">
                                        <a data-bs-toggle="modal" data-bs-target="#demo_modal_default" class="btn btn-primary btn-sm">
                                            Aktifleştir
                                        </a>
                                    </li>
				<?php }else{ ?>
				<li class="list-inline-item">
                                        <a href="?activate=<?php echo $theme_folder; ?>" class="btn btn-primary btn-sm">
                                            Aktifleştir
                                        </a>
                                    </li>
				<?php } ?>
				
                                    
                                <?php endif; ?>
                            </ul>
                        </div>
                    </div>
                </div>
                
                <?php
            }
        }
    }
    ?>
</div>

<?php include("footer.php");?>