<?php include("header.php");

$level = g("level");
$status = g("status");
$operation = g("operation");
$dataid = g("dataid");

// Destek talebini kapatma işlemi
if ($level == "close" && !empty($dataid)) {
    $ticket_id = intval($dataid);
    $update = $baglan->prepare("UPDATE support_tickets SET status = 'closed', updated_at = NOW() WHERE id = ?");
    $update->bind_param("i", $ticket_id);
    $update->execute();
    echo '<meta http-equiv="refresh" content="0;URL=support.php?level=edit&dataid='.$ticket_id.'&status=closed">';
    exit();
}

// Destek talebini tekrar açma işlemi
if ($level == "open" && !empty($dataid)) {
    $ticket_id = intval($dataid);
    $update = $baglan->prepare("UPDATE support_tickets SET status = 'open', updated_at = NOW() WHERE id = ?");
    $update->bind_param("i", $ticket_id);
    $update->execute();
    echo '<meta http-equiv="refresh" content="0;URL=support.php?level=edit&dataid='.$ticket_id.'&status=open">';
    exit();
}

// Destek yanıtı ekleme işlemi
if ($level == "edit" && $operation == "reply" && !empty($dataid) && $_SERVER['REQUEST_METHOD'] == 'POST') {
    $ticket_id = intval($dataid);
    $response = trim(p("response"));
    $admin_id = $admin_user_data_pull['id']; // Giriş yapan admin id'si
    // Ticket'ın user_id'sini çek
    $ticket_query = $baglan->query("SELECT user_id FROM support_tickets WHERE id = '$ticket_id'");
    $ticket_row = $ticket_query->fetch_assoc();
    $ticket_user_id = $ticket_row ? $ticket_row['user_id'] : 0;
    // Admin yanıtı için user_id'yi negatif olarak kaydet (veya 0 olarak kaydet)
    $admin_response_user_id = 0; // 0 veya -1 gibi bir değer, üye ile çakışmaz
    if ($response != "") {
        $stmt = $baglan->prepare("INSERT INTO support_responses (ticket_id, response, created_at, user_id) VALUES (?, ?, NOW(), ?)");
        $stmt->bind_param("isi", $ticket_id, $response, $admin_response_user_id);
        $stmt->execute();
        // Talep güncelleme
        $baglan->query("UPDATE support_tickets SET updated_at = NOW() WHERE id = '$ticket_id'");
        echo '<meta http-equiv="refresh" content="0;URL=support.php?level=edit&dataid='.$ticket_id.'">';
        exit();
    }
}
?>
<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.2.1/jquery.min.js"></script>
<?php 
// Talep silme işlemi
if ($level == "delete" && !empty($dataid)) {
    $ticket_id = intval($dataid);
    // Önce yanıtları sil
    $baglan->query("DELETE FROM support_responses WHERE ticket_id = '$ticket_id'");
    // Sonra talebi sil
    $baglan->query("DELETE FROM support_tickets WHERE id = '$ticket_id'");
    echo '<meta http-equiv="refresh" content="0;URL=support.php?status=deleted">';
    exit();
}
?>

<?php if(empty($level)){?>
<div class="page-header page-header-light border rounded mb-3">
    <div class="page-header-content d-flex">
        <div class="page-title">
            <h5 class="mb-0">Destek Talepleri</h5>
        </div>
    </div>
</div>

<?php if($status == "error"){?>
<div class="col-md-12">
    <div class="alert alert-danger alert-dismissible fade show">
        <span class="fw-semibold">Hata:</span> Bir hata oluştu.
    </div>
</div>
<?php } ?>


<?php if($status == "deleted"){?>
<div class="col-md-12">
    <div class="alert alert-success alert-dismissible fade show">
        <span class="fw-semibold">Başarılı:</span> Talep başarıyla silindi.
    </div>
</div>
<?php } ?>

<!-- Silme Modalı -->
<div class="modal fade" id="deleteTicketModal" tabindex="-1" aria-labelledby="deleteTicketModalLabel" aria-hidden="true">
  <div class="modal-dialog">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="deleteTicketModalLabel">Talebi Sil</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Kapat"></button>
      </div>
      <div class="modal-body">
        Bu talebi silmek istediğinize emin misiniz? Bu işlem geri alınamaz!
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Vazgeç</button>
        <a href="#" id="confirmDeleteBtn" class="btn btn-danger">Sil</a>
      </div>
    </div>
  </div>
</div>

<div class="card">
    <div class="table-responsive">
        <table class="table table-bordered align-middle">
            <thead>
                <tr>
                    <th>#</th>
                    <th>Kullanıcı</th>
                    <th>Konu</th>
                    <th>Sipariş No</th>
                    <th>Durum</th>
                    <th>Oluşturulma</th>
                    <th>Güncelleme</th>
                    <th>İşlemler</th>
                </tr>
            </thead>
            <tbody>
            <?php
            $sno = 0;
            $tickets = $baglan->query("SELECT t.*, u.username FROM support_tickets t LEFT JOIN users u ON t.user_id = u.id ORDER BY t.id DESC");
            while ($ticket = $tickets->fetch_assoc()) {
                $sno++;
                $ticket_id = $ticket['id'];
                $username = htmlspecialchars($ticket['username']);
                $subject = htmlspecialchars($ticket['subject']);
                $product = htmlspecialchars($ticket['product']);
                $status_val = $ticket['status'] == "closed" ? '<span class="badge bg-danger">Kapalı</span>' : '<span class="badge bg-success">Açık</span>';
                $created_at = htmlspecialchars($ticket['created_at']);
                $updated_at = htmlspecialchars($ticket['updated_at']);
                echo '
                <tr>
                    <td>'.$sno.'</td>
                    <td>'.$username.'</td>
                    <td>'.$subject.'</td>
                    <td>'; if(empty($product)){echo "-";}else{echo "#$product";} echo '</td>
                    <td>'.$status_val.'</td>
                    <td>'.$created_at.'</td>
                    <td>'.$updated_at.'</td>
                    <td>
                        <a class="btn btn-primary btn-sm" href="support.php?level=edit&dataid='.$ticket_id.'"><i class="fas fa-eye mfit"></i> Görüntüle</a>
					';
                       
						
				if($admin_user_data_pull['username'] == "demo"){
                    echo '<a class="btn btn-danger btn-sm" data-bs-toggle="modal" data-bs-target="#demo_modal_default"><i class="fas fa-times-circle mfit"></i> Sil</a>';
                } else {
                    echo ' <button class="btn btn-danger btn-sm delete-ticket-btn" data-ticket-id="'.$ticket_id.'" type="button"><i class="fas fa-trash mfit"></i> Sil</button>';
                }
				
                    echo '
					</td>
                </tr>
                ';
            }
            ?>
            </tbody>
        </table>
    </div>
</div>

<script>
$(document).ready(function(){
    var deleteUrl = "";
    $('.delete-ticket-btn').on('click', function(){
        var ticketId = $(this).data('ticket-id');
        deleteUrl = "support.php?level=delete&dataid=" + ticketId;
        $('#confirmDeleteBtn').attr('href', deleteUrl);
        $('#deleteTicketModal').modal('show');
    });
});
</script>
<?php } ?>

<?php
if($level == "edit" && !empty($dataid)){
    $ticket_id = intval($dataid);
    $ticket = $baglan->query("SELECT t.*, u.phone, u.balance, u.username FROM support_tickets t LEFT JOIN users u ON t.user_id = u.id WHERE t.id = '$ticket_id'")->fetch_assoc();
    if(!$ticket){
        echo '<div class="alert alert-danger">Destek talebi bulunamadı.</div>';
    } else {
        $username = htmlspecialchars($ticket['username']);
        $user_id = htmlspecialchars($ticket['user_id']);
        $phone = htmlspecialchars($ticket['phone']);
        $balance = htmlspecialchars($ticket['balance']);
        $subject = htmlspecialchars($ticket['subject']);
        $description = nl2br(htmlspecialchars($ticket['description']));
        $product = htmlspecialchars($ticket['product']);
        $status_val = $ticket['status'];
        $created_at = htmlspecialchars($ticket['created_at']);
        $updated_at = htmlspecialchars($ticket['updated_at']);
?>
<div class="page-header page-header-light border rounded mb-3">
    <div class="page-header-content d-flex">
        <div class="page-title">
            <h5 class="mb-0">Destek Talebi: <font color='red'>#<?php echo $ticket_id; ?></font> <font style='font-weight:400;'></font></h5>
        </div>
        <div class="my-auto ms-auto">
            <a href="support.php" class="btn btn-warning"><i class="ph-arrow-bend-up-left "></i> Geri Dön</a>
        </div>
    </div>
</div>


<?php if($status == "closed"){?>
<div class="col-md-12">
    <div class="alert alert-warning alert-dismissible fade show">
        <span class="fw-semibold">Başarılı:</span> Talep başarıyla kapatıldı.
    </div>
</div>
<?php } ?>

<?php if($status == "open"){?>
<div class="col-md-12">
    <div class="alert alert-success alert-dismissible fade show">
        <span class="fw-semibold">Başarılı:</span> Talep başarıyla açıldı.
    </div>
</div>
<?php } ?>

<div class="row">
<div class="col-md-4">

<div class="card">
<div class="card-header d-flex align-items-center py-0">
									<h6 class="py-3 mb-0">Sohbet Detayları</h6>
									<div class="ms-auto my-auto">
										<?php if($status_val == "closed"){ ?>
				<?php if($admin_user_data_pull['username'] == "demo"){?>
				<a class="btn btn-success" data-bs-toggle="modal" data-bs-target="#demo_modal_default">
				<i class="fas fa-unlock mfit"></i> Talebi Aç
				</a>
				<?php }else{ ?>
				<a href="support.php?level=open&dataid=<?php echo $ticket_id;?>" class="btn btn-success" onclick="return confirm('Talebi tekrar açmak istediğinize emin misiniz?')">
				<i class="fas fa-unlock mfit"></i> Talebi Aç
				</a>
				<?php } ?>
				
											
										<?php } else { ?>
										
										<?php if($admin_user_data_pull['username'] == "demo"){?>
				<a class="btn btn-danger" data-bs-toggle="modal" data-bs-target="#demo_modal_default">
				<i class="fas fa-lock mfit"></i> Talebi Kapat
				</a>
				<?php }else{ ?>
				<a href="support.php?level=close&dataid=<?php echo $ticket_id;?>" class="btn btn-danger" onclick="return confirm('Talebi kapatmak istediğinize emin misiniz?')">
				<i class="fas fa-lock mfit"></i> Talebi Kapat
				</a>
											
				<?php } ?>
				
											
											
										<?php } ?>
									</div>
								</div>
<div class="card-body">
<div class="d-flex">
									<div class="flex-fill">
										<div class="fw-semibold"><?php echo $username; ?></div>
										<span class="text-muted">Bakiye: <?php echo $balance; ?> TL</span>
									</div>

									<a href="users.php?level=edit&dataid=<?php echo $user_id;?>" class="ms-3">
										<img src="images/user_dark.png" class="rounded-circle" width="44" height="44" alt="">
									</a>
								</div>
</div>

<ul class="list-group list-group-flush border-top">
<li class="list-group-item d-flex">
<span class="fw-semibold">Oluşturma Zamanı:</span>
<div class="ms-auto"> <?php echo date('d.m.Y - H:i', strtotime($created_at)); ?></div>
</li>
<li class="list-group-item d-flex">
<span class="fw-semibold">Talep Durumu</span>
<div class="ms-auto"><?php echo $status_val == "closed" ? '<span class="badge bg-danger">Kapalı</span>' : '<span class="badge bg-success">Açık</span>'; ?></div>
</li>
<li class="list-group-item d-flex">
<span class="fw-semibold">İlgili Sipariş</span>
<div class="ms-auto"><?php 
            if(empty($product)){
                echo "-";
            } else {
                // Sipariş ID'sini al
                $order_id = intval($product);
                echo '<a href="orders.php?level=edit&dataid='.$order_id.'" class="badge bg-primary text-white" style="text-decoration:none;">#'.$order_id.' <i class="fas fa-arrow-right ms-1"></i></a>';
            }
        ?></div>
</li>
<li class="list-group-item d-flex">
<span class="fw-semibold">Telefon Numarası:</span>
<div class="ms-auto"><?php echo $phone; ?></div>
</li>
<li class="list-group-item d-flex">
<span class="fw-semibold">Talebin Son Güncellemesi:</span>
<div class="ms-auto"><?php echo date('d.m.Y - H:i', strtotime($updated_at)); ?></div>
</li>
</ul>

</div>

</div>
<div class="col-md-8">
<div class="card">
    <div class="card-header">
        <h5 class="mb-0"><i class="fas fa-comments me-2"></i>Sohbet</h5>
    </div>
    <div class="card-body">
        <div class="media-chat-scrollable mb-3" style="max-height:400px;overflow-y:auto;">
            <div class="media-chat vstack gap-3">
                <?php
                // İlk mesajı göster (talep açıklaması)
                ?>
                <div class="media-chat-item">
                    <div class="media-chat-message">
                        <div class="fs-sm lh-sm">
                            <span class="fw-semibold"><?php echo $username; ?></span>
                            <span class="opacity-50 ms-2"><?php echo date('d.m.Y H:i', strtotime($created_at)); ?></span>
                        </div>
                        <?php echo $description; ?>
                    </div>
                </div>
                <?php
                // Yanıtları çek
                $responses = $baglan->query("SELECT r.*, u.username FROM support_responses r LEFT JOIN users u ON r.user_id = u.id WHERE r.ticket_id = '$ticket_id' ORDER BY r.created_at ASC");
                while($response = $responses->fetch_assoc()){
                    // Admin yanıtı ise user_id 0 veya -1 olarak kaydedildi, üye yanıtı ise user_id ticket'ın user_id'si ile aynı
                    $is_admin = ($response['user_id'] == 0 || $response['user_id'] == -1);
                    $msg_username = $is_admin ? "Destek Ekibi" : htmlspecialchars($response['username']);
                    $msg_text = nl2br(htmlspecialchars($response['response']));
                    $msg_time = htmlspecialchars(date('d.m.Y H:i', strtotime($response['created_at'])));
                    $item_class = $is_admin ? "media-chat-item media-chat-item-reverse" : "media-chat-item";
                    ?>
                    <div class="<?php echo $item_class; ?>">
                        <div class="media-chat-message">
                            <div class="fs-sm lh-sm">
                                <span class="fw-semibold"><?php echo $msg_username; ?></span>
                                <span class="opacity-50 ms-2"><?php echo $msg_time; ?></span>
                            </div>
                            <?php echo $msg_text; ?>
                        </div>
                    </div>
                    <?php
                }
                ?>
            </div>
        </div>
        <?php if($status_val != "closed"){ ?>
            <form action="support.php?level=edit&operation=reply&dataid=<?php echo $ticket_id;?>" method="post" autocomplete="off">
                <div class="input-group mb-3">
                    <textarea name="response" class="form-control" placeholder="Yanıtınızı yazın..." required style="resize:none;"></textarea>
					
                <?php if($admin_user_data_pull['username'] == "demo"){?>
				<a class="btn btn-primary ms-2" data-bs-toggle="modal" data-bs-target="#demo_modal_default"> Gönder <i class="ph-paper-plane-tilt ms-2"></i> </a>		
				<?php }else{ ?>
				<button type="submit" class="btn btn-primary ms-2"> Gönder <i class="ph-paper-plane-tilt ms-2"></i> </button>					
				<?php } ?>
				
                    
                </div>
            </form>
        <?php } else { ?>
            <div class="text-center text-muted">
                Bu talep kapatılmıştır. Yanıt eklenemez.
            </div>
        <?php } ?>
    </div>
</div></div>
</div>

<?php
    }
}
?>

<?php include("footer.php");?>