<?php include("header.php");

$level = g("level");
$status = g("status");
$operation = g("operation");
$dataid = g("dataid");
$category = g("category");


if($level == "delete"){
$delete_id=$dataid;
$deleted=$baglan->prepare('DELETE FROM products where id=?');
$deleted->bind_param("i",$delete_id);
$deleted->execute();
if($deleted){echo '<meta http-equiv="refresh" content="0;URL=products.php?status=successful&category='.$category.'">';}
}

$pull_data = $baglan->query("SELECT * FROM category WHERE id = '$category'")->fetch_assoc();
$category_title = $pull_data["title"];

?>
<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.2.1/jquery.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jqueryui/1.12.1/jquery-ui.min.js"></script>
<link href="https://cdn.quilljs.com/1.3.6/quill.snow.css" rel="stylesheet">
<script src="https://cdn.quilljs.com/1.3.6/quill.min.js"></script>

<?php if(empty($level)){?>
<div class="page-header page-header-light border rounded mb-3">
<div class="page-header-content d-flex">
<div class="page-title">
<h5 class="mb-0"><?php echo $category_title;?>: Ürün Yönetimi</h5>
</div>

<div class="my-auto ms-auto">
<a href="products.php?level=new&category=<?php echo $category;?>" class="btn btn-primary"><i class="ph-plus-circle"></i> Yeni Ekle</a>
<a href="products.php?level=bulk_add&category=<?php echo $category;?>" class="btn btn-success"><i class="ph-plus"></i> Toplu Ürün Ekle</a>
<a href="category.php" class="btn btn-warning"><i class="ph-arrow-bend-up-left"></i> Geri Dön</a>
</div>
</div>
</div>

<?php if($status == "error"){?>
<div class="col-md-12">
<div class="alert alert-danger alert-dismissible fade show">
<span class="fw-semibold">Hata:</span> Bir hata oluştu.</a>
</div>
</div>
<?php } ?>

<?php if($status == "successful"){?>
<div class="col-md-12">
<div class="alert alert-success alert-dismissible fade show">
<span class="fw-semibold">Başarılı:</span> İşlem başarıyla gerçekleştirildi.</a>
</div>
</div>
<?php } ?>

<div class="card">
<div class="table-responsive">
<table class="table table-bordered">
<thead>
<tr>
<th>Sıra</th>
<th>Başlık</th>
<th>Fiyat</th>
<th>Stok</th>
<th>Api Durumu</th>
<th>İşlemler</th>
</tr>
</thead>
<tbody class="row_position">
<?php
$sno = 0;
$servis_sql = $baglan->query("SELECT * FROM products WHERE category = '$category' ORDER BY row ASC");
while ($sonuc = $servis_sql->fetch_assoc()) {
    $dataid = $sonuc['id'];
    $title = $sonuc['title'];
    $price = $sonuc['price'];
    $api_provider_id = isset($sonuc['api_provider_id']) ? $sonuc['api_provider_id'] : '';
    $sno++;

    // Stok adedi: stock tablosunda product_id = $dataid olan satırların sayısı
    $stok_sorgu = $baglan->query("SELECT COUNT(*) as stok_adet FROM stock WHERE product_id = '$dataid'");
    $stok_sonuc = $stok_sorgu->fetch_assoc();
    $stok_adet = isset($stok_sonuc['stok_adet']) ? $stok_sonuc['stok_adet'] : 0;

    // Api durumu kutusu
    if (!empty($api_provider_id)) {
        $api_durumu = '<span class="badge bg-success" style="font-size:13px;"><i class="fas fa-link"></i> Api Servisi</span>';
    } else {
        $api_durumu = '<span class="badge bg-primary" style="font-size:13px;"><i class="fas fa-user"></i> Ana Sağlayıcısınız</span>';
    }

    echo '
    <tr id="'.$dataid.'">
    <td>'.$sno.' <i class="far fa-arrows-alt"></i></td>
    <td>'.$title.'</td>
    <td>'.$price.' TL</td>
    <td>'.$stok_adet.'</td>
    <td>'.$api_durumu.'</td>
    <td>
    <a class="btn btn-primary btn-sm" href="products.php?level=edit&dataid='.$dataid.'&category='.$category.'"><i class="fas fa-edit mfit"></i> Düzenle</a>
    <a class="btn btn-warning btn-sm" href="stock.php?product_id='.$dataid.'"><i class="fas fa-layer-group mfit"></i> Stoklar</a> 
    ';
    if($username == "demo"){
        echo '<a class="btn btn-danger btn-sm" data-bs-toggle="modal" data-bs-target="#demo_modal_default"><i class="fas fa-times-circle mfit"></i> Sil</a>';
    }else{
        echo '<a class="btn btn-danger btn-sm" data-bs-toggle="modal" data-bs-target="#sil-modal'.$dataid.'"><i class="fas fa-times-circle mfit"></i> Sil</a>';
    }
    echo'
    </td>
    </tr>
    <div id="sil-modal'.$dataid.'" class="modal fade" tabindex="-1">
    <div class="modal-dialog">
    <div class="modal-content">
    <div class="modal-header">
    <h5 class="modal-title">Ürün Sil</h5>
    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
    </div>

    <div class="modal-body">
    <p>Bu ürünü silmek istediğinize gerçekten eminmisiniz ?</p>
    </div>

    <div class="modal-footer">
    <button type="button" class="btn btn-link" data-bs-dismiss="modal">Kapat</button>
    <a href="products.php?level=delete&dataid='.$dataid.'&category='.$category.'" class="btn btn-danger">Evet, Sil</a>
    </div>
    </div>
    </div>
    </div>
    ';
}
?>

</tbody>
</table>
<script type="text/javascript">
$( ".row_position" ).sortable({
delay: 150,
stop: function() {
var selectedData = new Array();
$('.row_position>tr').each(function() {
selectedData.push($(this).attr("id"));
});
updateOrder(selectedData);
}
});


<?php if($username == "demo"){?>
function updateOrder(data) {
swal(
'Demo Hesap',
'Sistemi demo olarak incelediğiniz için değişiklikler kayıt edilmeyecek.',
'warning'
)
}
<?php } else { ?>
function updateOrder(data) {
$.ajax({
url:"core/rows/products.php?rows=change",
type:'post',
data:{position:data},
success:function(){
}
})
}
<?php } ?>
	
</script>
</div>
</div>
<?php } ?>

<?php if($level == "new"){?>

<?php
if($operation == "save"){
$title = p("title");
$price = p("price");
$content1 = $_POST["content"];
$content = addslashes($content1);

$img_data = file_get_contents($_FILES["image"]['tmp_name']);

if ($img_data !== false) {
    // MIME türünü tespit et
    $finfo = new finfo(FILEINFO_MIME_TYPE);
    $mime_type = $finfo->buffer($img_data);

    // Geçerli MIME türleri ve uzantı eşleşmeleri
    $mime_to_ext = [
        'image/jpeg' => 'jpg',
        'image/png'  => 'png',
        'image/gif'  => 'gif',
        'image/webp' => 'webp',
    ];

    // Maksimum boyut (64 KB)
    $max_size = 64 * 1024;

    // Kontroller
    if (isset($mime_to_ext[$mime_type]) && strlen($img_data) <= $max_size) {
        // Gerçekten bir resim mi?
        $image = imagecreatefromstring($img_data);
        if ($image !== false) {
            $ext = $mime_to_ext[$mime_type];
            $rand_name = bin2hex(random_bytes(4)) . '.' . $ext;
            $save_path = __DIR__ . "/../images/" . $rand_name;

            // MIME türüne göre doğru kaydetme işlemi
            switch ($ext) {
                case 'jpg':
                    imagejpeg($image, $save_path, 90); break;
                case 'png':
                    imagepng($image, $save_path); break;
                case 'gif':
                    imagegif($image, $save_path); break;
                case 'webp':
                    imagewebp($image, $save_path); break;
            }

            imagedestroy($image);

            if (file_exists($save_path)) {
                $image = "images/" . $rand_name;
            }
        }
    }
}

// Son kaydın row değerini alıp +1 ekleyerek yeni kayda ekle
$row_result = $baglan->query("SELECT MAX(row) as max_row FROM products");
$row_data = $row_result->fetch_assoc();
$new_row = isset($row_data['max_row']) ? $row_data['max_row'] + 1 : 1;

$data_add = $baglan->query("INSERT INTO products (
title,
category,
price,
image,
content,
row
) VALUES (
'$title',
'$category',
'$price',
'$image',
'$content',
'$new_row'
)");
if($data_add){
    $last_id = $baglan->insert_id;
    echo "<meta http-equiv='refresh' content='0;URL=products.php?category=$category&status=success'>";
    exit;
}else{
    echo "<meta http-equiv='refresh' content='0;URL=products.php?category=$category&status=error'>";
    exit;
}
}
?>

<div class="page-header page-header-light border rounded mb-3">
<div class="page-header-content d-flex">
<div class="page-title">
<h5 class="mb-0">Yeni Ürün Ekle</h5>
</div>

<div class="my-auto ms-auto">
<a href="products.php?category=<?php echo $category;?>" class="btn btn-danger"><i class="ph-caret-left"></i> Geri Dön</a>
</div>
</div>
</div>

<form action="products.php?level=new&operation=save&category=<?php echo $category;?>" method="post" enctype="multipart/form-data">
    <div class="row">
        <!-- Sol Taraf - Ürün Bilgileri -->
        <div class="col-md-6">
            <div class="card">
                <div class="card-header">
                    <h5 class="card-title mb-0">Ürün Bilgileri</h5>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label">Ürün Başlığı</label>
                                <input type="text" class="form-control" name="title" required="required">
                                <div class="form-text text-muted">Ürünün başlığı giriniz.</div>
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label">Fiyat</label>
                                <input type="text" class="form-control" name="price" required="required">
                                <div class="form-text text-muted">Ürünün fiyatını giriniz.</div>
                            </div>
                        </div>

                        <div class="col-md-12">
                            <div class="mb-3">
                                <label class="form-label">Ürün Açıklaması</label>
                                <textarea class="form-control" rows="5" name="content"></textarea>
                                <div class="form-text text-muted">Ürün hakkında bir açıklama giriniz.</div>
                            </div>
                        </div>

                        <div class="col-md-12">
                            <?php if($username == "demo"){ ?>
                                <a class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#demo_modal_default">
                                    Kaydet <i class="ph-paper-plane-tilt ms-2"></i>
                                </a>
                            <?php } else { ?>
                                <button type="submit" class="btn btn-primary">
                                    Kaydet <i class="ph-paper-plane-tilt ms-2"></i>
                                </button>
                            <?php } ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Sağ Taraf - Ürün Görseli -->
        <div class="col-md-6">
            <div class="card">
                <div class="card-header">
                    <h5 class="card-title mb-0">Ürün Görseli</h5>
                </div>
                <div class="card-body">
                    <div class="mb-3">
                        <label class="form-label">Görsel Seçin</label>
                        <input type="file" name="image" class="file form-control" accept="image/*"/>
                        <div class="form-text text-muted">Maksimum dosya boyutu: 64 KB, Formatlar: jpg,png,gif,webp</div>
                    </div>

                    <div class="upload-preview text-center p-3 border rounded">
                        <div class="text-muted mb-2">Henüz görsel seçilmedi</div>
                        <div class="upload-placeholder">
                            <i class="ph-image" style="font-size: 48px;"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</form>

<script>
$(document).ready(function() {
    const preview = $(".upload-preview");
    
    $(".file").change(function(event) {
        const input = $(event.currentTarget);
        const file = input[0].files[0];
        const reader = new FileReader();
        
        reader.onload = function(e) {
            const image_base64 = e.target.result;
            preview.html(`
                <img class="img-fluid rounded" src="${image_base64}" style="max-height: 240px;">
                <div class="mt-2 text-muted">Seçilen görsel</div>
            `);
        };
        
        reader.readAsDataURL(file);
    });
});
</script>
<?php } ?>

<?php if($level == "bulk_add"){ 

?>

<?php
if($operation == "save_bulk"){
$bulk_titles = isset($_POST["bulk_title"]) ? $_POST["bulk_title"] : array();
$bulk_contents = isset($_POST["bulk_content"]) ? $_POST["bulk_content"] : array();
$bulk_prices = isset($_POST["bulk_price"]) ? $_POST["bulk_price"] : array();
$success_count = 0;
$fail_count = 0;

if(
is_array($bulk_titles) && 
is_array($bulk_contents) && 
is_array($bulk_prices) && 
count($bulk_titles) > 0 &&
count($bulk_titles) == count($bulk_contents) &&
count($bulk_titles) == count($bulk_prices)
){
for($i=0; $i<count($bulk_titles); $i++){
$title = trim($bulk_titles[$i]);
$content = addslashes(trim($bulk_contents[$i]));
$price = trim($bulk_prices[$i]);
if($title != ""){
$seo_url = strtolower(preg_replace('/[^a-z0-9]+/i', '-', $title));
$seo_url = trim($seo_url, '-');
$title_esc = $baglan->real_escape_string($title);
$content_esc = $baglan->real_escape_string($content);
$seo_url_esc = $baglan->real_escape_string($seo_url);
$price_esc = $baglan->real_escape_string($price);
$category_esc = $baglan->real_escape_string($category);

$query = "INSERT INTO products (title, category, view, seo_url, content, price) VALUES ('$title_esc', '$category_esc', '0', '$seo_url_esc', '$content_esc', '$price_esc')";
$data_add = $baglan->query($query);
if($data_add){
$success_count++;
}else{
$fail_count++;
}
}
}
}
if($success_count > 0){
echo "<meta http-equiv='refresh' content='0;URL=products.php?category=$category&status=successful'>";
} else {
echo "<meta http-equiv='refresh' content='0;URL=products.php?category=$category&status=error'>";
}
exit;
}
?>

<div class="page-header page-header-light border rounded mb-3">
    <div class="page-header-content d-flex">
        <div class="page-title">
            <h5 class="mb-0">Toplu Ürün Ekle</h5>
        </div>
        <div class="my-auto ms-auto">
            <a href="products.php?category=<?php echo $category;?>" class="btn btn-danger"><i class="ph-caret-left"></i> Geri Dön</a>
        </div>
    </div>
</div>

<div class="card">
    <div class="card-body">
        <form action="products.php?level=bulk_add&operation=save_bulk&category=<?php echo $category;?>" method="post">
            <div id="bulk-products-list">
                <div class="row bulk-product-row mb-3">
                    <div class="col-md-4">
                        <label class="form-label">Ürün Başlığı</label>
                        <input type="text" class="form-control" name="bulk_title[]" required>
                    </div>
                    <div class="col-md-4">
                        <label class="form-label">Açıklama</label>
                        <input type="text" class="form-control" name="bulk_content[]" required>
                    </div>
                    <div class="col-md-3">
                        <label class="form-label">Fiyat</label>
                        <input type="text" class="form-control" name="bulk_price[]" required>
                    </div>
                    <div class="col-md-1 d-flex align-items-end">
                        <button type="button" class="btn btn-danger btn-sm remove-bulk-row" style="display:none;"><i class="fas fa-trash"></i></button>
                    </div>
                </div>
            </div>
            <div class="mb-3">
                <button type="button" class="btn btn-secondary" id="add-bulk-row"><i class="fas fa-plus"></i> Satır Ekle</button>
            </div>
            <div>
                <?php if($username == "demo"){?>
                    <a class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#demo_modal_default">Toplu Kaydet <i class="ph-paper-plane-tilt ms-2"></i></a>
                <?php }else{ ?>
                    <button type="submit" class="btn btn-primary">Toplu Kaydet <i class="ph-paper-plane-tilt ms-2"></i></button>
                <?php } ?>
            </div>
        </form>
    </div>
</div>
<script>
$(document).ready(function(){
    // Satır ekle
    $('#add-bulk-row').click(function(){
        var newRow = $('.bulk-product-row:first').clone();
        newRow.find('input').val('');
        newRow.find('.remove-bulk-row').show();
        $('#bulk-products-list').append(newRow);
    });
    // Satır sil
    $(document).on('click', '.remove-bulk-row', function(){
        if($('.bulk-product-row').length > 1){
            $(this).closest('.bulk-product-row').remove();
        }
    });
});
</script>
<?php } ?>

<?php if($level == "edit"){
$pull_data = $baglan->query("SELECT * FROM products WHERE id = '$dataid'")->fetch_assoc();
$title = $pull_data["title"];
$seo_url = $pull_data["seo_url"];
$seo_desc = $pull_data["seo_desc"];
$seo_keywords = $pull_data["seo_keywords"];
$content = $pull_data["content"];
$image = $pull_data["image"];
$price = $pull_data["price"];

if($operation == "guncelle"){
$dataid = g("dataid");
$title = p("title");
$seo_url = p("seo_url");
$seo_desc = p("seo_desc");
$seo_keywords = p("seo_keywords");
$price = p("price");
$content1 = $_POST["content"];
$content = addslashes($content1);

$imagekontrol = $_FILES["image"]['name']; 
if(!empty($imagekontrol)) {
    $img_data = file_get_contents($_FILES["image"]['tmp_name']);

    if ($img_data !== false) {
        // MIME türünü tespit et
        $finfo = new finfo(FILEINFO_MIME_TYPE);
        $mime_type = $finfo->buffer($img_data);

        // Geçerli MIME türleri ve uzantı eşleşmeleri
        $mime_to_ext = [
            'image/jpeg' => 'jpg',
            'image/png'  => 'png',
            'image/gif'  => 'gif',
            'image/webp' => 'webp',
        ];

        // Maksimum boyut (64 KB)
        $max_size = 64 * 1024;

        // Kontroller
        if (isset($mime_to_ext[$mime_type]) && strlen($img_data) <= $max_size) {
            // Gerçekten bir resim mi?
            $image = imagecreatefromstring($img_data);
            if ($image !== false) {
                $ext = $mime_to_ext[$mime_type];
                $rand_name = bin2hex(random_bytes(4)) . '.' . $ext;
                $save_path = __DIR__ . "/../images/" . $rand_name;

                // MIME türüne göre doğru kaydetme işlemi
                switch ($ext) {
                    case 'jpg':
                        imagejpeg($image, $save_path, 90); break;
                    case 'png':
                        imagepng($image, $save_path); break;
                    case 'gif':
                        imagegif($image, $save_path); break;
                    case 'webp':
                        imagewebp($image, $save_path); break;
                }

                imagedestroy($image);

                if (file_exists($save_path)) {
                    $image = "images/" . $rand_name;
                    $veri_degistir = $baglan->query("UPDATE products SET image = '$image' WHERE id = '$dataid'");
                }
            }
        }
    }
}

$veri_degistir = $baglan->query("UPDATE products SET 
title = '$title',
price = '$price',
content = '$content'
WHERE id = '$dataid'");
if($veri_degistir){echo "<meta http-equiv='refresh' content='0;URL=products.php?status=successful&category=$category'>";exit;}else{echo "<meta http-equiv='refresh' content='0;URL=products.php?status=error&category=$category'>";exit;}


}
?>

<div class="page-header page-header-light border rounded mb-3">
    <div class="page-header-content d-flex">
        <div class="page-title">
            <h5 class="mb-0">Düzenle: <?php echo $title;?></h5>
        </div>

        <div class="my-auto ms-auto">
            <a href="products.php?category=<?php echo $category;?>" class="btn btn-danger"><i class="ph-caret-left"></i> Geri Dön</a>
        </div>
    </div>
</div>

<?php if($status == "new"){?>
<div class="alert alert-success alert-dismissible fade show">
    <span class="fw-semibold">Tebrikler !</span> Yeni ürününüzü düzenleyebilirsiniz.
    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
</div>
<?php } ?>

<form action="products.php?level=edit&operation=guncelle&dataid=<?php echo $dataid;?>&category=<?php echo $category;?>" method="post" enctype="multipart/form-data" accept-charset="UTF-8">
    <div class="row">
        <!-- Sol Taraf - Ürün Bilgileri -->
        <div class="col-md-6">
            <div class="card">
                <div class="card-header">
                    <h5 class="card-title mb-0">Ürün Bilgileri</h5>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label">Ürün Başlığı</label>
                                <input type="text" class="form-control seo-title" name="title" required="required" value="<?php echo $title;?>">
                                <div class="form-text text-muted">Ürünün başlığı giriniz.</div>
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label">Fiyat</label>
                                <input type="text" class="form-control" name="price" value="<?php echo $price;?>">
                                <div class="form-text text-muted">Ürünün fiyatını giriniz.</div>
                            </div>
                        </div>

                        <div class="col-md-12">
                            <div class="mb-3">
                                <label class="form-label">Ürün Açıklaması</label>
                                <textarea class="form-control" rows="5" name="content"><?php echo htmlspecialchars($content, ENT_QUOTES | ENT_SUBSTITUTE, 'UTF-8'); ?></textarea>
                                <div class="form-text text-muted">Ürün hakkında bir açıklama giriniz.</div>
                            </div>
                        </div>

                        <div class="col-md-12">
                            <?php if($username == "demo"){ ?>
                                <a class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#demo_modal_default">
                                    Güncelle <i class="ph-paper-plane-tilt ms-2"></i>
                                </a>
                            <?php } else { ?>
                                <button type="submit" class="btn btn-primary">
                                    Güncelle <i class="ph-paper-plane-tilt ms-2"></i>
                                </button>
                            <?php } ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Sağ Taraf - Ürün Görseli -->
        <div class="col-md-6">
            <div class="card">
                <div class="card-header">
                    <h5 class="card-title mb-0">Ürün Görseli</h5>
                </div>
                <div class="card-body">
                    <div class="mb-3">
                        <label class="form-label">Görsel Seçin</label>
                        <input type="file" name="image" class="file form-control" accept="image/*"/>
                        <div class="form-text text-muted">Maksimum dosya boyutu: 64 KB, Formatlar: jpg,png,gif,webp</div>
                    </div>

                    <div class="upload-preview text-center p-3 border rounded">
                        <?php if(empty($image)){ ?>
                            <div class="text-muted mb-2">Henüz görsel seçilmedi</div>
                            <div class="upload-placeholder">
                                <i class="ph-image" style="font-size: 48px;"></i>
                            </div>
                        <?php } else { ?>
                            <img class="img-fluid rounded" src="<?php echo "../$image"; ?>" style="max-height: 240px;">
                            <div class="mt-2 text-muted">Mevcut görsel</div>
                        <?php } ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</form>

<script>
$(document).ready(function() {
    const preview = $(".upload-preview");
    
    $(".file").change(function(event) {
        const input = $(event.currentTarget);
        const file = input[0].files[0];
        const reader = new FileReader();
        
        reader.onload = function(e) {
            const image_base64 = e.target.result;
            preview.html(`
                <img class="img-fluid rounded" src="${image_base64}" style="max-height: 240px;">
                <div class="mt-2 text-muted">Seçilen görsel</div>
            `);
        };
        
        reader.readAsDataURL(file);
    });
});
</script>
</div>
<?php } ?>

<?php include("footer.php");?>