<?php include("header.php");?>

<div class="page-header page-header-light border rounded mb-3">
<div class="page-header-content">
<div class="page-title d-flex align-items-baseline flex-wrap">
<h5 class="mb-0">Gösterge Paneli</h5>
</div>
</div>
</div>

<?php

$setup = '../setup.php';
$db = '../db.sql';

if (file_exists($setup) && file_exists($db)) {?>

<div class="alert bg-danger text-white alert-dismissible fade show">
<span class="fw-semibold">Dikkat!</span> Kurulum dosyaları halen mevcut. Sitenizin zarar görmemesi için anadizindeki setup.php ve db.sql dosyalarını siliniz.</a>
<button type="button" class="btn-close btn-close-white" data-bs-dismiss="alert"></button>
</div>
									
<?php 
} else {}
?>


<div class="row">

<?php
if($maintenance_mode == "1"){
?>
<div class="col-md-12">
<div class="alert alert-warning border-1 alert-dismissible fade show">
<span class="fw-semibold">Bakım Modu:</span> Siteniz şuan bakım modunda. Ziyaretçiler siteye erişemez, ancak siz yönetici olarak ana siteyi görmeye devam edebilirsiniz.
<button type="button" class="btn-close" data-bs-dismiss="alert"></button>
</div>
</div>
<?php } ?>

</div>

<?php
$last_user_sql = $baglan->query("SELECT * FROM users ORDER BY id DESC LIMIT 1")->fetch_assoc();
$total_users = $last_user_sql['id'];

$today = date("Y-m-d");

$balance_sql = $baglan->query("SELECT SUM(price) as total FROM balance_payments WHERE create_date = '$today' AND status = 1");
if($balance_sql && $balance_data = $balance_sql->fetch_assoc()){
    $today_balance = $balance_data['total'];
    if($today_balance === null) $today_balance = 0;
} else {
    $today_balance = 0;
}

$order_row = $baglan->query("SELECT SUM(price) as total_orders FROM orders WHERE create_date = '".$today."'");
if($order_row && $row2 = $order_row->fetch_assoc()){
    $today_orders = $row2['total_orders'];
    if($today_orders === null) $today_orders = 0;
} else {
    $today_orders = 0;
}

$open_supports = 0;
$support_row = $baglan->query("SELECT COUNT(*) as open_supports FROM support_tickets WHERE status = 'open'");
if($support_row){
    $row3 = $support_row->fetch_assoc();
    if($row3 && isset($row3['open_supports'])){
        $open_supports = (int)$row3['open_supports'];
    }
}
?>
<div class="row">
    <div class="col-sm-6 col-xl-3">
        <div class="card card-body">
            <div class="d-flex align-items-center">
                <i class="ph-users-three ph-2x text-success me-3"></i>
                <div class="flex-fill text-end">
                    <h4 class="mb-0"><?php echo number_format($total_users); ?></h4>
                    <span class="text-muted">Toplam Üye</span>
                </div>
            </div>
        </div>
    </div>

    <div class="col-sm-6 col-xl-3">
        <div class="card card-body">
            <div class="d-flex align-items-center">
                <i class="ph-currency-circle-dollar ph-2x text-indigo me-3"></i>
                <div class="flex-fill text-end">
                    <h4 class="mb-0"><?php echo number_format($today_balance, 2); ?> ₺</h4>
                    <span class="text-muted">Bugün Yüklenen Bakiye</span>
                </div>
            </div>
        </div>
    </div>

    <div class="col-sm-6 col-xl-3">
        <div class="card card-body">
            <div class="d-flex align-items-center">
                <i class="ph-package ph-2x text-primary me-3"></i>
                <div class="flex-fill text-end">
                    <h4 class="mb-0"><?php echo number_format($today_orders, 2); ?> ₺</h4>
                    <span class="text-muted">Bugünkü Sipariş Tutarı</span>
                </div>
            </div>
        </div>
    </div>

    <div class="col-sm-6 col-xl-3">
        <div class="card card-body">
            <div class="d-flex align-items-center">
                <i class="ph-headset ph-2x text-danger me-3"></i>
                <div class="flex-fill text-end">
                    <h4 class="mb-0"><?php echo number_format($open_supports); ?></h4>
                    <span class="text-muted">Aktif Destek Talebi</span>
                </div>
            </div>
        </div>
    </div>
</div>
<div class="row mt-4">
    <div class="col-md-6 mb-4">
        <div class="card">
            <div class="card-header">
                <strong>Son 10 Bakiye Yükleme Kaydı</strong>
            </div>
            <div class="card-body p-0">
                <div class="d-none d-md-block">
                    <!-- Masaüstü için tablo -->
                    <div class="table-responsive">
                        <table class="table table-striped mb-0">
                            <thead>
                                <tr>
                                    <th>Kullanıcı</th>
                                    <th>Yöntem</th>
                                    <th>Miktar</th>
                                    <th>Tarih</th>
                                    <th>Saat</th>
                                    <th>Durum</th>
                                </tr>
                            </thead>
                            <tbody>
                            <?php
                            $balance_query = $baglan->query("SELECT bp.*, u.username FROM balance_payments bp LEFT JOIN users u ON bp.user_id = u.id ORDER BY bp.id DESC LIMIT 10");
                            if($balance_query && $balance_query->num_rows > 0){
                                while($row = $balance_query->fetch_assoc()){
                                    echo "<tr>";
                                    echo "<td>".htmlspecialchars($row['username'])."</td>";
                                    echo "<td>".htmlspecialchars($row['method'])."</td>";
                                    echo "<td>".number_format($row['price'], 2)." ₺</td>";
                                    echo "<td>".date('d.m.Y', strtotime($row['create_date']))."</td>";
                                    echo "<td>".htmlspecialchars($row['create_hour'])."</td>";
                                    echo "<td>";
                                    if($row['status'] == '1'){
                                        echo '<span class="badge bg-success">Onaylandı</span>';
                                    } elseif($row['status'] == '2'){
                                        echo '<span class="badge bg-danger">Reddedildi</span>';
                                    } else {
                                        echo '<span class="badge bg-warning text-dark">Bekliyor</span>';
                                    }
                                    echo "</td>";
                                    echo "</tr>";
                                }
                            } else {
                                echo '<tr><td colspan="6" class="text-center">Kayıt bulunamadı.</td></tr>';
                            }
                            ?>
                            </tbody>
                        </table>
                    </div>
                </div>
                <div class="d-block d-md-none p-2">
                    <!-- Mobil için kutu görünümü (Siparişler gibi göster) -->
                    <?php
                    $balance_query = $baglan->query("SELECT bp.*, u.username FROM balance_payments bp LEFT JOIN users u ON bp.user_id = u.id ORDER BY bp.id DESC LIMIT 10");
                    if($balance_query && $balance_query->num_rows > 0){
                        while($row = $balance_query->fetch_assoc()){
                    ?>
                        <div class="card mb-2 shadow-sm border-0" style="border-radius: 12px;">
                            <div class="card-body py-2 px-3">
                                <div class="d-flex justify-content-between align-items-center mb-1">
                                    <div>
                                        <div class="fw-semibold" style="font-size:1.05em;">
                                            <?php echo htmlspecialchars($row['username']); ?>
                                        </div>
                                        <div class="text-secondary" style="font-size:0.97em;">
                                            <?php echo htmlspecialchars($row['method']); ?>
                                        </div>
                                    </div>
                                    <div class="fw-bold text-end" style="font-size:1.1em;">
                                        <?php echo number_format($row['price'], 2); ?> ₺
                                    </div>
                                </div>
                                <div class="d-flex justify-content-between align-items-center mb-1" style="font-size:0.95em;">
                                    <div class="text-muted">
                                        <?php echo date('d.m.Y', strtotime($row['create_date'])); ?> - <?php echo htmlspecialchars($row['create_hour']); ?>
                                    </div>
                                    <div>
                                        <?php
                                        if($row['status'] == '1'){
                                            echo '<span class="badge bg-success">Onaylandı</span>';
                                        } elseif($row['status'] == '2'){
                                            echo '<span class="badge bg-danger">Reddedildi</span>';
                                        } else {
                                            echo '<span class="badge bg-warning text-dark">Bekliyor</span>';
                                        }
                                        ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                    <?php
                        }
                    } else {
                        echo '<div class="text-center text-muted py-3">Kayıt bulunamadı.</div>';
                    }
                    ?>
                </div>
            </div>
        </div>
    </div>
    <style>
    @media (max-width: 767.98px) {
        .card-body .table-responsive { display: none !important; }
    }
    </style>

    <div class="col-md-6 mb-4">
        <div class="card">
            <div class="card-header">
                <strong>Son 10 Sipariş</strong>
            </div>
            <div class="card-body p-0">
                <!-- Masaüstü görünüm (tablo) -->
                <div class="table-responsive d-none d-md-block">
                    <table class="table table-striped mb-0">
                        <thead>
                            <tr>
                                <th>Kullanıcı</th>
                                <th>Ürün</th>
                                <th>Tutar</th>
                                <th>Tarih</th>
                                <th>Saat</th>
                                <th>Durum</th>
                            </tr>
                        </thead>
                        <tbody>
                        <?php
                        $order_sql = $baglan->query("SELECT * FROM orders ORDER BY id DESC LIMIT 10");
                        if($order_sql && $order_sql->num_rows > 0){
                            while ($result = $order_sql->fetch_assoc()) {
                                $order_id = $result['id'];
                                $product = $result['product'];
                                $order_owner = $result['order_owner'];
                                $price = $result['price'];
                                $create_date = $result['create_date'];
                                $create_time = $result['create_time'];
                                $status = $result['status'];    

                                $view_product = $baglan->query("SELECT * FROM products WHERE id = '$product'")->fetch_assoc();
                                $product_title = isset($view_product["title"]) ? $view_product["title"] : '-';
                                $view_user = $baglan->query("SELECT * FROM users WHERE id = '$order_owner'")->fetch_assoc();
                                $user_username = isset($view_user["username"]) ? $view_user["username"] : '-';

                                echo "<tr>";
                                echo "<td>".htmlspecialchars($user_username)."</td>";
                                echo "<td>".htmlspecialchars($product_title)."</td>";
                                echo "<td>".number_format($price, 2)." ₺</td>";
                                echo "<td>".($create_date ? date('d.m.Y', strtotime($create_date)) : '-')."</td>";
                                echo "<td>".htmlspecialchars($create_time)."</td>";
                                echo "<td>";
                                // Sipariş durumu: 0 = Bekliyor, 1 = Tamamlandı, 2 = İptal
                                if($status == '1'){
                                    echo '<span class="badge bg-success">Tamamlandı</span>';
                                } elseif($status == '2'){
                                    echo '<span class="badge bg-danger">İptal</span>';
                                } else {
                                    echo '<span class="badge bg-warning text-dark">Bekliyor</span>';
                                }
                                echo "</td>";
                                echo "</tr>";
                            }
                        } else {
                            echo '<tr><td colspan="6" class="text-center">Kayıt bulunamadı.</td></tr>';
                        }
                        ?>
                        </tbody>
                    </table>
                </div>
                <!-- Mobil görünüm (kartlar) -->
                <div class="d-block d-md-none p-2">
                    <?php
                    $order_sql = $baglan->query("SELECT * FROM orders ORDER BY id DESC LIMIT 10");
                    if($order_sql && $order_sql->num_rows > 0){
                        while ($result = $order_sql->fetch_assoc()) {
                            $order_id = $result['id'];
                            $product = $result['product'];
                            $order_owner = $result['order_owner'];
                            $price = $result['price'];
                            $create_date = $result['create_date'];
                            $create_time = $result['create_time'];
                            $status = $result['status'];    

                            $view_product = $baglan->query("SELECT * FROM products WHERE id = '$product'")->fetch_assoc();
                            $product_title = isset($view_product["title"]) ? $view_product["title"] : '-';
                            $view_user = $baglan->query("SELECT * FROM users WHERE id = '$order_owner'")->fetch_assoc();
                            $user_username = isset($view_user["username"]) ? $view_user["username"] : '-';

                            // Durum metni ve rengi
                            if($status == '1'){
                                $durum_text = '<span class="badge bg-success">Tamamlandı</span>';
                            } elseif($status == '2'){
                                $durum_text = '<span class="badge bg-danger">İptal</span>';
                            } else {
                                $durum_text = '<span class="badge bg-secondary">Bekliyor</span>';
                            }
                            ?>
                            <div class="card mb-3 shadow-sm border-0" style="border-radius: 16px;">
                                <div class="card-body py-3 px-3">
                                    <div class="d-flex justify-content-between align-items-center mb-2">
                                        <div class="d-flex align-items-center">
                                            <div class="rounded-circle bg-primary bg-opacity-10 d-flex align-items-center justify-content-center me-3" style="width:38px;height:38px;">
                                                <i class="ph-user text-primary" style="font-size:1.3em;"></i>
                                            </div>
                                            <div>
                                                <div class="fw-semibold" style="font-size:1.08em;"><?php echo htmlspecialchars($user_username); ?></div>
                                                <div class="text-secondary" style="font-size:0.97em;"><?php echo htmlspecialchars($product_title); ?></div>
                                            </div>
                                        </div>
                                        <div class="text-end">
                                            <div class="fw-bold" style="font-size:1.15em;"><?php echo number_format($price, 2); ?> <span class="text-muted" style="font-size:0.95em;">₺</span></div>
                                            <div><?php echo $durum_text; ?></div>
                                        </div>
                                    </div>
                                    <div class="d-flex justify-content-between align-items-center text-muted" style="font-size:0.97em;">
                                        <div>
                                            <i class="ph-calendar me-1"></i>
                                            <?php echo ($create_date ? date('d.m.Y', strtotime($create_date)) : '-'); ?>
                                        </div>
                                        <div>
                                            <i class="ph-clock me-1"></i>
                                            <?php echo htmlspecialchars($create_time); ?>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <?php
                        }
                    } else {
                        echo '<div class="text-center text-muted py-3">Kayıt bulunamadı.</div>';
                    }
                    ?>
                </div>
            </div>
        </div>
    </div>
</div>
</div>
<?php include("footer.php");?>