<?php include("header.php");

$level = g("level");
$status = g("status");
$operation = g("operation");
$dataid = g("dataid");

// Sipariş durumları
// Sipariş durumlarını badge ve fontawesome ikonları ile gösterecek şekilde dizi
$order_statuses = [
    0 => '<span class="badge bg-warning"><i class="fa fa-hourglass-half me-1"></i>Bekliyor</span>',
    1 => '<span class="badge bg-success"><i class="fa fa-check-circle me-1"></i>Tamamlandı</span>',
    2 => '<span class="badge bg-danger"><i class="fa fa-times-circle me-1"></i>İptal Edildi</span>',
    3 => '<span class="badge bg-secondary"><i class="fa fa-undo me-1"></i>İade Edildi</span>'
];

// Sipariş düzenleme işlemi
if($level == "edit" && $operation == "update" && !empty($dataid) && $_SERVER['REQUEST_METHOD'] == 'POST'){
    $order_id = intval($dataid);

    // Kullanıcı, ürün, kategori id'leri artık formdan alınacak
    $order_owner = intval(p("order_owner"));
    $product = intval(p("product"));
    $category = intval(p("category"));
    $data = trim(p("data"));
    $create_date = trim(p("create_date"));
    $create_time = p("create_time");
    $price = floatval(p("price"));
    $status_new = intval(p("status"));
    $note = trim(p("note"));

    // Siparişin mevcut durumunu ve bilgilerini çek
    $order_query = $baglan->prepare("SELECT * FROM orders WHERE id=? LIMIT 1");
    $order_query->bind_param("i", $order_id);
    $order_query->execute();
    $order_result = $order_query->get_result();
    $order = $order_result->fetch_assoc();
    $order_query->close();

    if($order){
        $old_status = intval($order['status']);
        $old_order_owner = intval($order['order_owner']);

        // Eğer iptal veya iade ediliyorsa ve daha önce iptal/iade edilmemişse, bakiyeyi iade et (sadece eski order_owner için)
        if(($status_new == 2 || $status_new == 3) && ($old_status != 2 && $old_status != 3)){
            // Kullanıcının mevcut bakiyesini çek
            $user_query = $baglan->prepare("SELECT balance FROM users WHERE id=? LIMIT 1");
            $user_query->bind_param("i", $old_order_owner);
            $user_query->execute();
            $user_result = $user_query->get_result();
            $user = $user_result->fetch_assoc();
            $user_query->close();

            if($user){
                $new_balance = floatval($user['balance']) + $price;
                $update_balance = $baglan->prepare("UPDATE users SET balance=? WHERE id=?");
                $update_balance->bind_param("di", $new_balance, $old_order_owner);
                $update_balance->execute();
                $update_balance->close();
            }
        }
        $update_order = $baglan->prepare("UPDATE orders SET order_owner=?, product=?, category=?, data=?, create_date=?, create_time=?, price=?, status=?, note=? WHERE id=?");
        $update_order->bind_param("iiisssdssi", $order_owner, $product, $category, $data, $create_date, $create_time, $price, $status_new, $note, $order_id);
        if($update_order->execute()){
            echo '<meta http-equiv="refresh" content="0;URL=orders.php?status=successful">';
            exit();
        } else {
            echo '<meta http-equiv="refresh" content="0;URL=orders.php?status=error">';
            exit();
        }
    } else {
        echo '<meta http-equiv="refresh" content="0;URL=orders.php?status=error">';
        exit();
    }
}
?>
<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.2.1/jquery.min.js"></script>
<?php if(empty($level)){?>
<div class="page-header page-header-light border rounded mb-3">
    <div class="page-header-content d-flex">
        <div class="page-title">
            <h5 class="mb-0"><i class="fas fa-shopping-cart"></i> Siparişler</h5>
        </div>
    </div>
</div>

<?php if($status == "error"){?>
<div class="col-md-12">
    <div class="alert alert-danger alert-dismissible fade show">
        <span class="fw-semibold">Hata:</span> Bir hata oluştu.
    </div>
</div>
<?php } ?>

<?php if($status == "no-order"){?>
<div class="col-md-12">
    <div class="alert alert-danger alert-dismissible fade show">
        <span class="fw-semibold">Hata:</span> Sipariş bulunamadı.
    </div>
</div>
<?php } ?>

<?php if($status == "successful"){?>
<div class="col-md-12">
    <div class="alert alert-success alert-dismissible fade show">
        <span class="fw-semibold">Başarılı:</span> İşlem başarıyla gerçekleştirildi.
    </div>
</div>
<?php } ?>

<div class="row mb-3">
    <div class="col-md-12">
        <form id="orderSearchForm" class="input-group" onsubmit="return goToOrderEdit();">
            <input type="number" min="1" class="form-control" id="orderSearchInput" placeholder="Sipariş ID ile ara" style="padding:15px;" required>
            <button type="submit" class="btn btn-secondary">Ara</button>
        </form>
    </div>
</div>
<script>
function goToOrderEdit() {
    var orderId = document.getElementById('orderSearchInput').value.trim();
    if(orderId && !isNaN(orderId)) {
        window.location.href = 'orders.php?level=edit&dataid=' + encodeURIComponent(orderId);
    }
    return false;
}
</script>



<div class="card">
    <div class="table-responsive">
        <table class="table table-bordered align-middle">
            <thead>
                <tr>
                    <th>#</th>
                    <th>Kullanıcı</th>
                    <th>Ürün</th>
                    <th>Kategori</th>
                    <th>Fiyat</th>
                    <th>Durum</th>
                    <th>Tarih</th>
                    <th>Saat</th>
                    <th>İşlemler</th>
                </tr>
            </thead>
            <tbody>
            <?php
            $sno = 0;
            $orders = $baglan->query("SELECT o.*, u.username, p.title as product_title, c.title as category_title 
                FROM orders o 
                LEFT JOIN users u ON o.order_owner = u.id 
                LEFT JOIN products p ON o.product = p.id 
                LEFT JOIN category c ON o.category = c.id 
                ORDER BY o.id DESC");
            while ($order = $orders->fetch_assoc()) {
                $sno++;
                $order_id = $order['id'];
                $username = htmlspecialchars($order['username']);
                $product_title = htmlspecialchars($order['product_title']);
                $category_title = htmlspecialchars($order['category_title']);
                $price = number_format($order['price'], 2, ',', '.');
                $status_val = isset($order_statuses[$order['status']]) ? $order_statuses[$order['status']] : "Bilinmiyor";
                $create_date = date('d.m.Y', strtotime($order['create_date']));
                $create_time = htmlspecialchars($order['create_time']);
                echo '
                <tr>
                    <td>'.$sno.'</td>
                    <td>'.$username.'</td>
                    <td>'.$product_title.'</td>
                    <td>'.$category_title.'</td>
                    <td>'.$price.' ₺</td>
                    <td>'.$status_val.'</td>
                    <td>'.$create_date.'</td>
                    <td>'.$create_time.'</td>
                    <td>
                        <a class="btn btn-primary btn-sm" href="orders.php?level=edit&dataid='.$order_id.'"><i class="fas fa-edit mfit"></i> Düzenle</a>
                    </td>
                </tr>
                ';
            }
            ?>
            </tbody>
        </table>
    </div>
</div>
<?php } ?>

<?php
if($level == "edit" && !empty($dataid)){
    $order_id = intval($dataid);
    $order = $baglan->query("SELECT o.*, u.username, p.title as product_title, c.title as category_title 
        FROM orders o 
        LEFT JOIN users u ON o.order_owner = u.id 
        LEFT JOIN products p ON o.product = p.id 
        LEFT JOIN category c ON o.category = c.id 
        WHERE o.id = '$order_id' LIMIT 1")->fetch_assoc();
    if(!$order){
		echo '<meta http-equiv="refresh" content="0;URL=orders.php?status=no-order">';
    } else {
        $username = htmlspecialchars($order['username']);
        $order_owner = intval($order['order_owner']);
        $product_title = htmlspecialchars($order['product_title']);
        $product = intval($order['product']);
        $category_title = htmlspecialchars($order['category_title']);
        $category = intval($order['category']);
        $price = number_format($order['price'], 2, '.', '');
        $create_date = htmlspecialchars($order['create_date']);
        $create_time = $order['create_time'];
        $data = htmlspecialchars($order['data']);
        $note = htmlspecialchars($order['note']);
        $status_val = intval($order['status']);

     
?>
<div class="page-header page-header-light border rounded mb-3">
    <div class="page-header-content d-flex">
        <div class="page-title">
            <h5 class="mb-0"><i class="fas fa-shopping-cart"></i> Sipariş Düzenle: <font color='red'>#<?php echo $order_id; ?></font> <font style='font-weight:400;'>(<?php echo $username; ?>)</font></h5>
        </div>
        <div class="my-auto ms-auto">
		<a href="orders.php" class="btn btn-warning"><i class="ph-arrow-bend-up-left"></i> Geri Dön</a>
        </div>
    </div>
</div>

<div class="card">
    <div class="card-body">
        <form action="orders.php?level=edit&operation=update&dataid=<?php echo $order_id;?>" method="post" enctype="multipart/form-data">
            <div class="row">
                <!-- Kullanıcı, Ürün, Kategori id ve isim kutuları -->
				
				<div class="col-md-4">
				
				<div class="card border shadow-sm">
			

				<div class="card-body">
				<div class="row">
				    <div class="col-md-6">
                    <div class="mb-3">
                        <label class="form-label">Kullanıcı Adı</label>
                        <div class="input-group">
                            <input type="text" class="form-control" value="<?php echo $username; ?>" disabled>
                            <a href="users.php?level=edit&dataid=<?php echo $order_owner; ?>" class="btn btn-flat-primary" title="Kullanıcıya Git">
                                <i class="fa fa-arrow-right"></i>
                            </a>
                        </div>
                    </div>
                </div>
				
				<div class="col-md-6">
                    <div class="mb-3">
                        <label class="form-label">Kullanıcı ID</label>
                        <input type="text" class="form-control" name="order_owner" value="<?php echo $order_owner; ?>" required>
						
                    </div>
                </div>
				
				<div class="col-md-12">
				<div class="form-text text-muted">Sipariş sahibini değiştirmek için üye id numarasını değiştirebilirsiniz.</div>
				</div>
				
				</div>
				</div>
				</div>
							
				
				</div>
				
				<div class="col-md-4">
				<div class="card border shadow-sm">
				<div class="card-body">
				<div class="row">
				
				<div class="col-md-6">
				<div class="mb-3">
				<label class="form-label">Ürün Adı</label>
				<div class="input-group">
					<input type="text" class="form-control" value="<?php echo $product_title; ?>" disabled>
					<a href="products.php?level=edit&dataid=<?php echo $product; ?>&category=<?php echo $category; ?>" class="btn btn-flat-primary" title="Ürüne Git">
						<i class="fa fa-arrow-right"></i>
					</a>
				</div>
				</div>
				</div>

				<div class="col-md-6">
				<div class="mb-3">
				<label class="form-label">Ürün ID</label>
				<input type="text" class="form-control" name="product" value="<?php echo $product; ?>" required>
				</div>
				</div>

				<div class="col-md-12">
				<div class="form-text text-muted">Ürünü değiştirmek için ürün id numarasını değiştirebilirsiniz.</div>
				</div>

				</div>
				</div>
				</div>
				</div>
				
				<div class="col-md-4">
				<div class="card border shadow-sm">
				<div class="card-body">
				<div class="row">
				
				 <div class="col-md-6">
                    <div class="mb-3">
                        <label class="form-label">Kategori Adı</label>
                        <div class="input-group">
                            <input type="text" class="form-control" value="<?php echo $category_title; ?>" disabled>
                            <a href="category.php?level=edit&dataid=<?php echo $category; ?>" class="btn btn-flat-primary" title="Kategoriye Git">
                                <i class="fa fa-arrow-right"></i>
                            </a>
                        </div>
                    </div>
                </div>
				
				<div class="col-md-6">
                    <div class="mb-3">
                        <label class="form-label">Kategori ID</label>
                        <input type="text" class="form-control" name="category" value="<?php echo $category; ?>" required>
                    </div>
                </div>
               
				

				<div class="col-md-12">
				<div class="form-text text-muted">Kategoriyi değiştirmek için kategori id numarasını değiştirebilirsiniz.</div>
				</div>

				</div>
				</div>
				</div>
				</div>
				
                <div class="col-md-6">
                    <div class="mb-3">
                        <label class="form-label">Fiyat</label>
                        <input type="number" step="0.01" class="form-control" name="price" value="<?php echo $price;?>" required>
                    </div>
                </div>
				
				
				
                <div class="col-md-6">
                    <div class="mb-3">
                        <label class="form-label">Tarih</label>
                        <input type="text" class="form-control" name="create_date" value="<?php echo $create_date;?>" required>
                    </div>
                </div>
				
				<div class="col-md-6">
                    <div class="mb-3">
                        <label class="form-label">Durum</label>
                        <select class="form-control" name="status" required>
                            <?php
                            foreach($order_statuses as $key => $val){
                                $selected = ($status_val == $key) ? 'selected' : '';
                                echo '<option value="'.$key.'" '.$selected.'>'.$val.'</option>';
                            }
                            ?>
                        </select>
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="mb-3">
                        <label class="form-label">Saat</label>
                        <input type="text" class="form-control" name="create_time" value="<?php echo $create_time;?>" required>
                    </div>
                </div>
				
				
				
                <div class="col-md-6">
                    <div class="mb-3">
                        <label class="form-label">Teslim Edilen Veri</label>
                        <textarea class="form-control" name="data" rows="2"><?php echo $data;?></textarea>
                    </div>
                </div>
				
				<div class="col-md-6">
                    <div class="mb-3">
                        <label class="form-label">Not</label>
                        <textarea class="form-control" name="note" rows="2"><?php echo $note;?></textarea>
						<div class="form-text text-muted">Bu not sadece yöneticiler tarafından görüntülenebilir.</div>
                    </div>
                </div>
				
                
                
                <div class="col-12">
				<?php if($admin_user_data_pull['username'] == "demo"){?>
				<a class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#demo_modal_default">Güncelle <i class="ph-paper-plane-tilt ms-2"></i></a>
				<?php }else{ ?>
				<button type="submit" class="btn btn-primary">Güncelle <i class="ph-paper-plane-tilt ms-2"></i></button>
				<?php } ?>
                </div>
				
            </div>
        </form>
    </div>
</div>
<?php
    }
}
?>

<?php include("footer.php");?>