<?php include("header.php");?>

<div class="page-header page-header-light border rounded mb-3">
    <div class="page-header-content">
        <div class="page-title d-flex align-items-baseline flex-wrap">
            <h5 class="mb-0">Lisans Bilgileriniz</h5>
        </div>
    </div>
</div>

<?php
$settings = $baglan->query("SELECT * FROM settings WHERE id = '1'")->fetch_assoc();
$expiration = $settings['expiration'] ?? null;
$licence_key = $settings['licence_key'] ?? null;

if (!isset($licence_status)) {
    $licence_status = "inactive";
}

$today = date('Y-m-d');

$days_left = null;
if ($expiration) {
    $exp_date = new DateTime($expiration);
    $today_date = new DateTime($today);
    $interval = $today_date->diff($exp_date);
    $days_left = (int)$interval->format('%r%a');
}
?>

<div class="row">
    <?php if($maintenance_mode == "1"){ ?>
        <div class="col-md-12">
            <div class="alert alert-warning border-1 alert-dismissible fade show">
                <span class="fw-semibold">Bakım Modu:</span> Siteniz şuan bakım modunda. Ziyaretçiler siteye erişemez, ancak siz yönetici olarak ana siteyi görmeye devam edebilirsiniz.
                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            </div>
        </div>
    <?php } ?>
</div>

<div class="row">
    <div class="col-md-12">
        <?php if($licence_status == "inactive") { ?>
            <div class="alert alert-danger border-1 alert-dismissible fade show">
                <i class="ph-warning fs-4 me-2"></i>
                <strong>Geçersiz Lisans:</strong> Lisansınız geçersiz veya süresi dolmuş. Lütfen lisans anahtarınızı kontrol edin veya destek ile iletişime geçin.
            </div>
			<a href="licence.php?restart=recheck" target="_blank" class="btn btn-success">Lisansı Tekrar Kontrol Et</a><br><br>
			
        <?php } ?>
            <div class="card mb-3">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <?php if($expiration < $today) { ?>
                        <span class="fw-semibold"><i class="ph-warning fs-4 me-2"></i>Lisans Durumu: <span class="text-danger">Süresi Doldu</span></span>
                    <?php } else { ?>
                        <span class="fw-semibold"><i class="ph-circle-wavy-check text-success me-2"></i>Lisans Durumu: <span class="text-success">Aktif</span></span>
                    <?php } ?>
                    <span class="text-muted">Son Geçerlilik Tarihi: <strong><?php echo htmlspecialchars(date('d.m.Y', strtotime($expiration))); ?></strong></span>
                </div>
                <div class="card-body">
                    <div class="mb-3">
                        <h6 class="card-title mb-2">Lisans Anahtarınız</h6>
                        <div class="input-group">
                            <input type="text" class="form-control" value="<?php echo htmlspecialchars($licence_key); ?>" readonly>
                            <button class="btn btn-outline-secondary" type="button" onclick="navigator.clipboard.writeText('<?php echo htmlspecialchars($licence_key); ?>')"><i class="ph-copy"></i></button>
                        </div>
                    </div>
                    <div>
                        <h6 class="card-title mb-2">Kalan Süre</h6>
                        <?php if($days_left !== null) {
                            if($days_left > 0) {
                                echo '<span class="badge bg-success fs-6">Lisansınızın bitmesine <strong>' . $days_left . '</strong> gün kaldı.</span>';
                            } elseif($days_left == 0) {
                                echo '<span class="badge bg-warning fs-6">Lisansınız bugün sona eriyor!</span>';
                            } else {
                                echo '<span class="badge bg-danger fs-6">Lisans süreniz dolmuş!</span>';
                            }
                        } else {
                            echo '<span class="badge bg-secondary fs-6">Lisans bitiş tarihi bulunamadı.</span>';
                        } ?>
                        <h6 class="card-title mb-2" style="color: red;margin-top: 10px;">Dikkat:</h6>
                        <p>
                        Lisansınızın biteceği günden önce lisans yenilemeyi unutmayınız.<br>
                        Lisansınız bittiğinde ziyaretçileriniz siteyi kullanırken aksaklıklar yaşayabilirler.<br>
                        Lisans bittiğinde kontrol panelinize erişemezsiniz.<br>
                        Herhangi bir sorun yaşamamak için lisansınızın bitişinden 1 gün önce lisansınızı yenilemeyi unutmayınız.<br><br>
                        <a href="https://keyapix.com" target="_blank" class="btn btn-success">Lisansı Uzat</a>
                        </p>
                    </div>
                </div>
            </div>
       
    </div>
</div>

<?php include("footer.php");?>