<?php include ("core/functions.php"); ?>

<!DOCTYPE html>
<html lang="tr" dir="ltr">

<head>
<meta charset="utf-8">
<meta http-equiv="X-UA-Compatible" content="IE=edge">
<meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
<title>Keyapix Admin Panel</title>

<link href="fonts/inter/inter.css" rel="stylesheet" type="text/css">
<link href="icons/phosphor/styles.min.css" rel="stylesheet" type="text/css">
<link href="assets/css/ltr/all.min.css" id="stylesheet" rel="stylesheet" type="text/css">

<link href="css/style.css?v=1.0.1" rel="stylesheet" type="text/css">
<script src="core/charts/demo_configurator.js"></script>
<script src="js/bootstrap/bootstrap.bundle.min.js"></script>
<script src="js/vendor/visualization/d3/d3.min.js"></script>
<script src="js/vendor/visualization/d3/d3_tooltip.js"></script>
<script src="assets/js/app.js"></script>
<script src="core/charts/pages/dashboard.js"></script>
<script src="core/charts/charts/pages/dashboard/streamgraph.js"></script>
<script src="core/charts/charts/pages/dashboard/sparklines.js"></script>
<script src="core/charts/charts/pages/dashboard/lines.js"></script>	
<script src="core/charts/charts/pages/dashboard/areas.js"></script>
<script src="core/charts/charts/pages/dashboard/donuts.js"></script>
<script src="core/charts/charts/pages/dashboard/bars.js"></script>
<script src="core/charts/charts/pages/dashboard/progress.js"></script>
<script src="core/charts/charts/pages/dashboard/heatmaps.js"></script>
<script src="core/charts/charts/pages/dashboard/pies.js"></script>
<script src="core/charts/charts/pages/dashboard/bullets.js"></script>
<link href="css/fontawesome/css/all.css" rel="stylesheet">
<link rel="icon" href="images/favicon.png" type="image/x-icon" />

</head>

<body>

<div class="navbar navbar-dark navbar-expand-lg navbar-static border-bottom border-bottom-white border-opacity-10">
<div class="container-fluid">
<div class="d-flex d-lg-none me-2">
<button type="button" class="navbar-toggler sidebar-mobile-main-toggle rounded-pill">
<i class="ph-list"></i>
</button>
</div>

<div class="navbar-brand flex-1 flex-lg-0">
<a href="panel.php" class="d-inline-flex align-items-center" style="color:white;font-weight:600;font-size:16px;">Keyapi<font color="#FF6000">X</font>  - Admin Panel</a>
</div>


<ul class="nav flex-row justify-content-end order-1 order-lg-2">

<li class="nav-item"><a href="../" class="navbar-nav-link navbar-nav-link-icon rounded-pill" target="_blank"><i class="ph-arrow-square-in"></i></a></li>

<li class="nav-item">
<a href="#" class="navbar-nav-link navbar-nav-link-icon rounded-pill" data-bs-toggle="offcanvas" data-bs-target="#demo_config">
<i class="ph-sun"></i>
</a>
</li>
				
<li class="nav-item nav-item-dropdown-lg dropdown ms-lg-2">
<a href="#" class="navbar-nav-link align-items-center rounded-pill p-1" data-bs-toggle="dropdown">
<div class="status-indicator-container"><img src="images/user.png" class="w-32px h-32px rounded-pill" alt=""><span class="status-indicator bg-success"></span></div>
<span class="d-none d-lg-inline-block mx-lg-2"><?php echo $username;?></span>
</a>

<div class="dropdown-menu dropdown-menu-end">
<a href="account.php" class="dropdown-item"><i class="ph-gear me-2"></i>Hesap Ayarları</a>
<a href="exit.php" class="dropdown-item"><i class="ph-sign-out me-2"></i>Çıkış Yap</a>
</div>
</li>
</ul>
</div>
</div>

<div class="page-content">

<div class="sidebar sidebar-dark sidebar-main sidebar-expand-lg">

<div class="sidebar-content">

<div class="sidebar-section">
<div class="sidebar-section-body d-flex justify-content-center">
<h5 class="sidebar-resize-hide flex-grow-1 my-auto">Menü</h5>

<div>
<button type="button" class="btn btn-flat-white btn-icon btn-sm rounded-pill border-transparent sidebar-control sidebar-main-resize d-none d-lg-inline-flex">
<i class="ph-arrows-left-right"></i>
</button>

<button type="button" class="btn btn-flat-white btn-icon btn-sm rounded-pill border-transparent sidebar-mobile-main-toggle d-lg-none">
<i class="ph-x"></i>
</button>
</div>
</div>
</div>
<div class="sidebar-section">
<ul class="nav nav-sidebar" data-nav-type="accordion">

<li class="nav-item"><a href="panel.php" class="nav-link"><i class="ph-house"></i><span>Anasayfa</span></a></li>
<li class="nav-item-header">
<div class="text-uppercase fs-sm lh-sm opacity-50 sidebar-resize-hide">Sistem Seçenekler</div>
<i class="ph-dots-three sidebar-resize-show"></i>
</li>

<li class="nav-item nav-item-submenu">
<a href="#" class="nav-link">
<i class="ph-gear-six"></i>
<span>Ayarlar</span>
</a>
<ul class="nav-group-sub collapse" style="">
<li class="nav-item"><a href="settings.php" class="nav-link"><i class="ph-globe-hemisphere-west"></i> Sistem Ayarları</a></li>
</ul>
</li>

<li class="nav-item nav-item-submenu">
<a href="#" class="nav-link">
<i class="ph-brackets-angle"></i>
<span>Eklentiler</span>
</a>
<ul class="nav-group-sub collapse" style="">
<li class="nav-item"><a href="announcements.php" class="nav-link"><i class="ph-broadcast"></i> Duyurular</a></li>
<li class="nav-item"><a href="reference_url.php" class="nav-link"><i class="ph-plugs-connected"></i> Referans URL</a></li>
<li class="nav-item"><a href="whatsapp.php" class="nav-link"><i class="ph-whatsapp-logo"></i> Whatsapp Butonu</a></li>
</ul>
</li>

<?php
$last_order_id = $baglan->query("SELECT id FROM orders ORDER BY id DESC LIMIT 1")->fetch_assoc()['id'] ?? 0;
?>

<li class="nav-item">
<a href="orders.php" class="nav-link">
<i class="ph-note-pencil"></i>
<span>Siparişler</span>
<span class="badge bg-success align-self-center ms-auto"><?php echo (int)$last_order_id; ?></span>
</a>
</li>

<?php
// Son üye id'si toplam üye sayısıdır, ekstra sorgu yapmaya gerek yok
$last_user_id = $baglan->query("SELECT id FROM users ORDER BY id DESC LIMIT 1")->fetch_assoc()['id'] ?? 0;
?>

<li class="nav-item">
<a href="users.php" class="nav-link">
<i class="ph-users"></i>
<span>Üyeler</span>
<span class="badge bg-primary align-self-center ms-auto"><?php echo (int)$last_user_id; ?></span>
</a>
</li>

<?php
$api_count = $baglan->query("SELECT COUNT(*) as total FROM api")->fetch_assoc()['total'] ?? 0;
?>
<li class="nav-item"><a href="api.php" class="nav-link"><i class="ph-link"></i><span>Api Bağlantıları</span> <span class="badge bg-warning align-self-center ms-auto"><?php echo (int)$api_count; ?></span></a></li>

<?php
$ticket_count = $baglan->query("SELECT COUNT(*) as total FROM support_tickets WHERE status='open'")->fetch_assoc()['total'] ?? 0;
?>
<li class="nav-item"><a href="support.php" class="nav-link"><i class="ph-chat-circle-text"></i><span>Destek Talepleri</span> <span class="badge bg-danger align-self-center ms-auto"><?php echo (int)$ticket_count; ?></span></a></li>
<li class="nav-item"><a href="balances.php" class="nav-link"><i class="ph-wallet"></i><span>Bakiye Ödemeleri</span></a></li>
<li class="nav-item"><a href="payment_option.php" class="nav-link"><i class="ph-shopping-cart-simple"></i><span>Ödeme Yöntemleri</span></a></li>
<li class="nav-item"><a href="category.php" class="nav-link"><i class="ph-list"></i><span>Ürün Yönetimi</span></a></li>
<li class="nav-item"><a href="licence.php" class="nav-link"><i class="ph-circle-wavy-check"></i><span>Lisans Bilgileri</span></a></li>
<li class="nav-item"><a href="update.php" class="nav-link"><i class="ph-arrows-clockwise"></i><span>Yazılım Güncelleme</span></a></li>

<li class="nav-item-header">
<div class="text-uppercase fs-sm lh-sm opacity-50 sidebar-resize-hide">Tema Ayarları</div>
<i class="ph-dots-three sidebar-resize-show"></i>
</li>
<li class="nav-item"><a href="themes.php" class="nav-link"><i class="ph-highlighter-circle"></i><span>Temalar</span></a></li>
<li class="nav-item"><a href="menus.php" class="nav-link"><i class="ph-arrow-square-in"></i><span>Menü Yönetimi</span></a></li>
<li class="nav-item"><a href="slider.php" class="nav-link"><i class="ph-faders-horizontal"></i><span>Slider Yönetimi</span></a></li>
<li class="nav-item"><a href="homepage_row.php" class="nav-link"><i class="ph-arrows-down-up"></i><span>Anasayfa Sıralaması</span></a></li>

<li class="nav-item"><a href="pages.php" class="nav-link"><i class="ph-leaf"></i><span>Sayfalar</span></a></li>
<li class="nav-item"><a href="faqs.php" class="nav-link"><i class="ph-question"></i><span>Sıkça Sorulan Sorular</span></a></li>
<li class="nav-item"><a href="exit.php" class="nav-link"><i class="ph-power"></i><span>Çıkış Yap</span></a></li>


</ul>
</div>


</div>


</div>

<style>
.yfa {margin-right:5px;}
.mfi {width:20px;margin-top:2px !important;}
.mfit {width:20px;font-size:15px;}
</style>

<div id="demo_modal_default" class="modal fade" tabindex="-1">
<div class="modal-dialog">
<div class="modal-content">
<div class="modal-header">
<h5 class="modal-title">Demo Modu</h5>
<button type="button" class="btn-close" data-bs-dismiss="modal"></button>
</div>

<div class="modal-body">
<p>Demo modunda düzenleme, silme gibi işlemler kısıtlanmıştır.</p>
</div>

<div class="modal-footer">
<button type="button" class="btn btn-danger" data-bs-dismiss="modal"><i class="far fa-times-circle mfi"></i> Kapat</button>
</div>
</div>
</div>
</div>

<div class="content-wrapper">
<div class="content-inner">
<div class="content">