<?php include("header.php"); ?>
<?php
$status = g("status");
$action = g("action");

if ($action == "add") {
    $code = p("code");
    $amount = p("amount");

    if (empty($code)) {
        // Generate random code if empty
        $code = strtoupper(substr(md5(uniqid(mt_rand(), true)), 0, 10));
    }

    if (!empty($amount) && $amount > 0) {
        $check = $baglan->query("SELECT id FROM gift_codes WHERE code = '$code'");
        if ($check->num_rows > 0) {
            echo "<meta http-equiv='refresh' content='0;URL=gift_codes.php?status=exist'>";
            exit;
        } else {
            $insert = $baglan->query("INSERT INTO gift_codes (code, amount, status) VALUES ('$code', '$amount', '1')");
            if ($insert) {
                echo "<meta http-equiv='refresh' content='0;URL=gift_codes.php?status=success'>";
                exit;
            } else {
                echo "<meta http-equiv='refresh' content='0;URL=gift_codes.php?status=error'>";
                exit;
            }
        }
    } else {
        echo "<meta http-equiv='refresh' content='0;URL=gift_codes.php?status=invalid_amount'>";
        exit;
    }
}

if ($action == "delete") {
    $id = g("id");
    if (!empty($id)) {
        $delete = $baglan->query("DELETE FROM gift_codes WHERE id = '$id'");
        if ($delete) {
            echo "<meta http-equiv='refresh' content='0;URL=gift_codes.php?status=deleted'>";
            exit;
        }
    }
}
?>

<div class="page-header page-header-light border rounded mb-3">
    <div class="page-header-content">
        <div class="page-title d-flex align-items-baseline flex-wrap">
            <h5 class="mb-0">Hediye Kodları</h5>
        </div>
    </div>
</div>

<?php if ($status == "success") { ?>
    <div class="alert alert-success alert-dismissible fade show">
        <span class="fw-semibold">Başarılı:</span> Hediye kodu oluşturuldu.
        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    </div>
<?php } ?>

<?php if ($status == "deleted") { ?>
    <div class="alert alert-success alert-dismissible fade show">
        <span class="fw-semibold">Başarılı:</span> Hediye kodu silindi.
        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    </div>
<?php } ?>

<?php if ($status == "exist") { ?>
    <div class="alert alert-warning alert-dismissible fade show">
        <span class="fw-semibold">Uyarı:</span> Bu kod zaten mevcut.
        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    </div>
<?php } ?>

<?php if ($status == "error") { ?>
    <div class="alert alert-danger alert-dismissible fade show">
        <span class="fw-semibold">Hata:</span> Bir sorun oluştu.
        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    </div>
<?php } ?>

<div class="row">
    <div class="col-md-4">
        <div class="card">
            <div class="card-header">
                <h6 class="mb-0">Yeni Hediye Kodu Oluştur</h6>
            </div>
            <div class="card-body">
                <form action="gift_codes.php?action=add" method="POST">
                    <div class="mb-3">
                        <label class="form-label">Kod (Boş bırakılırsa rastgele oluşturulur)</label>
                        <input type="text" name="code" class="form-control" placeholder="Örn: HEDIYE2024">
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Tutar (TL)</label>
                        <input type="number" name="amount" class="form-control" step="0.01" min="1" required>
                    </div>
                    <div class="text-end">
					<?php if($admin_user_data_pull['username'] == "demo"){?>
<a class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#demo_modal_default"><i class="far fa-check mfi"></i> Oluştur</a>
<?php }else{ ?>
 <button type="submit" class="btn btn-primary">Oluştur</button>
<?php } ?>
                       
                    </div>
                </form>
            </div>
        </div>
    </div>

    <div class="col-md-8">
        <div class="card">
            <div class="card-header">
                <h6 class="mb-0">Hediye Kodları Listesi</h6>
            </div>
            <div class="table-responsive">
                <table class="table table-striped table-hover">
                    <thead>
                        <tr>
                            <th>Kod</th>
                            <th>Tutar</th>
                            <th>Durum</th>
                            <th>Oluşturulma Tarihi</th>
                            <th>Kullanan</th>
                            <th>Kullanım Tarihi</th>
                            <th>İşlem</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php
                        $query = $baglan->query("SELECT * FROM gift_codes ORDER BY id DESC");
                        if ($query->num_rows > 0) {
                            while ($row = $query->fetch_assoc()) {
                                $status_badge = $row['status'] == 1 ? '<span class="badge bg-success">Aktif</span>' : '<span class="badge bg-secondary">Kullanıldı</span>';
                                $used_by = $row['used_by'] ? $row['used_by'] : '-'; // You might want to fetch username here
                                if ($row['used_by']) {
                                    $user_q = $baglan->query("SELECT username FROM users WHERE id = '" . $row['used_by'] . "' LIMIT 1");
                                    if ($user_q->num_rows > 0) {
                                        $user_r = $user_q->fetch_assoc();
                                        $used_by = $user_r['username'];
                                    }
                                }
                                ?>
                                <tr>
                                    <td><strong>
                                            <?php echo htmlspecialchars($row['code']); ?>
                                        </strong></td>
                                    <td>
                                        <?php echo number_format($row['amount'], 2); ?> TL
                                    </td>
                                    <td>
                                        <?php echo $status_badge; ?>
                                    </td>
                                    <td>
                                        <?php echo date("d.m.Y H:i", strtotime($row['created_at'])); ?>
                                    </td>
                                    <td>
                                        <?php echo htmlspecialchars($used_by); ?>
                                    </td>
                                    <td>
                                        <?php echo $row['used_at'] ? date("d.m.Y H:i", strtotime($row['used_at'])) : '-'; ?>
                                    </td>
                                    <td>
										<?php if($admin_user_data_pull['username'] == "demo"){?>
<a class="btn btn-sm btn-danger" data-bs-toggle="modal" data-bs-target="#demo_modal_default"><i class="ph-trash"></i></a>
<?php }else{ ?>
<a href="gift_codes.php?action=delete&id=<?php echo $row['id']; ?>"
                                            class="btn btn-sm btn-danger"
                                            onclick="return confirm('Silmek istediğinize emin misiniz?');"><i
                                                class="ph-trash"></i></a>
<?php } ?>

                                        
                                    </td>
                                </tr>
                                <?php
                            }
                        } else {
                            echo '<tr><td colspan="7" class="text-center">Henüz hediye kodu oluşturulmamış.</td></tr>';
                        }
                        ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<?php include("footer.php"); ?>