<?php
if (basename(__FILE__) == basename($_SERVER['SCRIPT_FILENAME'])) {
    echo "<meta http-equiv='refresh' content='0;URL=/'>";exit;
}
$htaccessFile = __DIR__ . '../../../.htaccess';
$htaccessContent = <<<EOT
RewriteEngine on
RewriteCond %{REQUEST_FILENAME} !-f
RewriteCond \$1 !^(css|js|images|inc|lang)
DirectoryIndex themes/$theme_folder/index.php
RewriteRule ^([a-zA-Z0-9_-]+)$ themes/$theme_folder/pages.php?dataid=$1&ptype=normalpage [L,QSA]
RewriteRule ^product-list/\$ themes/$theme_folder/product_list.php?ptype=product-list [L,QSA]
RewriteRule ^products/?$ themes/default/products.php?ptype=all-products [L,QSA]
RewriteRule ^products/([a-zA-Z0-9-]+)/?$ themes/default/products.php?category=$1&ptype=all-products-category [L,QSA]
RewriteRule ^products/([a-zA-Z0-9-]+)/page/([0-9]+)/?$ themes/default/products.php?category=$1&page=$2&ptype=all-products-page [L,QSA]
RewriteRule ^balance/\$ themes/$theme_folder/balance.php?ptype=balance [L,QSA]
RewriteRule ^register/\$ themes/$theme_folder/register.php?ptype=register [L,QSA]
RewriteRule ^login/\$ themes/$theme_folder/login.php?ptype=login [L,QSA]
RewriteRule ^panel/\$ themes/$theme_folder/panel.php?ptype=panel [L,QSA]
RewriteRule ^account/\$ themes/$theme_folder/account.php?ptype=account [L,QSA]
RewriteRule ^api_detail/\$ themes/$theme_folder/api_detail.php?ptype=api_detail [L,QSA]
RewriteRule ^faqs/\$ themes/$theme_folder/faqs.php?ptype=faqs [L,QSA]
RewriteRule ^orders/$ themes/$theme_folder/orders.php?ptype=orders [L,QSA]
RewriteRule ^orders/([0-9]+)/?$ themes/$theme_folder/orders.php?ptype=orders&order_id=$1 [L,QSA]
RewriteRule ^support/$ themes/$theme_folder/support.php?ptype=support [L,QSA]
RewriteRule ^support/([0-9]+)/?$ themes/$theme_folder/support.php?ptype=support&ticket_id=$1 [L,QSA]
RewriteRule ^exit/\$ themes/$theme_folder/exit.php [L,QSA]
RewriteRule ^robots.txt\$ robots.php [L,QSA]
EOT;
file_put_contents($htaccessFile, $htaccessContent);
?>
