<?php include("header.php");

$level = g("level");
$status = g("status");
$operation = g("operation");
$dataid = g("dataid");

// Silme işlemi
if($level == "delete" && !empty($dataid)){
    $delete_id = intval($dataid);
    $deleted = $baglan->prepare('DELETE FROM api WHERE id=?');
    $deleted->bind_param("i", $delete_id);
    $deleted->execute();
    if($deleted){
        echo '<meta http-equiv="refresh" content="0;URL=api.php?status=successful">';
        exit();
    } else {
        echo '<meta http-equiv="refresh" content="0;URL=api.php?status=error">';
        exit();
    }
}

// Güncelleme işlemi
if($level == "edit" && $operation == "update" && !empty($dataid) && $_SERVER['REQUEST_METHOD'] == 'POST'){
    $id = intval($dataid);
    $name = p("name");
    $url = p("url");
    $api_key = p("api_key");

    $stmt = $baglan->prepare("UPDATE api SET name=?, url=?, api_key=? WHERE id=?");
    $stmt->bind_param("sssi", $name, $url, $api_key, $id);

    if($stmt->execute()){
        echo '<meta http-equiv="refresh" content="0;URL=api.php?status=successful">';
        exit();
    } else {
        echo '<meta http-equiv="refresh" content="0;URL=api.php?status=error">';
        exit();
    }
}

// Yeni ekleme işlemi
if($level == "new" && $operation == "save" && $_SERVER['REQUEST_METHOD'] == 'POST'){
    $name = p("name");
    $url = p("url");
    $api_key = p("api_key");

    $stmt = $baglan->prepare("INSERT INTO api (name, url, api_key) VALUES (?, ?, ?)");
    $stmt->bind_param("sss", $name, $url, $api_key);

    if($stmt->execute()){
        echo '<meta http-equiv="refresh" content="0;URL=api.php?status=successful">';
        exit();
    } else {
        echo '<meta http-equiv="refresh" content="0;URL=api.php?status=error">';
        exit();
    }
}
?>
<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.2.1/jquery.min.js"></script>
<?php if(empty($level)){?>
<div class="page-header page-header-light border rounded mb-3">
    <div class="page-header-content d-flex">
        <div class="page-title">
            <h5 class="mb-0"><i class="fas fa-link"></i> API Servisleri</h5>
        </div>
        <div class="my-auto ms-auto">
            <a href="api.php?level=new" class="btn btn-primary"><i class="ph-plus-circle"></i> Yeni API Ekle</a>
        </div>
    </div>
</div>

<?php if($status == "error"){?>
<div class="col-md-12">
    <div class="alert alert-danger alert-dismissible fade show">
        <span class="fw-semibold">Hata:</span> Bir hata oluştu.
    </div>
</div>
<?php } ?>

<?php if($status == "import_success"){?>
<div class="col-md-12">
    <div class="alert alert-success alert-dismissible fade show">
        <span class="fw-semibold">Başarılı:</span> İşlem başarıyla gerçekleştirildi.
    </div>
</div>
<?php } ?>

<?php if($status == "import_error"){?>
<div class="col-md-12">
    <div class="alert alert-danger alert-dismissible fade show">
        <span class="fw-semibold">Hata:</span> İşlem başarısız oldu.
    </div>
</div>
<?php } ?>

<?php if($status == "successful"){?>
<div class="col-md-12">
    <div class="alert alert-success alert-dismissible fade show">
        <span class="fw-semibold">Başarılı:</span> İşlem başarıyla gerçekleştirildi.
    </div>
</div>
<?php } ?>

<div class="card">
    <div class="table-responsive">
        <table class="table table-bordered align-middle">
            <thead>
                <tr>
                    <th>#</th>
                    <th>API Adı</th>
                    <th>API URL</th>
                    <th>İşlemler</th>
                </tr>
            </thead>
            <tbody>
            <?php
            $sno = 0;
            $apis = $baglan->query("SELECT * FROM api ORDER BY id DESC");
            while ($api = $apis->fetch_assoc()) {
                $sno++;
                $data_id = $api['id'];
                $name = htmlspecialchars($api['name']);
                $url = htmlspecialchars($api['url']);
                echo '
                <tr>
                    <td>'.$sno.'</td>
                    <td>'.$name.'</td>
                    <td>'.$url.'</td>
                    <td>
					<a class="btn btn-primary btn-sm" href="api.php?level=edit&dataid='.$data_id.'"><i class="fas fa-edit mfit"></i> Düzenle</a>
					<a class="btn btn-warning btn-sm" href="api.php?level=pull_products&dataid='.$data_id.'"><i class="fas fa-retweet mfit"></i> Ürün Çek</a>
					';
                if($admin_user_data_pull['username'] == "demo"){
                    echo '<a class="btn btn-danger btn-sm" data-bs-toggle="modal" data-bs-target="#demo_modal_default"><i class="fas fa-times-circle mfit"></i> Sil</a>';
                } else {
                    echo '<a class="btn btn-danger btn-sm" data-bs-toggle="modal" data-bs-target="#delete-modal'.$data_id.'"><i class="fas fa-times-circle mfit"></i> Sil</a>';
                }
                echo '
                    </td>
                </tr>
                <div id="delete-modal'.$data_id.'" class="modal fade" tabindex="-1">
                    <div class="modal-dialog">
                        <div class="modal-content">
                        <div class="modal-header">
                            <h5 class="modal-title">API Sil</h5>
                            <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                        </div>
                        <div class="modal-body">
                            <p>Bu API kaydını silmek istediğinize emin misiniz?</p>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-link" data-bs-dismiss="modal">Kapat</button>
                            <a href="api.php?level=delete&dataid='.$data_id.'" class="btn btn-danger">Evet, Sil</a>
                        </div>
                        </div>
                    </div>
                </div>
                ';
            }
            ?>
            </tbody>
        </table>
    </div>
</div>
<?php } ?>

<?php
// API düzenleme formu
if($level == "edit" && !empty($dataid)){
    $dataid = intval($dataid);
    $pull_data = $baglan->query("SELECT * FROM api WHERE id = '$dataid'")->fetch_assoc();
    if(!$pull_data){
        echo '<div class="alert alert-danger">API kaydı bulunamadı.</div>';
    } else {
        $name = htmlspecialchars($pull_data['name']);
        $url = htmlspecialchars($pull_data['url']);
        $api_key = htmlspecialchars($pull_data['api_key']);
?>
<div class="page-header page-header-light border rounded mb-3">
    <div class="page-header-content d-flex">
        <div class="page-title">
            <h5 class="mb-0"><i class="fas fa-link"></i> API Düzenle: <?php echo "<font color='red'>$name</font>";?></h5>
        </div>
        <div class="my-auto ms-auto">
			<a href="api.php" class="btn btn-warning"><i class="ph-arrow-bend-up-left"></i> Geri Dön</a>
        </div>
    </div>
</div>

<div class="card">
    <div class="card-body">
        <form action="api.php?level=edit&operation=update&dataid=<?php echo $dataid;?>" method="post" enctype="multipart/form-data">
            <div class="row">
                <div class="col-md-4">
                    <div class="mb-3">
                        <label class="form-label">API Adı</label>
                        <input type="text" class="form-control" name="name" value="<?php echo $name;?>" required>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="mb-3">
                        <label class="form-label">API URL</label>
                        <input type="text" class="form-control" name="url" value="<?php echo $url;?>" required>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="mb-3">
                        <label class="form-label">API Key</label>
                        <input type="text" class="form-control" name="api_key" value="<?php echo $api_key;?>" required>
                    </div>
                </div>
                <div class="col-12">
				<?php if($admin_user_data_pull['username'] == "demo"){?>
				<a class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#demo_modal_default">Güncelle <i class="ph-paper-plane-tilt ms-2"></i></a>
				<?php }else{ ?>
				<button type="submit" class="btn btn-primary">Güncelle <i class="ph-paper-plane-tilt ms-2"></i></button>
				<?php } ?>
                </div>
            </div>
        </form>
    </div>
</div>
<?php
    }
}

// Yeni API ekleme formu
if($level == "new"){
?>
<div class="page-header page-header-light border rounded mb-3">
    <div class="page-header-content d-flex">
        <div class="page-title">
            <h5 class="mb-0"><i class="fas fa-link"></i> Yeni API Ekle</h5>
        </div>
        <div class="my-auto ms-auto">
        <a href="api.php" class="btn btn-warning"><i class="ph-arrow-bend-up-left"></i> Geri Dön</a>
        </div>
    </div>
</div>

<div class="card">
    <div class="card-body">
        <form action="api.php?level=new&operation=save" method="post" enctype="multipart/form-data">
            <div class="row">
                <div class="col-md-4">
                    <div class="mb-3">
                        <label class="form-label">API Adı</label>
                        <input type="text" class="form-control" name="name" required>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="mb-3">
                        <label class="form-label">API URL</label>
                        <input type="text" class="form-control" name="url" required>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="mb-3">
                        <label class="form-label">API Key</label>
                        <input type="text" class="form-control" name="api_key" required>
                    </div>
                </div>
                <div class="col-12">
                <?php if($admin_user_data_pull['username'] == "demo"){?>
				<a class="btn btn-success" data-bs-toggle="modal" data-bs-target="#demo_modal_default"><i class="fas fa-save mfit"></i> Kaydet</a>
				<?php }else{ ?>
				<button type="submit" class="btn btn-success"><i class="fas fa-save"></i> Kaydet</button>
				<?php } ?>
                </div>
            </div>
        </form>
    </div>
</div>
<?php } ?>


<?php if($level == "pull_products"){
$api_data = $baglan->query("SELECT * FROM api WHERE id = '$dataid'")->fetch_assoc();
$api_name = $api_data['name'];
$api_url = $api_data['url'];
$api_key = $api_data['api_key'];
$api_image_url = preg_replace('#/api/?$#', '', $api_data['url']);

$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $api_url . "?endpoint=products");
curl_setopt($ch, CURLOPT_POST, 1);
curl_setopt($ch, CURLOPT_POSTFIELDS, "api_key=" . $api_key);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
$response = curl_exec($ch);
curl_close($ch);
$products = json_decode($response, true);
?>
<div class="page-header page-header-light border rounded mb-3">
    <div class="page-header-content d-flex">
        <div class="page-title">
            <h5 class="mb-0"><?php echo htmlspecialchars($api_name); ?> - Api Ürünleri</h5>
        </div>
        <div class="my-auto ms-auto">
            <a href="api.php" class="btn btn-warning"><i class="ph-arrow-bend-up-left"></i> Geri Dön</a>
        </div>
    </div>
</div>

<?php
// Kategori verilerini çek
$categories = [];
$cat_query = $baglan->query("SELECT id, title FROM category");
while($cat = $cat_query->fetch_assoc()) {
    $categories[] = $cat;
}
?>
<div class="card">
    <div class="card-header d-flex flex-wrap align-items-center">
        <div class="form-check form-check-inline me-3">
            <input type="checkbox" class="form-check-input" id="hideDescription" onchange="toggleColumn('description')">
            <label class="form-check-label" for="hideDescription">Açıklamaları Gizle</label>
        </div>
        <div class="form-check form-check-inline me-3">
            <input type="checkbox" class="form-check-input" id="hideImage" onchange="toggleColumn('image')">
            <label class="form-check-label" for="hideImage">Resimleri Gizle</label>
        </div>
		
		<?php if($admin_user_data_pull['username'] == "demo"){?>
				    <button type="button" class="btn btn-success ms-auto" id="bulkImportBtn" data-bs-toggle="modal" data-bs-target="#demo_modal_default" disabled>
            <i class="fas fa-plus mfit"></i> Seçilenleri Ekle
        </button>
				<?php }else{ ?>
				    <button type="button" class="btn btn-success ms-auto" id="bulkImportBtn" data-bs-toggle="modal" data-bs-target="#bulkImportModal" disabled>
            <i class="fas fa-plus mfit"></i> Seçilenleri Ekle
        </button>
				<?php } ?>
				
    
    </div>
    <?php
    // Eğer ürünler çekilemediyse veya dizi değilse, tabloyu gösterme ve uyarı ver
    if(!is_array($products) || empty($products)) {
        echo '<div class="alert alert-danger mt-3">Api verilerine ulaşılamadı.</div>';
    } else {
    ?>
    <div class="table-responsive">
        <table class="table table-bordered align-middle" id="productsTable">
            <thead>
                <tr>
                    <th>
                        <input type="checkbox" id="selectAllProducts" onclick="toggleSelectAllProducts(this)">
                    </th>
                    <th>#</th>
                    <th>Ürün ID</th>
                    <th>Başlık</th>
                    <th class="description-column">Açıklama</th>
                    <th>Kategori</th>
                    <th>Fiyat</th>
                    <th class="image-column">Resim</th>
                    <th>İşlem</th>
                </tr>
            </thead>
            <tbody>
            <?php
                // Ürünleri kategoriye göre grupla
                $grouped_products = [];
                foreach($products as $product) {
                    $cat_title = isset($product['category']) ? trim($product['category']) : 'Diğer';
                    if (!isset($grouped_products[$cat_title])) {
                        $grouped_products[$cat_title] = [];
                    }
                    $grouped_products[$cat_title][] = $product;
                }

                $sno = 0;
                foreach($grouped_products as $cat_title => $cat_products) {
                    // Kategori başlığı için bir satır ekle
                    echo '<tr class="table-primary"><td colspan="9" style="font-weight:bold;font-size:1.1em;">'.htmlspecialchars($cat_title).'</td></tr>';
                    foreach($cat_products as $product) {
                        $sno++;
                        $modalId = "modal-".$sno;
                        $rowId = "row-".$sno;
                        echo '
                        <tr id="'.$rowId.'">
                            <td>
                                <input type="checkbox" class="product-checkbox" value="'.htmlspecialchars($product['id']).'" data-title="'.htmlspecialchars($product['title']).'" data-content="'.htmlspecialchars($product['content']).'" data-category="'.htmlspecialchars($product['category']).'" data-price="'.htmlspecialchars($product['price']).'" data-image="'.htmlspecialchars($product['image']).'">
                            </td>
                            <td>'.$sno.'</td>
                            <td>'.htmlspecialchars($product['id']).'</td>
                            <td>'.htmlspecialchars($product['title']).'</td>
                            <td class="description-column">'.htmlspecialchars($product['content']).'</td>
                            <td>'.htmlspecialchars($product['category']).'</td>
                            <td>'.htmlspecialchars($product['price']).'</td>
							';
							if(empty($product['image'])){echo '<td class="image-column"><img src="images/noimg.png" height="50"></td>';}
							else{echo '<td class="image-column"><img src="'.$api_image_url.'/'.htmlspecialchars($product['image']).'" height="50"></td>';}
                            
							echo '
                            <td>
							';
							
				if($admin_user_data_pull['username'] == "demo"){ 
				echo '
				<button type="button" class="btn btn-sm btn-warning my-1 me-2" data-bs-toggle="modal" data-bs-target="#demo_modal_default">
				<i class="fas fa-link mfit"></i> Ürünü Çek
				</button>
				';}else{
				echo '
				<button type="button" class="btn btn-sm btn-warning my-1 me-2" data-bs-toggle="modal" data-bs-target="#'.$modalId.'">
				<i class="fas fa-link mfit"></i> Ürünü Çek
				</button>
				';
				}
				
                              
							echo '
                            </td>
                        </tr>
                        <div id="'.$modalId.'" class="modal fade" tabindex="-1">
                            <div class="modal-dialog">
                                <form method="post" enctype="multipart/form-data" action="api.php?level=pull_products&dataid='.intval($dataid).'&import_product=1&api_product_id='.urlencode($product['id']).'">
                                    <div class="modal-content">
                                        <div class="modal-header">
                                            <h5 class="modal-title">Ürünü Ekle</h5>
                                            <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                                        </div>
                                        <div class="modal-body">
                                            <div class="mb-3">
                                                <label class="form-label">Başlık</label>
                                                <input type="text" class="form-control" name="title" value="'.htmlspecialchars($product['title']).'" required>
                                            </div>
                                            <div class="mb-3">
                                                <label class="form-label">Açıklama</label>
                                                <textarea class="form-control" name="content" rows="3" required>'.htmlspecialchars($product['content']).'</textarea>
                                            </div>
                                            <div class="mb-3">
                                                <label class="form-label">Kategori</label>
                                                <select class="form-select" name="category" required>
                                                    <option value="">Seçiniz</option>';
                                                    foreach($categories as $cat) {
                                                        $selected = (trim($product['category']) == trim($cat['title'])) ? 'selected' : '';
                                                        echo '<option value="'.htmlspecialchars($cat['id']).'" '.$selected.'>'.htmlspecialchars($cat['title']).'</option>';
                                                    }
                        echo '                  </select>
                                            </div>
                                            <div class="mb-3">
                                                <label class="form-label">Fiyat</label>
                                                <input type="text" class="form-control" name="price" value="'.htmlspecialchars($product['price']).'" required>
                                            </div>
                                            <div class="mb-3">
                                                <label class="form-label">Resim</label>
                                                <div class="d-flex align-items-center">
                                                    <div class="flex-grow-1">
                                                        <div class="form-check mb-2">
                                                            <input class="form-check-input" type="radio" name="image_option" id="imageInclude-'.$sno.'" value="include" checked>
                                                            <label class="form-check-label" for="imageInclude-'.$sno.'">Resmi Dahil Et (URL&#39;den indir)</label>
                                                        </div>
                                                        <div class="form-check">
                                                            <input class="form-check-input" type="radio" name="image_option" id="imageExclude-'.$sno.'" value="exclude">
                                                            <label class="form-check-label" for="imageExclude-'.$sno.'">Resmi Dahil Etme</label>
                                                        </div>
                                                    </div>
                                                    <div class="ms-4 text-end">
                                                        <img src="'.$api_image_url.'/'.htmlspecialchars($product['image']).'" height="50" class="border rounded">
                                                        <input type="hidden" name="image_url" value="'.$api_image_url.'/'.htmlspecialchars($product['image']).'">
                                                    </div>
                                                </div>
                                            </div>

                                             <div class="mb-3">
                                             <div class="alert alert-secondary border-0 alert-dismissible fade show">
                                            Bu ürün otomatik gönderim için eklenecektir. Eğer stoğunuzda bu ürüne ait stok varsa sistem önce stoğunuzdan teslimat yapacaktır. Eğer stoğunuzda yoksa api servisinden otomatik teslimat yapacaktır.
                                            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                                        </div>
                                            </div>

                                        </div>
                                        <div class="modal-footer">
                                            <button type="button" class="btn btn-link" data-bs-dismiss="modal">Kapat</button>
                                            <button type="submit" class="btn btn-success">Evet, Ekle</button>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>
                        ';
                    }
                }
            ?>
            </tbody>
        </table>
    </div>
    <?php } ?>
</div>

<!-- Toplu Ekleme Modalı -->
<div class="modal fade" id="bulkImportModal" tabindex="-1" aria-labelledby="bulkImportModalLabel" aria-hidden="true">
  <div class="modal-dialog">
    <form id="bulkImportForm" method="post" action="api.php?level=pull_products&dataid=<?php echo intval($dataid); ?>&bulk_import=1">
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title" id="bulkImportModalLabel">Seçilen Ürünleri Toplu Ekle</h5>
          <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
        </div>
        <div class="modal-body">
            <div class="mb-3">
                <label class="form-label">Kategori</label>
                <select class="form-select" name="bulk_category" id="bulk_category" required>
                    <option value="">Seçiniz</option>
                    <?php foreach($categories as $cat) {
                        echo '<option value="'.htmlspecialchars($cat['id']).'">'.htmlspecialchars($cat['title']).'</option>';
                    } ?>
                </select>
            </div>
            <div class="mb-3">
                <label class="form-label">Kar Oranı (%)</label>
                <input type="number" class="form-control" name="bulk_profit" id="bulk_profit" min="0" max="100" value="0" required>
            </div>
            <div class="mb-3">
                <label class="form-label">Resim</label>
                <div class="form-check">
                    <input class="form-check-input" type="radio" name="bulk_image_option" id="bulkImageInclude" value="include" checked>
                    <label class="form-check-label" for="bulkImageInclude">Resimleri Dahil Et (URL'den indir)</label>
                </div>
                <div class="form-check">
                    <input class="form-check-input" type="radio" name="bulk_image_option" id="bulkImageExclude" value="exclude">
                    <label class="form-check-label" for="bulkImageExclude">Resimleri Dahil Etme</label>
                </div>
            </div>
            <input type="hidden" name="selected_products" id="selected_products_input">
            <div class="alert alert-info">
                Seçilen ürünler seçtiğiniz kategoriye eklenecek ve fiyatlarına belirttiğiniz kar oranı eklenecektir.
            </div>
        </div>
        <div class="modal-footer">
          <button type="button" class="btn btn-link" data-bs-dismiss="modal">İptal</button>
          <button type="submit" class="btn btn-success">Toplu Ekle</button>
        </div>
      </div>
    </form>
  </div>
</div>

<script>
function toggleSelectAllProducts(source) {
    const checkboxes = document.querySelectorAll('.product-checkbox');
    checkboxes.forEach(cb => { cb.checked = source.checked; });
    updateBulkImportBtn();
}
function updateBulkImportBtn() {
    const checked = document.querySelectorAll('.product-checkbox:checked').length;
    document.getElementById('bulkImportBtn').disabled = checked === 0;
}
document.addEventListener('DOMContentLoaded', function() {
    document.querySelectorAll('.product-checkbox').forEach(cb => {
        cb.addEventListener('change', updateBulkImportBtn);
    });
    // Modal açılmadan önce seçili ürünleri inputa yaz
    document.getElementById('bulkImportBtn').addEventListener('click', function() {
        const selected = [];
        document.querySelectorAll('.product-checkbox:checked').forEach(cb => {
            selected.push({
                id: cb.value,
                title: cb.getAttribute('data-title'),
                content: cb.getAttribute('data-content'),
                category: cb.getAttribute('data-category'),
                price: cb.getAttribute('data-price'),
                image: cb.getAttribute('data-image')
            });
        });
        document.getElementById('selected_products_input').value = JSON.stringify(selected);
    });
});
</script>

<?php
// Ürün ekleme işlemi
if(isset($_GET['import_product']) && $_GET['import_product'] == 1 && isset($_GET['api_product_id']) && $_SERVER['REQUEST_METHOD'] == 'POST') {
    $title = trim(p("title"));
    $content = trim(p("content"));
    $category = intval(p("category"));
    $price = trim(p("price"));
    $image_option = p("image_option");
    $image_url = trim(p("image_url"));
    $api_product_id = $_GET['api_product_id'];
    $api_provider_id = intval($dataid);

    $image_path = null;
    if($image_option == "include" && !empty($image_url)) {
		
$img_data = @file_get_contents($image_url);

if ($img_data !== false) {
    // MIME türünü tespit et
    $finfo = new finfo(FILEINFO_MIME_TYPE);
    $mime_type = $finfo->buffer($img_data);

    // Geçerli MIME türleri ve uzantı eşleşmeleri
    $mime_to_ext = [
        'image/jpeg' => 'jpg',
        'image/png'  => 'png',
        'image/gif'  => 'gif',
        'image/webp' => 'webp',
    ];

    // Maksimum boyut (64 KB)
    $max_size = 64 * 1024;

    // Kontroller
    if (isset($mime_to_ext[$mime_type]) && strlen($img_data) <= $max_size) {
        // Gerçekten bir resim mi?
        $image = @imagecreatefromstring($img_data);
        if ($image !== false) {
            $ext = $mime_to_ext[$mime_type];
            $rand_name = bin2hex(random_bytes(4)) . '.' . $ext;
            $save_path = __DIR__ . "/../images/" . $rand_name;

            // MIME türüne göre doğru kaydetme işlemi
            switch ($ext) {
                case 'jpg':
                    imagejpeg($image, $save_path, 90); break;
                case 'png':
                    imagepng($image, $save_path); break;
                case 'gif':
                    imagegif($image, $save_path); break;
                case 'webp':
                    imagewebp($image, $save_path); break;
            }

            imagedestroy($image);

            if (file_exists($save_path)) {
                $image_path = "images/" . $rand_name;
                echo "Yüklendi: " . htmlspecialchars($image_path);
            }
        }
    }
}
		
    }
    // Dahil etme seçildiyse image_path null kalır

    $stmt = $baglan->prepare("INSERT INTO products (title, content, image, category, price, api_provider_id, api_product_id) VALUES (?, ?, ?, ?, ?, ?, ?)");
    $stmt->bind_param("sssdsis", $title, $content, $image_path, $category, $price, $api_provider_id, $api_product_id);
    if($stmt->execute()) {
        echo '<meta http-equiv="refresh" content="0;URL=api.php?status=import_success">';
        exit();
    } else {
        echo '<meta http-equiv="refresh" content="0;URL=api.php?status=import_error">';
        exit();
    }
}

// Toplu ürün ekleme işlemi
if (
    isset($_GET['bulk_import']) && $_GET['bulk_import'] == 1 &&
    $_SERVER['REQUEST_METHOD'] == 'POST' &&
    isset($_POST['selected_products']) && !empty($_POST['selected_products']) &&
    isset($_POST['bulk_category']) && is_numeric($_POST['bulk_category']) &&
    isset($_POST['bulk_profit']) && is_numeric($_POST['bulk_profit']) &&
    isset($_POST['bulk_image_option'])
) {
    $bulk_category = intval($_POST['bulk_category']);
    $bulk_profit = floatval($_POST['bulk_profit']);
    $bulk_image_option = $_POST['bulk_image_option']; // "include" veya "exclude"
    $api_provider_id = intval($dataid);

    // Seçili ürünler JSON olarak geliyor
    $selected_products = json_decode($_POST['selected_products'], true);

    $success_count = 0;
    $fail_count = 0;

    if (is_array($selected_products) && count($selected_products) > 0) {
        foreach ($selected_products as $product) {
            $title = isset($product['title']) ? trim($product['title']) : '';
            $content = isset($product['content']) ? trim($product['content']) : '';
            $api_product_id = isset($product['id']) ? $product['id'] : '';
            $price = isset($product['price']) ? floatval($product['price']) : 0;
            $image_url = isset($product['image']) ? $api_image_url . '/' . $product['image'] : '';
            $image_path = null;

            // Kar oranı uygula
            if ($bulk_profit > 0) {
                $price = $price + ($price * $bulk_profit / 100);
                $price = round($price, 2);
            }

            // bulk_image_option kontrolü
            if ($bulk_image_option === "include" && !empty($image_url)) {
$img_data = @file_get_contents($image_url);

if ($img_data !== false) {
    // MIME türünü tespit et
    $finfo = new finfo(FILEINFO_MIME_TYPE);
    $mime_type = $finfo->buffer($img_data);

    // Geçerli MIME türleri ve uzantı eşleşmeleri
    $mime_to_ext = [
        'image/jpeg' => 'jpg',
        'image/png'  => 'png',
        'image/gif'  => 'gif',
        'image/webp' => 'webp',
    ];

   // Maksimum boyut (64 KB)
   $max_size = 64 * 1024;

    // Kontroller
    if (isset($mime_to_ext[$mime_type]) && strlen($img_data) <= $max_size) {
        // Gerçekten bir resim mi?
        $image = @imagecreatefromstring($img_data);
        if ($image !== false) {
            $ext = $mime_to_ext[$mime_type];
            $rand_name = bin2hex(random_bytes(4)) . '.' . $ext;
            $save_path = __DIR__ . "/../images/" . $rand_name;

            // MIME türüne göre doğru kaydetme işlemi
            switch ($ext) {
                case 'jpg':
                    imagejpeg($image, $save_path, 90); break;
                case 'png':
                    imagepng($image, $save_path); break;
                case 'gif':
                    imagegif($image, $save_path); break;
                case 'webp':
                    imagewebp($image, $save_path); break;
            }

            imagedestroy($image);

            if (file_exists($save_path)) {
                $image_path = "images/" . $rand_name;
                echo "Yüklendi: " . htmlspecialchars($image_path);
            }
        }
    }
}
            }
            // Eğer "exclude" ise image_path null kalır ve resim eklenmez

            // Veritabanına ekle
            $stmt = $baglan->prepare("INSERT INTO products (title, content, image, category, price, api_provider_id, api_product_id) VALUES (?, ?, ?, ?, ?, ?, ?)");
            $stmt->bind_param("sssdsis", $title, $content, $image_path, $bulk_category, $price, $api_provider_id, $api_product_id);
            if($stmt->execute()) {
                $success_count++;
            } else {
                $fail_count++;
            }
        }
    }

    // Sonuç mesajı ve yönlendirme
    $status = ($fail_count == 0) ? 'bulk_import_success' : 'bulk_import_partial';
    echo '<meta http-equiv="refresh" content="0;URL=api.php?level=pull_products&dataid='.$api_provider_id.'&status='.$status.'&success='.$success_count.'&fail='.$fail_count.'">';
    exit();
}
?>

<script>
function toggleColumn(columnType) {
    const elements = document.getElementsByClassName(columnType + '-column');
    const isChecked = document.getElementById('hide' + columnType.charAt(0).toUpperCase() + columnType.slice(1)).checked;
    
    for(let element of elements) {
        element.style.display = isChecked ? 'none' : '';
    }
}
</script>
<?php } ?>

<?php include("footer.php");?>